/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.media;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.signal.libsignal.media.TrustedSkipInputStream;

class GuaranteedSkipInputStream
extends FilterInputStream
implements TrustedSkipInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;

    public GuaranteedSkipInputStream(InputStream in) {
        super(in);
    }

    @Override
    public long skip(long amount) throws IOException {
        long amountSkipped;
        long remaining = amount;
        if (remaining <= 0L) {
            return 0L;
        }
        while ((amountSkipped = super.skip(remaining)) != 0L && (remaining -= amountSkipped) > 0L) {
        }
        if (remaining > 0L) {
            long amountRead;
            byte[] skipBuf = new byte[2048];
            while ((amountRead = (long)this.read(skipBuf, 0, (int)Math.min(remaining, (long)skipBuf.length))) != -1L && (remaining -= amountRead) > 0L) {
            }
        }
        return amount - remaining;
    }
}

