import React from 'react';
import { Operation } from './Operation';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { OPERATIONS_TEXT } from '../../constants';
import { PayloadType } from '../../types';
export var Operations = function () {
    var channels = useSpec().channels();
    var config = useConfig();
    if (!Object.keys(channels).length) {
        return null;
    }
    var operationsList = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish()) {
            operationsList.push(React.createElement("li", { className: "mb-12", key: "pub-".concat(channelName), id: CommonHelpers.getIdentifier("operation-".concat(PayloadType.PUBLISH, "-").concat(channelName), config) },
                React.createElement(Operation, { type: PayloadType.PUBLISH, operation: channel.publish(), channelName: channelName, channel: channel })));
        }
        if (channel.hasSubscribe()) {
            operationsList.push(React.createElement("li", { className: "mb-12", key: "sub-".concat(channelName), id: CommonHelpers.getIdentifier("operation-".concat(PayloadType.SUBSCRIBE, "-").concat(channelName), config) },
                React.createElement(Operation, { type: PayloadType.SUBSCRIBE, operation: channel.subscribe(), channelName: channelName, channel: channel })));
        }
    });
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('operations', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, OPERATIONS_TEXT),
        React.createElement("ul", null, operationsList)));
};
//# sourceMappingURL=Operations.js.map