"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Info = void 0;
var react_1 = __importDefault(require("react"));
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var constants_1 = require("../../constants");
var Info = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var info = asyncapi.info();
    if (!info) {
        return null;
    }
    var specId = asyncapi.id();
    var externalDocs = asyncapi.externalDocs();
    var license = info.license();
    var termsOfService = info.termsOfService();
    var defaultContentType = asyncapi.defaultContentType();
    var contact = info.contact();
    var showInfoList = license || termsOfService || defaultContentType || contact || externalDocs;
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center px-8 text-left", id: "introduction" },
            react_1.default.createElement("div", { className: "text-4xl" },
                info.title(),
                "\u00A0",
                info.version()),
            showInfoList && (react_1.default.createElement("ul", { className: "flex flex-wrap mt-2 leading-normal" },
                license && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" }, license.url() ? (react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: license.url() },
                    react_1.default.createElement("span", null, license.name()))) : (react_1.default.createElement("span", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1" }, license.name())))),
                termsOfService && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: termsOfService },
                        react_1.default.createElement("span", null, constants_1.TERMS_OF_SERVICE_TEXT)))),
                defaultContentType && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(constants_1.CONTENT_TYPES_SITE, "/").concat(defaultContentType) },
                        react_1.default.createElement("span", null, defaultContentType)))),
                externalDocs && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                        react_1.default.createElement("span", null, constants_1.EXTERAL_DOCUMENTATION_TEXT)))),
                contact && (react_1.default.createElement(react_1.default.Fragment, null,
                    contact.url() && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: contact.url() },
                            react_1.default.createElement("span", null, contact.name() || constants_1.URL_SUPPORT_TEXT)))),
                    contact.email() && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "mailto:".concat(contact.email()) },
                            react_1.default.createElement("span", null, contact.email())))))),
                specId && (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2" },
                    react_1.default.createElement("span", { className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs uppercase rounded px-3 py-1" },
                        "ID: ",
                        specId))))),
            info.hasDescription() && (react_1.default.createElement("div", { className: "mt-4" },
                react_1.default.createElement(components_1.Markdown, null, info.description()))),
            asyncapi.hasTags() && (react_1.default.createElement("div", { className: "mt-4" },
                react_1.default.createElement(components_1.Tags, { tags: asyncapi.tags() })))),
        react_1.default.createElement("div", { className: "panel-item--right" })));
};
exports.Info = Info;
//# sourceMappingURL=Info.js.map