/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.composeFile.ComposeFileServicesIndex;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000b*\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0015\u0010\u0013\u001a\u00020\u000b2\u000b\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\u0015H\u0000\u001a\u0015\u0010\u0016\u001a\u00020\u000b2\u000b\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\u0015H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"fromComposeFile", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "findFirstNotNullComposeStatus", "Lcom/intellij/docker/runtimes/ComposeServiceStatus;", "project", "Lcom/intellij/openapi/project/Project;", "composeProject", "", "composeService", "isFromComposeFile", "", "element", "getComposeProjectName", "isDockerComposeFile", "Lcom/intellij/psi/PsiFile;", "isDockerComposeYamlFile", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "isDockerComposeYamlFileName", "fileName", "Lorg/jetbrains/annotations/NonNls;", "isComposeYamlFileName", "isYaml", "intellij.clouds.docker.compose"})
@JvmName(name="ComposeFileUtil")
@SourceDebugExtension(value={"SMAP\nComposeFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeFileUtil.kt\ncom/intellij/docker/composeFile/ComposeFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class ComposeFileUtil {
    @NotNull
    public static final PatternCondition<PsiElement> fromComposeFile() {
        return (PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return ComposeFileUtil.isFromComposeFile(element);
            }
        };
    }

    @Nullable
    public static final ComposeServiceStatus findFirstNotNullComposeStatus(@NotNull Project project, @NotNull String composeProject, @NotNull String composeService) {
        ComposeServiceStatus composeServiceStatus;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)composeProject, (String)"composeProject");
            Intrinsics.checkNotNullParameter((Object)composeService, (String)"composeService");
            for (DockerRuntimesManager it : (Iterable)DockerServerRuntimesManager.Companion.getConnectedManagers(project)) {
                boolean bl = false;
                ComposeServiceRuntime composeServiceRuntime = it.findComposeService(composeProject, composeService);
                ComposeServiceStatus composeServiceStatus2 = composeServiceRuntime != null ? composeServiceRuntime.getServiceStatus() : null;
                if (composeServiceStatus2 == null) continue;
                composeServiceStatus = composeServiceStatus2;
                break block1;
            }
            composeServiceStatus = null;
        }
        return composeServiceStatus;
    }

    public static final boolean isFromComposeFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return ComposeFileUtil.isDockerComposeFile(psiFile);
    }

    @Nullable
    public static final String getComposeProjectName(@NotNull PsiElement element) {
        Object object;
        block8: {
            VirtualFile parent;
            block7: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!ComposeFileUtil.isFromComposeFile(element)) {
                    return null;
                }
                VirtualFile virtualFile = element.getContainingFile().getOriginalFile().getVirtualFile();
                if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                    return null;
                }
                parent = virtualFile;
                try {
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)parent.toNioPath());
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if ((object = (Path)(Result.isFailure-impl((Object)object2) ? null : object2)) == null) break block7;
                Path path = object;
                boolean bl = false;
                String string = ComposeApplicationRuntime.Companion.computeEnvVarAwareProjectName$default(ComposeApplicationRuntime.Companion, path, null, 2, null);
                object = string;
                if (string != null) break block8;
            }
            String string = parent.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object = ComposeApplicationRuntime.Companion.computeErasedProjectName(string);
        }
        return object;
    }

    public static final boolean isDockerComposeFile(@NotNull PsiFile $this$isDockerComposeFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isDockerComposeFile, (String)"<this>");
        return $this$isDockerComposeFile instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)$this$isDockerComposeFile);
    }

    public static final boolean isDockerComposeYamlFile(@NotNull YAMLFile yamlFile) {
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        return ComposeFileServicesIndex.Companion.getInstance().isDockerComposeFile(yamlFile);
    }

    public static final boolean isDockerComposeYamlFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerCaseName = string;
        return ComposeFileUtil.isYaml(lowerCaseName) && StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"docker-compose", (boolean)false, (int)2, null);
    }

    public static final boolean isComposeYamlFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerCaseName = string;
        return ComposeFileUtil.isYaml(lowerCaseName) && StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"compose", (boolean)false, (int)2, null);
    }

    private static final boolean isYaml(String fileName) {
        return StringsKt.endsWith$default((String)fileName, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".yml", (boolean)false, (int)2, null);
    }
}

