/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.dockerjava.api.model.DockerObject;
import com.intellij.docker.agent.fix.DockerObjectDeserializerCopy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H\u0000\u00a8\u0006\u0006"}, d2={"createDockerClientObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "initializer", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "intellij.clouds.docker.agent"})
public final class FixedObjectMapperKt {
    @NotNull
    public static final ObjectMapper createDockerClientObjectMapper(@NotNull Function1<? super ObjectMapper, Unit> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"disable(...)");
        ObjectMapper objectMapper2 = objectMapper;
        initializer.invoke((Object)objectMapper2);
        ObjectMapper originalObjectMapper = objectMapper2.copy();
        objectMapper2.registerModule((Module)new SimpleModule(originalObjectMapper){
            final /* synthetic */ ObjectMapper $originalObjectMapper;
            {
                this.$originalObjectMapper = $originalObjectMapper;
                super("docker-java");
            }

            public void setupModule(Module.SetupContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.setupModule(context);
                context.addBeanDeserializerModifier(new BeanDeserializerModifier(this.$originalObjectMapper){
                    final /* synthetic */ ObjectMapper $originalObjectMapper;
                    {
                        this.$originalObjectMapper = $originalObjectMapper;
                    }

                    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config2, BeanDescription beanDescription, JsonDeserializer<?> originalDeserializer) {
                        Intrinsics.checkNotNullParameter((Object)beanDescription, (String)"beanDescription");
                        Intrinsics.checkNotNullParameter(originalDeserializer, (String)"originalDeserializer");
                        if (!beanDescription.getType().isTypeOrSubTypeOf(DockerObject.class)) {
                            return originalDeserializer;
                        }
                        ObjectMapper objectMapper = this.$originalObjectMapper;
                        Intrinsics.checkNotNull((Object)objectMapper);
                        return (JsonDeserializer)new DockerObjectDeserializerCopy(originalDeserializer, beanDescription, objectMapper);
                    }
                });
            }
        });
        return objectMapper2;
    }
}

