/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.ExpirableTokenProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.hyperlinks.CompositeFilterWrapper;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImplKt;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/terminal/block/hyperlinks/Gen1TerminalHyperlinkHighlighter;", "", "project", "Lcom/intellij/openapi/project/Project;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lcom/intellij/openapi/Disposable;)V", "filterWrapper", "Lorg/jetbrains/plugins/terminal/block/hyperlinks/CompositeFilterWrapper;", "lastUpdatedBlockInfo", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "Lcom/intellij/execution/impl/ExpirableTokenProvider;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "hyperlinkSupport", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "getHyperlinkSupport", "()Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "rehighlightAll", "", "highlightHyperlinks", "block", "Companion", "intellij.terminal"})
public final class Gen1TerminalHyperlinkHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final CompositeFilterWrapper filterWrapper;
    @Nullable
    private Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> lastUpdatedBlockInfo;

    public Gen1TerminalHyperlinkHighlighter(@NotNull Project project, @NotNull TerminalOutputModel outputModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.outputModel = outputModel;
        this.filterWrapper = new CompositeFilterWrapper(project, Gen1TerminalHyperlinkHighlighter.Companion.createCoroutineScope(project, parentDisposable));
        this.filterWrapper.addFiltersUpdatedListener((Function0<Unit>)((Function0)() -> Gen1TerminalHyperlinkHighlighter._init_$lambda$0(this)));
    }

    private final EditorEx getEditor() {
        return this.outputModel.getEditor();
    }

    private final DocumentEx getDocument() {
        DocumentEx documentEx = this.outputModel.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return documentEx;
    }

    private final EditorHyperlinkSupport getHyperlinkSupport() {
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)((Editor)this.getEditor()));
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        return editorHyperlinkSupport;
    }

    private final void rehighlightAll() {
        for (CommandBlock block : this.outputModel.getBlocks()) {
            this.highlightHyperlinks(block);
        }
    }

    @RequiresEdt
    public final void highlightHyperlinks(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        CompositeFilter compositeFilter = this.filterWrapper.getFilter();
        if (compositeFilter == null) {
            return;
        }
        CompositeFilter filter = compositeFilter;
        Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> pair = this.lastUpdatedBlockInfo;
        if (pair != null) {
            Pair<? extends CommandBlock, ? extends ExpirableTokenProvider> it = pair;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getFirst(), (Object)block)) {
                ((ExpirableTokenProvider)it.getSecond()).invalidateAll();
            }
        }
        ExpirableTokenProvider expirableTokenProvider = new ExpirableTokenProvider();
        this.lastUpdatedBlockInfo = TuplesKt.to((Object)block, (Object)expirableTokenProvider);
        this.getHyperlinkSupport().clearHyperlinks(block.getOutputStartOffset(), block.getEndOffset());
        if (CommandBlockImplKt.getWithOutput(block)) {
            int startLine = this.getDocument().getLineNumber(block.getOutputStartOffset());
            int endLine = this.getDocument().getLineNumber(block.getEndOffset());
            this.getHyperlinkSupport().highlightHyperlinksLater((Filter)filter, startLine, endLine, expirableTokenProvider.createExpirable());
        }
    }

    private static final Unit _init_$lambda$0(Gen1TerminalHyperlinkHighlighter this$0) {
        this$0.rehighlightAll();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/hyperlinks/Gen1TerminalHyperlinkHighlighter$Companion;", "", "<init>", "()V", "createCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        private final CoroutineScope createCoroutineScope(Project project, Disposable disposable) {
            CoroutineScope coroutineScope;
            CoroutineScope coroutineScope2 = TerminalCoroutineKt.terminalProjectScope(project);
            String string = Gen1TerminalHyperlinkHighlighter.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            CoroutineScope it = coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope2, (String)string, null, (boolean)false, (int)6, null);
            boolean bl = false;
            Disposer.register((Disposable)disposable, () -> Companion.createCoroutineScope$lambda$1$lambda$0(it));
            return coroutineScope;
        }

        private static final void createCoroutineScope$lambda$1$lambda$0(CoroutineScope $it) {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$it, null, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

