/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.terminal.session.TerminalClearBufferEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalResizeEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalWriteBytesEvent;
import com.intellij.terminal.session.dto.TerminalSizeDtoKt;
import com.jediterm.core.util.TermSize;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J1\u0010\u0018\u001a\u00020\u000e2\"\u0010\u0019\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput;", "", "terminalSessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/util/concurrent/CompletableFuture;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "synchronousDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "sendString", "", "data", "", "sendBracketedString", "sendBytes", "", "sendClearBuffer", "sendResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "withTerminalSession", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function2;)V", "Companion", "intellij.terminal.frontend"})
public final class TerminalInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<TerminalSession> terminalSessionFuture;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher synchronousDispatcher;
    @NotNull
    private static final DataKey<TerminalInput> KEY = DataKey.Companion.create("TerminalInput");

    public TerminalInput(@NotNull CompletableFuture<TerminalSession> terminalSessionFuture, @NotNull TerminalSessionModel sessionModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(terminalSessionFuture, (String)"terminalSessionFuture");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.terminalSessionFuture = terminalSessionFuture;
        this.sessionModel = sessionModel;
        this.coroutineScope = coroutineScope;
        this.synchronousDispatcher = Dispatchers.getDefault().limitedParallelism(1);
    }

    public final void sendString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.sendBytes(byArray);
    }

    public final void sendBracketedString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((TerminalState)this.sessionModel.getTerminalState().getValue()).isBracketedPasteMode()) {
            this.sendString("\u001b[200~" + data + "\u001b[201~");
        } else {
            this.sendString(data);
        }
    }

    public final void sendBytes(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.withTerminalSession((Function2<? super TerminalSession, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<TerminalSession, Continuation<? super Unit>, Object>(data, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ byte[] $data;
            {
                this.$data = $data;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TerminalSession session2 = (TerminalSession)this.L$0;
                        this.label = 1;
                        Object object3 = session2.sendInputEvent((TerminalInputEvent)new TerminalWriteBytesEvent(this.$data), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(TerminalSession p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void sendClearBuffer() {
        this.withTerminalSession((Function2<? super TerminalSession, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<TerminalSession, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TerminalSession session2 = (TerminalSession)this.L$0;
                        this.label = 1;
                        Object object3 = session2.sendInputEvent((TerminalInputEvent)TerminalClearBufferEvent.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(TerminalSession p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void sendResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        TerminalSession terminalSession = this.terminalSessionFuture.getNow(null);
        if (terminalSession == null) {
            return;
        }
        TerminalSession session2 = terminalSession;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)this.synchronousDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, newSize, null){
            int label;
            final /* synthetic */ TerminalSession $session;
            final /* synthetic */ TermSize $newSize;
            {
                this.$session = $session;
                this.$newSize = $newSize;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$session.sendInputEvent((TerminalInputEvent)new TerminalResizeEvent(TerminalSizeDtoKt.toDto((TermSize)this.$newSize)), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void withTerminalSession(Function2<? super TerminalSession, ? super Continuation<? super Unit>, ? extends Object> block) {
        this.terminalSessionFuture.thenAccept(arg_0 -> TerminalInput.withTerminalSession$lambda$1(arg_0 -> TerminalInput.withTerminalSession$lambda$0(this, block, arg_0), arg_0));
    }

    private static final Unit withTerminalSession$lambda$0(TerminalInput this$0, Function2 $block, TerminalSession session2) {
        if (session2 != null) {
            BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)((CoroutineContext)this$0.synchronousDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function2<? super TerminalSession, ? super Continuation<? super Unit>, ? extends Object>)$block, session2, null){
                int label;
                final /* synthetic */ Function2<TerminalSession, Continuation<? super Unit>, Object> $block;
                final /* synthetic */ TerminalSession $session;
                {
                    this.$block = $block;
                    this.$session = $session;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$block.invoke((Object)this.$session, (Object)((Object)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final void withTerminalSession$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/terminal/frontend/TerminalInput;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalInput> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

