/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.CopyOnSelectionHandlerKt;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/terminal/frontend/CopyOnSelectionHandler;", "", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "copy", "text", "", "copyToSystemSelectionClipboard", "", "copyToRegularClipboard", "MySelectionListener", "intellij.terminal.frontend"})
public final class CopyOnSelectionHandler {
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;

    public CopyOnSelectionHandler(@NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
    }

    public final void install(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.getSelectionModel().addSelectionListener((SelectionListener)new MySelectionListener());
    }

    private final void copy(String text) {
        if (!this.copyToSystemSelectionClipboard(text)) {
            this.copyToRegularClipboard(text);
        }
    }

    private final boolean copyToSystemSelectionClipboard(String text) {
        try {
            if (!SystemInfo.isLinux) {
                return false;
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
            if (clipboard == null) {
                return false;
            }
            Clipboard clipboard2 = clipboard;
            clipboard2.setContents(new StringSelection(text), null);
            return true;
        }
        catch (Exception e) {
            CopyOnSelectionHandlerKt.access$getLOG$p().warn("Failed to copy to the system selection clipboard, falling back to the regular one", (Throwable)e);
            return false;
        }
    }

    private final void copyToRegularClipboard(String text) {
        CopyPasteManager.copyTextToClipboard((String)text);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/CopyOnSelectionHandler$MySelectionListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "<init>", "(Lcom/intellij/terminal/frontend/CopyOnSelectionHandler;)V", "selectionChanged", "", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "intellij.terminal.frontend"})
    private final class MySelectionListener
    implements SelectionListener {
        public void selectionChanged(@NotNull SelectionEvent e) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!CopyOnSelectionHandler.this.settings.copyOnSelect()) break block4;
                    Object object = e.getEditor();
                    if (object != null && (object = object.getContentComponent()) != null ? ((Component)object).isFocusOwner() : false) break block5;
                }
                return;
            }
            String string = e.getEditor().getSelectionModel().getSelectedText();
            if (string == null) {
                return;
            }
            String text = string;
            CopyOnSelectionHandler.this.copy(text);
        }
    }
}

