/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInitializeParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String initializer;

    public JSInitializeParameterFix(JSParameterListElement parameter, String initializer) {
        super((PsiElement)parameter);
        this.initializer = JSRefactoringUtil.recodeQuotes(initializer, JSCodeStyleSettings.getQuote((PsiElement)parameter));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.initialize.parameter", new Object[0]);
        if (string == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(5);
        }
        JSParameter parameter = (JSParameter)startElement;
        JSParameterListElement createdParam = JSChangeUtil.createParameter(parameter.getText() + "=" + this.initializer, (PsiElement)parameter);
        parameter.replace((PsiElement)createdParam);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInitializeParameterFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInitializeParameterFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

