/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSSymbolCompletionUtil {
    public static boolean processIndexedSymbols(@NotNull PsiElement referenceElement, @NotNull VariantsProcessor processor, @NotNull CompletionResultSet resultSet, @Nullable List<? super Collection<LookupElement>> populatedResults) {
        if (referenceElement == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(2);
        }
        boolean tooMuch = !JSSymbolCompletionUtil.processCompeteMatchedElements(processor);
        Collection<LookupElement> completeMatchResults = processor.getCurrentResults();
        processor.populateCompletionList(completeMatchResults, true, resultSet);
        if (populatedResults != null) {
            populatedResults.add(completeMatchResults);
        }
        if (tooMuch) {
            JSCompletionUtil.handleOverflow(resultSet);
            return false;
        }
        Project project = referenceElement.getProject();
        PsiFile file = referenceElement.getContainingFile();
        if (!JSSymbolCompletionUtil.processElementsInInjectedContext(processor, file)) {
            JSCompletionUtil.handleOverflow(resultSet);
            return true;
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(referenceElement);
        if (!processor.addOnlyCompleteMatches() && !JSSymbolCompletionUtil.processAllIndexedSymbols(processor, project, scope2, referenceElement)) {
            JSCompletionUtil.handleOverflow(resultSet);
            return true;
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return true;
        }
        boolean result2 = JSSymbolCompletionUtil.processImplicitElements(processor, project, scope2);
        if (!result2) {
            JSCompletionUtil.handleOverflow(resultSet);
        }
        return true;
    }

    public static boolean processElementsInInjectedContext(JSCompletionProcessor processor, PsiFile file) {
        return JSResolveUtil.tryProcessAllElementsInInjectedContext(file, (Processor<? super JSPsiElementBase>)((Processor)base -> processor.doAdd((JSPsiElementBase)base)));
    }

    public static boolean processImplicitElements(final JSCompletionProcessor processor, Project project, GlobalSearchScope scope2) {
        return JSIndexBasedResolveUtil.processImplicitElementProxies(null, scope2, project, new JSIndexBasedResolveUtil.JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.doAdd(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSSymbolCompletionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processCompeteMatchedElements(@NotNull VariantsProcessor processor) {
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(3);
        }
        JSTypeInfo typeInfo = processor.getTypeInfo();
        boolean globalAdded = false;
        for (JSContextLevel level : typeInfo.myContextLevels) {
            globalAdded |= level.myNamespace.getQualifiedName() == null;
        }
        List<JSContextLevel> contextLevels = typeInfo.myContextLevels;
        if (!globalAdded && typeInfo.isGlobalContext()) {
            contextLevels = new ArrayList<JSContextLevel>(contextLevels);
            JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create("", null), JSContext.UNKNOWN, null, true);
            contextLevels.add(new JSContextLevel(namespace, 0));
        }
        if (typeInfo.isGlobalContext() && typeInfo.isEmpty()) {
            processor.setAddOnlyCompleteMatches();
        }
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope(processor.getContext());
        HashSet<JSNamespace> visitedNamespaces = new HashSet<JSNamespace>();
        for (JSContextLevel level : contextLevels) {
            GlobalSearchScope scope2;
            if (level.isGlobal() && !visitedNamespaces.add(level.myNamespace)) continue;
            PsiElement elementToIncludeLocalMembers = JSResolveUtil.getScopeToIncludeLocalMembers(level.myNamespace);
            PsiFile fileToIncludeLocal = elementToIncludeLocalMembers != null ? elementToIncludeLocalMembers.getContainingFile() : null;
            GlobalSearchScope globalSearchScope = scope2 = JSTypeUtils.isLocalOrFromSource(level.myNamespace) && fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : allScope;
            GlobalSearchScope scopeToIncludeLocal = level.isFromComment() ? scope2 : (fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : null);
            Collection<JSPsiElementBase> namespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(level.myNamespace, scope2, scopeToIncludeLocal);
            for (JSPsiElementBase element : namespaceMembers) {
                if (!processor.acceptsFile(element.getContainingFile()) || processor.doAdd(element, JSTypeWithOuterGenerics.getGenericArguments(level.myNamespace))) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Set<VirtualFile> filterIds(@NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull PrefixMatcher matcher, @NotNull PsiElement context2) {
        if (project == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(5);
        }
        if (matcher == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(7);
        }
        if (matcher.getPrefix().isEmpty()) {
            return null;
        }
        HashSet keys = new HashSet();
        StubIndexKey<String, JSElement> indexKey = DialectDetector.isActionScript(context2) ? JSSymbolIndex2.KEY : JSNonGlobalSymbolIndex.KEY;
        StubIndex.getInstance().processAllKeys(indexKey, s -> {
            if (matcher.prefixMatches(s)) {
                keys.add(s);
            }
            return true;
        }, scope2);
        VirtualFileSet files = VfsUtilCore.createCompactVirtualFileSet();
        for (String key : keys) {
            ContainerUtil.addAll((Collection)files, (Iterable)StubIndex.getInstance().getContainingFiles(indexKey, (Object)key, project, scope2));
        }
        return files;
    }

    public static boolean processAllFilesWithKeysMatchingPrefix(@NotNull PsiElement context2, @NotNull GlobalSearchScope scope2, @Nullable Set<VirtualFile> files, @NotNull Processor<? super VirtualFile> processor) {
        VirtualFile originalFile;
        if (context2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(10);
        }
        if (!processor.process((Object)(originalFile = context2.getContainingFile().getOriginalFile().getVirtualFile()))) {
            return false;
        }
        if (files == null) {
            for (FileType fileType : JavaScriptIndex.getFileTypesToIndexJS()) {
                for (VirtualFile vFile : FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope2)) {
                    ProgressManager.checkCanceled();
                    if (vFile.equals(originalFile)) continue;
                    if (!JavaScriptIndex.isAcceptableFile(vFile)) {
                        return true;
                    }
                    if (processor.process((Object)vFile)) continue;
                    return false;
                }
            }
        } else {
            for (VirtualFile vFile : files) {
                ProgressManager.checkCanceled();
                if (vFile == null || vFile.equals(originalFile) || !scope2.accept(vFile) || processor.process((Object)vFile)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAllIndexedSymbols(@NotNull JSCompletionProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull PsiElement context2) {
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(14);
        }
        MyJSRecursiveWalkingElementVisitor visitor = new MyJSRecursiveWalkingElementVisitor(processor);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        @Nullable Set<VirtualFile> filterIds = JSSymbolCompletionUtil.filterIds(project, scope2, processor.getPrefixMatcher(), context2);
        return JSSymbolCompletionUtil.processAllFilesWithKeysMatchingPrefix(context2, scope2, filterIds, (Processor<? super VirtualFile>)((Processor)vFile -> {
            if (!StubUpdatingIndex.canHaveStub((VirtualFile)vFile)) {
                return true;
            }
            return JSSymbolCompletionUtil.processAllInVirtualFile(processor, psiManager, visitor, vFile);
        }));
    }

    private static boolean processAllInVirtualFile(@NotNull JSCompletionProcessor processor, @NotNull PsiManager psiManager, @NotNull MyJSRecursiveWalkingElementVisitor visitor, @NotNull VirtualFile vFile) {
        PsiFile psi;
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(15);
        }
        if (psiManager == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(16);
        }
        if (visitor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(17);
        }
        if (vFile == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(18);
        }
        if ((psi = psiManager.findFile(vFile)) == null) {
            return true;
        }
        if (!processor.acceptsFile(psi)) {
            return true;
        }
        return JSSymbolCompletionUtil.processSymbolsInPsiFile(processor, visitor, psi);
    }

    private static boolean processSymbolsInPsiFile(@NotNull JSCompletionProcessor processor, MyJSRecursiveWalkingElementVisitor visitor, PsiFile psi) {
        if (processor == null) {
            JSSymbolCompletionUtil.$$$reportNull$$$0(19);
        }
        @Unmodifiable @NotNull List stubbedRoots = StubTreeBuilder.getStubbedRootDescriptors((FileViewProvider)psi.getViewProvider());
        for (Pair stubbedRoot : stubbedRoots) {
            PsiFile root = (PsiFile)stubbedRoot.second;
            ((PsiFileImpl)root).withGreenStubTreeOrAst(tree -> {
                for (StubElement stubElement : tree.getPlainList()) {
                    ProgressManager.checkCanceled();
                    IStubElementType type2 = stubElement.getStubType();
                    if (!(type2 instanceof JSStubElementType)) continue;
                    JSStubElementType jsStubType = (JSStubElementType)type2;
                    PsiElement psiElement = stubElement.getPsi();
                    if (JSSymbolCompletionUtil.processElement(processor, (JSElement)psiElement, jsStubType)) continue;
                    return false;
                }
                return null;
            }, ast -> {
                root.accept((PsiElementVisitor)visitor);
                return null;
            });
        }
        return true;
    }

    private static <PsiT extends JSElement> boolean processElement(JSCompletionProcessor processor, PsiT element, JSStubElementType<?, PsiT> type2) {
        if (element instanceof JSFunctionExpression) {
            return true;
        }
        if (element instanceof JSPsiElementBase && !StringUtil.isEmpty((String)element.getName()) && type2.shouldIndexSymbol(element) && !processor.doAdd((JSPsiElementBase)element)) {
            return false;
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection<JSImplicitElement> elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection<JSImplicitElement> collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement implicitElement : elements) {
                    if (!(implicitElement instanceof JSIndexableImplicitElement) || JSElementIndexingDataStructureImpl.indexImplicitElement(((JSIndexableImplicitElement)implicitElement).getStructure(), null) || processor.doAdd(implicitElement)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSSymbolCompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIndexedSymbols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompeteMatchedElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "filterIds";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllFilesWithKeysMatchingPrefix";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllIndexedSymbols";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllInVirtualFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsInPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyJSRecursiveWalkingElementVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSCompletionProcessor myProcessor;

        MyJSRecursiveWalkingElementVisitor(JSCompletionProcessor processor) {
            this.myProcessor = processor;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            JSStubElementType jsStubType;
            ASTNode node;
            IElementType type2;
            if (element == null) {
                MyJSRecursiveWalkingElementVisitor.$$$reportNull$$$0(0);
            }
            IElementType iElementType = type2 = (node = element.getNode()) != null ? node.getElementType() : null;
            if (type2 instanceof JSStubElementType && (jsStubType = (JSStubElementType)type2).shouldCreateStub(node) && !JSSymbolCompletionUtil.processElement(this.myProcessor, (JSElement)element, (JSStubElementType)type2)) {
                this.stopWalking();
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSSymbolCompletionUtil$MyJSRecursiveWalkingElementVisitor", "visitElement"));
        }
    }
}

