/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.detection;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"findPsiElementInJsTestFile", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "detector", "Lcom/intellij/javascript/testing/detection/JsTestFrameworkDetector;", "testSelector", "Lcom/intellij/javascript/testFramework/JsTestSelector;", "testFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findPsiElementInJsTestNamesIndexes", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJsTestFrameworkDetectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTestFrameworkDetectionUtils.kt\ncom/intellij/javascript/testing/detection/JsTestFrameworkDetectionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1863#2:38\n1864#2:40\n1#3:39\n*S KotlinDebug\n*F\n+ 1 JsTestFrameworkDetectionUtils.kt\ncom/intellij/javascript/testing/detection/JsTestFrameworkDetectionUtilsKt\n*L\n32#1:38\n32#1:40\n*E\n"})
public final class JsTestFrameworkDetectionUtilsKt {
    @Nullable
    public static final PsiElement findPsiElementInJsTestFile(@NotNull Project project, @NotNull JsTestFrameworkDetector detector, @NotNull JsTestSelector testSelector, @NotNull VirtualFile testFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(testFile);
        if (psiFile instanceof JSFile) {
            AbstractTestFileStructure abstractTestFileStructure = detector.findTestsStructure((JSFile)psiFile);
            if (abstractTestFileStructure != null) {
                AbstractTestFileStructure it = abstractTestFileStructure;
                boolean bl = false;
                PsiElement element = it.findPsiElement(testSelector);
                if (element != null && element.isValid()) {
                    return element;
                }
            }
        }
        return null;
    }

    @Nullable
    public static final PsiElement findPsiElementInJsTestNamesIndexes(@NotNull Project project, @NotNull JsTestFrameworkDetector detector, @NotNull JsTestSelector testSelector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        Intrinsics.checkNotNullParameter((Object)testSelector, (String)"testSelector");
        List<VirtualFile> testFiles = detector.findTestFilesInIndexesBySelector(project, testSelector);
        Iterable $this$forEach$iv = testFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile testFile = (VirtualFile)element$iv;
            boolean bl = false;
            PsiElement psiElement = JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestFile(project, detector, testSelector, testFile);
            if (psiElement == null) continue;
            PsiElement it = psiElement;
            boolean bl2 = false;
            return it;
        }
        return null;
    }
}

