/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.dvcs.actions.DvcsCompareWithAction;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DvcsCompareWithBranchAction<T extends Repository>
extends DvcsCompareWithAction<T> {
    @NotNull
    protected abstract List<String> getBranchNamesExceptCurrent(@NotNull T var1);

    @NotNull
    protected abstract Collection<Change> getDiffChanges(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3) throws VcsException;

    @Override
    @NotNull
    protected JBPopup createPopup(@NotNull Project project, @NotNull T repository, @NotNull VirtualFile file) {
        if (project == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        String presentableRevisionName = DvcsCompareWithBranchAction.getPresentableCurrentBranchName(repository);
        List<String> branchNames = this.getBranchNamesExceptCurrent(repository);
        JBPopup jBPopup = DvcsCompareWithBranchAction.createPopup(DvcsBundle.message("popup.title.select.branch.to.compare", new Object[0]), branchNames, selected -> this.showDiffWithBranchUnderModalProgress(project, file, presentableRevisionName, (String)selected));
        if (jBPopup == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        return jBPopup;
    }

    private void showDiffWithBranchUnderModalProgress(@NotNull Project project, @NotNull VirtualFile file, @NotNull @NlsSafe String head, @NotNull @NlsSafe String compare) {
        if (project == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        if (head == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        if (compare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle((String)compare, (boolean)false);
        String revNumTitle2 = VcsDiffUtil.getRevisionTitle((String)head, (boolean)true);
        DvcsCompareWithBranchAction.showDiffBetweenRevision(project, file, revNumTitle1, revNumTitle2, (ThrowableComputable<? extends Collection<Change>, ? extends VcsException>)((ThrowableComputable)() -> this.getDiffChanges(project, file, compare)));
    }

    @NlsSafe
    protected static String fileDoesntExistInBranchError(@NotNull VirtualFile file, @NotNull String branchToCompare) {
        if (file == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(8);
        }
        if (branchToCompare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(9);
        }
        return DvcsBundle.message("error.text.file.not.found.in.branch", file.isDirectory() ? 2 : 1, file.getPresentableUrl(), branchToCompare);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compare";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithBranchUnderModalProgress";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fileDoesntExistInBranchError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

