/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.AdapterWithCustomAttributes;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import com.intellij.openapi.extensions.impl.InterfaceExtensionImplementationClassResolver;
import com.intellij.openapi.extensions.impl.SimpleConstructorInjectionAdapter;
import com.intellij.util.Java11Shim;
import com.intellij.util.xml.dom.XmlElement;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u00192\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u0019H\u0016R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionPoint;", "T", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "name", "", "className", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "clazz", "Ljava/lang/Class;", "dynamic", "", "hasAttributes", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/openapi/components/ComponentManager;Ljava/lang/Class;ZZ)V", "createAdapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "descriptor", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "unregisterExtensions", "", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
public final class InterfaceExtensionPoint<T>
extends ExtensionPointImpl<T> {
    private final boolean hasAttributes;

    public InterfaceExtensionPoint(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable Class<T> clazz, boolean dynamic, boolean hasAttributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(name, className, pluginDescriptor, componentManager, clazz, dynamic, null);
        this.hasAttributes = hasAttributes;
    }

    @Override
    @NotNull
    public ExtensionComponentAdapter createAdapter(@NotNull ExtensionDescriptor descriptor, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        String string = descriptor.implementation;
        if (string == null) {
            throw componentManager.createError("Attribute \"implementation\" is not specified for \"" + this.name + "\" extension", pluginDescriptor.getPluginId());
        }
        String implementationClassName = string;
        if (this.hasAttributes) {
            Object object;
            if (descriptor.hasExtraAttributes) {
                object = descriptor.element;
                if (object == null || (object = object.attributes) == null) {
                    object = Java11Shim.Companion.getINSTANCE().mapOf();
                }
            } else {
                object = Java11Shim.Companion.getINSTANCE().mapOf();
            }
            Object customAttributes = object;
            InterfaceExtensionImplementationClassResolver interfaceExtensionImplementationClassResolver = InterfaceExtensionImplementationClassResolver.INSTANCE;
            return new AdapterWithCustomAttributes(implementationClassName, pluginDescriptor, descriptor, interfaceExtensionImplementationClassResolver, (Map<String, String>)customAttributes);
        }
        XmlElement element = descriptor.element;
        if (!descriptor.hasExtraAttributes && element != null && element.children.isEmpty()) {
            element = null;
        }
        return new SimpleConstructorInjectionAdapter(implementationClassName, pluginDescriptor, descriptor, element, (ImplementationClassResolver)InterfaceExtensionImplementationClassResolver.INSTANCE);
    }

    @Override
    public void unregisterExtensions(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(priorityListenerCallbacks, (String)"priorityListenerCallbacks");
        Intrinsics.checkNotNullParameter(listenerCallbacks, (String)"listenerCallbacks");
        this.unregisterExtensions(false, priorityListenerCallbacks, listenerCallbacks, arg_0 -> InterfaceExtensionPoint.unregisterExtensions$lambda$1(arg_0 -> InterfaceExtensionPoint.unregisterExtensions$lambda$0(pluginDescriptor, arg_0), arg_0));
    }

    private static final boolean unregisterExtensions$lambda$0(PluginDescriptor $pluginDescriptor, ExtensionComponentAdapter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.pluginDescriptor != $pluginDescriptor;
    }

    private static final boolean unregisterExtensions$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

