/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.instrumentation.NearestNodesCollector;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import java.util.Arrays;
import java.util.Set;

public final class NearestSectionFilter {
    private final NearestNodesCollector.Position position;
    private final boolean anchorStart;
    private final Class<?>[] tags;
    private final Set<Class<? extends Tag>> tagClasses;

    private NearestSectionFilter(NearestNodesCollector.Position position, boolean anchorStart, Class<?>[] tags) {
        this.position = position;
        this.anchorStart = anchorStart;
        this.tags = tags;
        this.tagClasses = NearestSectionFilter.convertTags(tags);
    }

    public static Builder newBuilder(int line, int column) {
        return new Builder(line, column);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("NearestSectionFilter[");
        b.append("To ");
        b.append(this.position);
        b.append(" with anchor '");
        b.append(this.anchorStart ? "start" : "end");
        b.append("' and tag is one of ");
        b.append(Arrays.toString(this.tags));
        b.append("]");
        return b.toString();
    }

    NearestNodesCollector.Position getPosition() {
        return this.position;
    }

    boolean isAnchorStart() {
        return this.anchorStart;
    }

    Set<Class<?>> getReferencedTags() {
        return this.tags != null ? Set.of(this.tags) : Set.of();
    }

    Set<Class<? extends Tag>> getTagClasses() {
        return this.tagClasses;
    }

    private static Set<Class<? extends Tag>> convertTags(Class<?>[] tags) {
        if (tags != null) {
            for (Class<?> tag : tags) {
                if (Tag.class.isAssignableFrom(tag)) continue;
                throw new IllegalArgumentException("Illegal tag " + String.valueOf(tag) + ", not of class " + Tag.class.getName());
            }
            return Set.of(tags);
        }
        return null;
    }

    public static final class Builder {
        private final int line;
        private final int column;
        private boolean anchorStart = true;
        private Class<?>[] theTags;

        private Builder(int line, int column) {
            if (line < 1) {
                throw new IllegalArgumentException("line " + line + " < 1");
            }
            this.line = line;
            this.column = column;
        }

        public Builder anchorStart(boolean start2) {
            this.anchorStart = start2;
            return this;
        }

        public Builder tagIs(Class<?> ... tags) {
            SourceSectionFilter.verifyNotNull(tags);
            this.theTags = tags;
            return this;
        }

        public NearestSectionFilter build() {
            return new NearestSectionFilter(new NearestNodesCollector.Position(this.line, this.column, -1), this.anchorStart, this.theTags);
        }
    }
}

