/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import java.text.DecimalFormat;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class Commerce {
    private final Faker faker;

    protected Commerce(Faker faker) {
        this.faker = faker;
    }

    public String color() {
        return this.faker.fakeValuesService().resolve("color.name", this, this.faker);
    }

    public String department() {
        int numberOfDepartments = Math.max(this.faker.random().nextInt(4), 1);
        TreeSet<String> departments = new TreeSet<String>();
        while (departments.size() < numberOfDepartments) {
            departments.add(this.faker.fakeValuesService().resolve("commerce.department", this, this.faker));
        }
        if (departments.size() > 1) {
            String lastDepartment = (String)departments.last();
            return StringUtils.join(departments.headSet(lastDepartment), (String)", ") + " & " + lastDepartment;
        }
        return (String)departments.first();
    }

    public String productName() {
        return StringUtils.join((Object[])new String[]{this.faker.fakeValuesService().resolve("commerce.product_name.adjective", this, this.faker), this.faker.fakeValuesService().resolve("commerce.product_name.material", this, this.faker), this.faker.fakeValuesService().resolve("commerce.product_name.product", this, this.faker)}, (String)" ");
    }

    public String material() {
        return this.faker.fakeValuesService().resolve("commerce.product_name.material", this, this.faker);
    }

    public String price() {
        return this.price(0.0, 100.0);
    }

    public String price(double min, double max) {
        double price = min + this.faker.random().nextDouble() * (max - min);
        return new DecimalFormat("#0.00").format(price);
    }

    public String promotionCode() {
        return this.promotionCode(6);
    }

    public String promotionCode(int digits) {
        return StringUtils.join((Object[])new String[]{this.faker.resolve("commerce.promotion_code.adjective"), this.faker.resolve("commerce.promotion_code.noun"), this.faker.number().digits(digits)});
    }
}

