/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.intellij.database.remote.jdbc.CassParseUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CassShim {
    public static String udtValueToString(Object value) {
        if (!(value instanceof UdtValue)) {
            return null;
        }
        UdtValue udtValue = (UdtValue)value;
        TypeCodec codec = udtValue.codecRegistry().codecFor((Object)udtValue);
        return codec.format((Object)udtValue);
    }

    public static String tupleValueToString(Object value) {
        if (!(value instanceof TupleValue)) {
            return null;
        }
        TupleValue udtValue = (TupleValue)value;
        TypeCodec codec = udtValue.codecRegistry().codecFor((Object)udtValue);
        return codec.format((Object)udtValue);
    }

    public static Map<String, String> getInitConditions(Object s, String keyspaceName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (!(s instanceof Session)) {
            return null;
        }
        Session session = (Session)s;
        Metadata metadata = session.getMetadata();
        KeyspaceMetadata keyspace = (KeyspaceMetadata)CassShim.unwrapOptional(metadata.getClass().getMethod("getKeyspace", String.class).invoke((Object)metadata, keyspaceName));
        if (keyspace == null) {
            return null;
        }
        LinkedHashMap<String, String> initConditions = new LinkedHashMap<String, String>();
        for (AggregateMetadata aggregateMetadata : keyspace.getAggregates().values()) {
            Object initCond = CassShim.unwrapOptional(aggregateMetadata.getClass().getMethod("getInitCond", new Class[0]).invoke((Object)aggregateMetadata, new Object[0]));
            String signature = aggregateMetadata.getSignature().toString();
            if (initCond == null) {
                initConditions.put(signature, "null");
                continue;
            }
            if (initCond instanceof String) {
                initConditions.put(signature, CassParseUtils.quote((String)initCond));
                continue;
            }
            Method getFormattedContentsMethod = CassShim.getMethodIfExists(initCond, "getFormattedContents");
            String formatted = getFormattedContentsMethod != null ? (String)getFormattedContentsMethod.invoke(initCond, new Object[0]) : initCond.toString();
            initConditions.put(signature, formatted);
        }
        return initConditions;
    }

    private static Method getMethodIfExists(Object object, String methodName) {
        try {
            return object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    private static Object unwrapOptional(Object optional) {
        if (optional == null) {
            return null;
        }
        try {
            return Boolean.TRUE.equals(optional.getClass().getMethod("isPresent", new Class[0]).invoke(optional, new Object[0])) ? optional.getClass().getMethod("get", new Class[0]).invoke(optional, new Object[0]) : null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

