/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.Dbms;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlDialectCodeStyleProvider;
import com.intellij.sql.formatter.settings.SqlCodeStyleProviderService;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlDialectSpecificCodeStyleScheme;
import com.intellij.sql.formatter.settings.SqlLanguageCodeStyleProvider;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlCodeStyles {
    @NotNull
    private static JBIterable<? extends SqlLanguageCodeStyleProvider> getProviders() {
        JBIterable<? extends SqlLanguageCodeStyleProvider> jBIterable = SqlCodeStyleProviderService.getInstance().getProviders();
        if (jBIterable == null) {
            SqlCodeStyles.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static JBIterable<SqlLanguageDialect> listSqlDialects() {
        return SqlCodeStyles.getProviders().map(p -> p.getLanguage()).filter(SqlLanguageDialect.class);
    }

    @Nullable
    private static SqlLanguageCodeStyleProvider findProvider(@NotNull Language language) {
        if (language == null) {
            SqlCodeStyles.$$$reportNull$$$0(1);
        }
        return (SqlLanguageCodeStyleProvider)SqlCodeStyles.getProviders().filter(p -> p.getLanguage().equals(language)).first();
    }

    @NotNull
    private static Language getDefaultDialect() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            SqlCodeStyles.$$$reportNull$$$0(2);
        }
        return sqlLanguage;
    }

    public static SqlLanguageDialect getGenericDialect() {
        return SqlLanguageDialect.getGenericDialect();
    }

    public static SqlLanguageDialect getIsoDialect() {
        return SqlLanguageDialect.getIsoDialect();
    }

    public static SqlLanguageDialect getPreviewDialectFor(@Nullable Language language) {
        if (language == null || language == SqlLanguage.INSTANCE || language == SqlCodeStyles.getGenericDialect()) {
            return SqlCodeStyles.getDefaultPreviewDialect();
        }
        if (language instanceof SqlLanguageDialect) {
            return (SqlLanguageDialect)language;
        }
        return SqlCodeStyles.getDefaultPreviewDialect();
    }

    @NotNull
    private static SqlLanguageDialect getDefaultPreviewDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlCodeStyles.getIsoDialect();
        if (sqlLanguageDialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(3);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getSettingsLanguage(@NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(4);
        }
        if (SqlCodeStyles.findProvider(dialect) != null) {
            Language language = dialect;
            if (language == null) {
                SqlCodeStyles.$$$reportNull$$$0(5);
            }
            return language;
        }
        if (dialect instanceof SqlLanguageDialect) {
            SqlLanguageDialect d = (SqlLanguageDialect)dialect;
            Dbms dbms = d.getDbms();
            if (dbms == Dbms.UNKNOWN) {
                SqlLanguageDialect sqlLanguageDialect = SqlLanguageDialect.getIsoDialect();
                if (sqlLanguageDialect == null) {
                    SqlCodeStyles.$$$reportNull$$$0(6);
                }
                return sqlLanguageDialect;
            }
            if (dbms.isPostgres()) {
                Language language = (Language)SqlLanguageDialect.EP.forDbms(Dbms.POSTGRES);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(7);
                }
                return language;
            }
            if (dbms.isOracle()) {
                Language language = (Language)SqlLanguageDialect.EP.forDbms(Dbms.ORACLE);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(8);
                }
                return language;
            }
            if (dbms.isTransactSql()) {
                Language language = (Language)SqlLanguageDialect.EP.forDbms(Dbms.MSSQL);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(9);
                }
                return language;
            }
            if (dbms.isMysql()) {
                Language language = (Language)SqlLanguageDialect.EP.forDbms(Dbms.MYSQL);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(10);
                }
                return language;
            }
        }
        return SqlCodeStyles.getDefaultDialect();
    }

    @NotNull
    public static Class<? extends SqlCodeStyleSettings> getSettingsClass(@NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(11);
        }
        Language settingLanguage = SqlCodeStyles.getSettingsLanguage(dialect);
        Class<? extends SqlCodeStyleSettings> settingsClass = SqlCodeStyles.findSettingsClass(settingLanguage);
        assert (settingsClass != null) : "The settings class for the dialect " + dialect.getID() + " is not registered";
        Class<? extends SqlCodeStyleSettings> clazz = settingsClass;
        if (clazz == null) {
            SqlCodeStyles.$$$reportNull$$$0(12);
        }
        return clazz;
    }

    @Nullable
    private static Class<? extends SqlCodeStyleSettings> findSettingsClass(Language settingLanguage) {
        SqlLanguageCodeStyleProvider provider = SqlCodeStyles.findProvider(settingLanguage);
        return provider == null ? null : provider.getSettingsClass();
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@NotNull Project project, @NotNull VirtualFile file) {
        Language dialect;
        if (project == null) {
            SqlCodeStyles.$$$reportNull$$$0(13);
        }
        if (file == null) {
            SqlCodeStyles.$$$reportNull$$$0(14);
        }
        if ((dialect = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == null) {
            dialect = SqlCodeStyles.getGenericDialect();
        }
        CodeStyleSettings settingsContainer = CodeStyle.getSettings((Project)project, (VirtualFile)file);
        return SqlCodeStyles.getSqlSettings(settingsContainer, dialect);
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@NotNull PsiFile file) {
        if (file == null) {
            SqlCodeStyles.$$$reportNull$$$0(15);
        }
        Language dialect = file.getLanguage();
        CodeStyleSettings settingsContainer = CodeStyle.getSettings((PsiFile)file);
        return SqlCodeStyles.getSqlSettings(settingsContainer, dialect);
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@Nullable Project project, @NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(16);
        }
        return SqlCodeStyles.getSqlSettings(SqlCodeStyles.getSettings(project), dialect);
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settingsContainer, @NotNull Language dialect) {
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(17);
        }
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(18);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.pickSqlSettings(settingsContainer, dialect);
        if (settings.USE_GENERAL_STYLE) {
            settings = SqlCodeStyles.getGeneralSqlSettings(settingsContainer);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = settings;
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(19);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings pickSqlSettings(@NotNull CodeStyleSettings settingsContainer, @NotNull Language dialect) {
        SqlCodeStyleSettings sqlCodeStyleSettings;
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(20);
        }
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(21);
        }
        if (!(dialect instanceof SqlLanguageDialect) && !(dialect instanceof SqlLanguage)) {
            return SqlCodeStyles.getGeneralSqlSettings(settingsContainer);
        }
        Language settingLanguage = SqlCodeStyles.getSettingsLanguage(dialect);
        Class<? extends SqlCodeStyleSettings> settingsClass = SqlCodeStyles.findSettingsClass(settingLanguage);
        if (settingsClass == null) {
            throw new IllegalArgumentException("Dialect " + dialect.getID() + " and settings language " + settingLanguage.getID() + " have no corresponding settings class");
        }
        try {
            sqlCodeStyleSettings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(settingsClass);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException("Failed to get setting " + settingsClass.getSimpleName() + " (dialect: " + dialect.getID() + ")", rte);
        }
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(22);
        }
        return sqlCodeStyleSettings;
    }

    @Nullable
    public static SqlCodeStyleSettings pickSqlSettingsIfExists(@NotNull CodeStyleSettings settingsContainer, @NotNull SqlLanguageDialect dialect) {
        SqlCodeStyleSettings result;
        Language settingLanguage;
        Class<? extends SqlCodeStyleSettings> settingsClass;
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(23);
        }
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(24);
        }
        if ((settingsClass = SqlCodeStyles.findSettingsClass(settingLanguage = SqlCodeStyles.getSettingsLanguage(dialect))) == null) {
            return null;
        }
        try {
            result = (SqlCodeStyleSettings)settingsContainer.getCustomSettingsIfCreated(settingsClass);
        }
        catch (RuntimeException rte) {
            return null;
        }
        return result != null && result.getCorrespondedDialect() == settingLanguage ? result : null;
    }

    @NotNull
    public static SqlCodeStyleSettings getGeneralSqlSettings(@Nullable Project project) {
        CodeStyleSettings settingsContainer = SqlCodeStyles.getSettings(project);
        return SqlCodeStyles.getGeneralSqlSettings(settingsContainer);
    }

    @NotNull
    public static SqlCodeStyleSettings getGeneralSqlSettings(@NotNull CodeStyleSettings settingsContainer) {
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(25);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(SqlCodeStyleSettings.class);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(26);
        }
        return sqlCodeStyleSettings;
    }

    @Nullable
    public static CodeStyleScheme findScheme(@NotNull String schemeName) {
        CodeStyleScheme scheme;
        if (schemeName == null) {
            SqlCodeStyles.$$$reportNull$$$0(27);
        }
        if ((scheme = CodeStyleSchemes.getInstance().findSchemeByName(schemeName)) == null) {
            scheme = (CodeStyleScheme)SqlCodeStyles.listSpecificSchemes().find(s -> s.getName().equalsIgnoreCase(schemeName));
        }
        return scheme;
    }

    @NotNull
    public static JBIterable<SqlDialectSpecificCodeStyleScheme> listSpecificSchemes() {
        List extensions = SqlDialectCodeStyleProvider.EP_NAME.getExtensionList();
        JBIterable jBIterable = JBIterable.from((Iterable)extensions).flatten(provider -> (Iterable)ObjectUtils.chooseNotNull(provider.getDialectSpecificPredefinedStyleSchemes(), Collections.emptyList()));
        if (jBIterable == null) {
            SqlCodeStyles.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = project != null ? CodeStyle.getSettings((Project)project) : CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(29);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project, @Nullable String schemeName) {
        CodeStyleScheme scheme = schemeName == null ? null : SqlCodeStyles.findScheme(schemeName);
        CodeStyleSettings codeStyleSettings = scheme == null ? SqlCodeStyles.getSettings(project) : scheme.getCodeStyleSettings();
        if (codeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(30);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@Nullable Project project, @Nullable String codeStyleName, @NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(31);
        }
        return SqlCodeStyles.getSqlSettings(SqlCodeStyles.getSettings(project, codeStyleName), (Language)dialect);
    }

    public static JBIterable<? extends Language> getSettingsDialects() {
        return JBIterable.of((Object)SqlCodeStyles.getDefaultDialect()).append(SqlCodeStyles.listSqlDialectsWithoutDefault());
    }

    @NotNull
    static JBIterable<SqlLanguageDialect> listSqlDialectsWithoutDefault() {
        JBIterable jBIterable = SqlCodeStyles.listSqlDialects().filter(d -> d != SqlCodeStyles.getDefaultDialect());
        if (jBIterable == null) {
            SqlCodeStyles.$$$reportNull$$$0(32);
        }
        return jBIterable;
    }

    static void copySettings(@NotNull SqlCodeStyleSettings source, @NotNull SqlCodeStyleSettings target) {
        CommonCodeStyleSettings targetCommonSettings;
        if (source == null) {
            SqlCodeStyles.$$$reportNull$$$0(33);
        }
        if (target == null) {
            SqlCodeStyles.$$$reportNull$$$0(34);
        }
        if (source == target) {
            return;
        }
        CommonCodeStyleSettings sourceCommonSettings = source.getCorrespondedCommonSettings();
        if (sourceCommonSettings != (targetCommonSettings = target.getCorrespondedCommonSettings())) {
            targetCommonSettings.copyFrom(sourceCommonSettings);
        }
        Field[] fieldsToCopy = (Field[])JBIterable.of((Object[])SqlCodeStyleSettings.class.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && !Modifier.isStatic(f.getModifiers()) && Character.isUpperCase(f.getName().charAt(0)) && !f.isAnnotationPresent(Deprecated.class) && !target.isSettingHidden(f.getName())).toArray((Object[])new Field[0]);
        ReflectionUtil.copyFields((Field[])fieldsToCopy, (Object)source, (Object)target);
        target.myVersion = source.myVersion;
        target.myInitialized = source.myInitialized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 11, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 27, 31, 33, 34 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsContainer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPreviewDialect";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "pickSqlSettings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralSqlSettings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "listSpecificSchemes";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "listSqlDialectsWithoutDefault";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pickSqlSettings";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "pickSqlSettingsIfExists";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGeneralSqlSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findScheme";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copySettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 11, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 27, 31, 33, 34 -> new IllegalArgumentException(string);
        };
    }
}

