/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedRatedResolveResult;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCallExpressionHelper {
    private PyCallExpressionHelper() {
    }

    @Nullable
    public static Pair<String, PyFunction> interpretAsModifierWrappingCall(PyCallExpression redefiningCall) {
        PsiElement original;
        PyExpression possible_original_ref;
        PyExpression[] args;
        PyArgumentList argumentList;
        String refName;
        PyReferenceExpression referenceExpr;
        PyExpression redefining_callee = redefiningCall.getCallee();
        if (redefiningCall.isCalleeText(new String[]{"classmethod", "staticmethod"}) && (referenceExpr = (PyReferenceExpression)redefining_callee) != null && ("classmethod".equals(refName = referenceExpr.getReferencedName()) || "staticmethod".equals(refName)) && PyBuiltinCache.isInBuiltins(referenceExpr) && (argumentList = redefiningCall.getArgumentList()) != null && (args = argumentList.getArguments()).length == 1 && (possible_original_ref = args[0]) instanceof PyReferenceExpression && (original = ((PyReferenceExpression)possible_original_ref).getReference().resolve()) instanceof PyFunction) {
            return Pair.create((Object)refName, (Object)((PyFunction)original));
        }
        return null;
    }

    @Nullable
    public static PyClass resolveCalleeClass(PyCallExpression us) {
        PyExpression resolved;
        PyExpression callee = us.getCallee();
        if (callee instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)callee;
            QualifiedResolveResult resolveResult = ref.followAssignmentsChain(PyResolveContext.defaultContext(TypeEvalContext.codeInsightFallback(ref.getProject())));
            resolved = resolveResult.getElement();
        } else {
            resolved = callee;
        }
        if (resolved instanceof PyClass) {
            return (PyClass)((Object)resolved);
        }
        if (resolved instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)((Object)resolved);
            return pyFunction.getContainingClass();
        }
        return null;
    }

    @Nullable
    static PyType getCalleeType(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(0);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(1);
        }
        ArrayList<PyType> callableTypes = new ArrayList<PyType>();
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List<QualifiedRatedResolveResult> results = PyUtil.filterTopPriorityResults(PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(PyCallExpressionHelper.multiResolveCallee(call.getCallee(), resolveContext), RatedResolveResult::getElement, context));
        for (QualifiedRatedResolveResult resolveResult : results) {
            PyType typeFromProviders;
            PsiElement element = resolveResult.getElement();
            if (element != null && PyTypeUtil.toStream(typeFromProviders = (PyType)Ref.deref(PyReferenceExpressionImpl.getReferenceTypeFromProviders(element, resolveContext.getTypeEvalContext(), (PsiElement)call))).allMatch(it -> it instanceof PyCallableType)) {
                PyTypeUtil.toStream(typeFromProviders).forEachOrdered(callableTypes::add);
                continue;
            }
            for (ClarifiedResolveResult clarifiedResolveResult : PyCallExpressionHelper.clarifyResolveResult(resolveResult, resolveContext)) {
                ContainerUtil.addIfNotNull(callableTypes, (Object)PyCallExpressionHelper.toCallableType(call, clarifiedResolveResult, context));
            }
        }
        return PyUnionType.union(callableTypes);
    }

    @NotNull
    static @NotNull List<@NotNull PyCallableType> multiResolveCallee(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(3);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)call, resolveContext, it -> ContainerUtil.concat((List[])new List[]{PyCallExpressionHelper.getExplicitResolveResults(call, it), PyCallExpressionHelper.getImplicitResolveResults(call, it), PyCallExpressionHelper.getRemoteResolveResults(call, it)}));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> multiResolveCallee(@NotNull PyReferenceOwner subscription, @NotNull PyResolveContext resolveContext) {
        if (subscription == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(6);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List<PsiElement> results = PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(List.of(subscription.getReference(resolveContext).multiResolve(false)), context);
        return PyCallExpressionHelper.selectCallableTypes(results, context);
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> getExplicitResolveResults(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext) {
        PyExpression callee;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(7);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(8);
        }
        if ((callee = call.getCallee()) == null) {
            List<PyCallableType> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(9);
            }
            return list;
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PyType calleeType = context.getType(callee);
        List provided = StreamEx.of((Collection)PyTypeProvider.EP_NAME.getExtensionList()).map(e -> e.prepareCalleeTypeForCall(calleeType, call, context)).nonNull().toList();
        if (!provided.isEmpty()) {
            List list = ContainerUtil.mapNotNull((Collection)provided, Ref::deref);
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<PyCallableType> result2 = new ArrayList<PyCallableType>();
        for (PyType type2 : PyTypeUtil.toStream(calleeType)) {
            if (type2 instanceof PyClassType) {
                PyClassType classType = (PyClassType)type2;
                List<PsiElement> implicitlyInvokedMethods = PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(PyCallExpressionHelper.resolveImplicitlyInvokedMethods(classType, call, resolveContext), context);
                if (implicitlyInvokedMethods.isEmpty()) {
                    result2.add(classType);
                    continue;
                }
                result2.addAll(PyCallExpressionHelper.changeToImplicitlyInvokedMethods(classType, implicitlyInvokedMethods, call, context));
                continue;
            }
            if (!(type2 instanceof PyCallableType)) continue;
            result2.add((PyCallableType)type2);
        }
        ArrayList<PyCallableType> arrayList = result2;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> getImplicitResolveResults(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(12);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(13);
        }
        if (!resolveContext.allowImplicits()) {
            List<PyCallableType> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(14);
            }
            return list;
        }
        PyExpression callee = call.getCallee();
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        if (callee instanceof PyQualifiedExpression) {
            PyQualifiedExpression qualifiedCallee = (PyQualifiedExpression)callee;
            String referencedName = qualifiedCallee.getReferencedName();
            if (referencedName == null) {
                List<PyCallableType> list = Collections.emptyList();
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(15);
                }
                return list;
            }
            PyExpression qualifier = qualifiedCallee.getQualifier();
            if (qualifier == null || !PyCallExpressionHelper.canQualifyAnImplicitName(qualifier)) {
                List<PyCallableType> list = Collections.emptyList();
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(16);
                }
                return list;
            }
            PyType qualifierType = context.getType(qualifier);
            if (PyTypeChecker.isUnknown(qualifierType, context) || qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages()) {
                ResolveResultList resolveResults = new ResolveResultList();
                PyResolveUtil.addImplicitResolveResults(referencedName, resolveResults, qualifiedCallee);
                return PyCallExpressionHelper.selectCallableTypes(PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(resolveResults, context), context);
            }
        }
        List<PyCallableType> list = Collections.emptyList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> getRemoteResolveResults(@NotNull PyCallExpression call, @NotNull PyResolveContext resolveContext) {
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(18);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(19);
        }
        if (!resolveContext.allowRemote()) {
            List<PyCallableType> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(20);
            }
            return list;
        }
        PsiFile file = call.getContainingFile();
        if (file == null || !PythonRuntimeService.getInstance().isInPydevConsole((PsiElement)file)) {
            List<PyCallableType> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(21);
            }
            return list;
        }
        PyType calleeType = PyCallExpressionHelper.getCalleeType(call, resolveContext);
        List list = PyTypeUtil.toStream(calleeType).select(PyCallableType.class).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> selectCallableTypes(@NotNull List<PsiElement> resolveResults, @NotNull TypeEvalContext context) {
        if (resolveResults == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(24);
        }
        List list = StreamEx.of(resolveResults).select(PyTypedElement.class).map(context::getType).flatMap(PyTypeUtil::toStream).select(PyCallableType.class).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static List<QualifiedRatedResolveResult> multiResolveCallee(@Nullable PyExpression callee, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(26);
        }
        if (callee instanceof PyReferenceExpression) {
            List<QualifiedRatedResolveResult> list = ((PyReferenceExpression)callee).multiFollowAssignmentsChain(resolveContext);
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(27);
            }
            return list;
        }
        if (callee instanceof PyLambdaExpression) {
            List<QualifiedRatedResolveResult> list = Collections.singletonList(new QualifiedRatedResolveResult((PsiElement)callee, Collections.emptyList(), 0, false));
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<QualifiedRatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static List<ClarifiedResolveResult> clarifyResolveResult(@NotNull QualifiedRatedResolveResult resolveResult, @NotNull PyResolveContext resolveContext) {
        PsiElement resolved;
        if (resolveResult == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(30);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(31);
        }
        if ((resolved = resolveResult.getElement()) instanceof PyCallExpression) {
            PyCallExpression resolvedCall = (PyCallExpression)resolved;
            Pair<String, PyFunction> wrapperInfo = PyCallExpressionHelper.interpretAsModifierWrappingCall(resolvedCall);
            if (wrapperInfo != null) {
                String wrapperName = (String)wrapperInfo.getFirst();
                PyAstFunction.Modifier wrappedModifier = "classmethod".equals(wrapperName) ? PyAstFunction.Modifier.CLASSMETHOD : ("staticmethod".equals(wrapperName) ? PyAstFunction.Modifier.STATICMETHOD : null);
                ClarifiedResolveResult result2 = new ClarifiedResolveResult(resolveResult, (PsiElement)wrapperInfo.getSecond(), wrappedModifier, false);
                List<ClarifiedResolveResult> list = Collections.singletonList(result2);
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(32);
                }
                return list;
            }
        } else if (resolved instanceof PyFunction) {
            PyFunction function = (PyFunction)resolved;
            TypeEvalContext context = resolveContext.getTypeEvalContext();
            if (function.getProperty() != null && PyCallExpressionHelper.isQualifiedByInstance((PyCallable)function, resolveResult.getQualifiers(), context)) {
                PyType type2 = context.getReturnType(function);
                List<ClarifiedResolveResult> list = type2 instanceof PyFunctionType ? Collections.singletonList(new ClarifiedResolveResult(resolveResult, (PsiElement)((PyFunctionType)type2).getCallable(), null, false)) : Collections.emptyList();
                if (list == null) {
                    PyCallExpressionHelper.$$$reportNull$$$0(33);
                }
                return list;
            }
        }
        List<ClarifiedResolveResult> list = resolved != null ? Collections.singletonList(new ClarifiedResolveResult(resolveResult, resolved, null, resolved instanceof PyClass)) : Collections.emptyList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    private static PyCallableType toCallableType(@NotNull PyCallSiteExpression callSite, @NotNull ClarifiedResolveResult resolveResult, @NotNull TypeEvalContext context) {
        PsiElement clarifiedResolved;
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(35);
        }
        if (resolveResult == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(37);
        }
        if (!((clarifiedResolved = resolveResult.myClarifiedResolved) instanceof PyTypedElement)) {
            return null;
        }
        PyCallableType callableType = PyUtil.as(context.getType((PyTypedElement)clarifiedResolved), PyCallableType.class);
        if (callableType == null) {
            return null;
        }
        if (clarifiedResolved instanceof PyCallable) {
            PyType clarifiedConstructorCallType;
            PyCallable callable = (PyCallable)clarifiedResolved;
            PyAstFunction.Modifier originalModifier = callable instanceof PyFunction ? ((PyFunction)callable).getModifier() : null;
            PyAstFunction.Modifier resolvedModifier = (PyAstFunction.Modifier)ObjectUtils.chooseNotNull((Object)originalModifier, (Object)resolveResult.myWrappedModifier);
            boolean isConstructorCall = resolveResult.myIsConstructor;
            List<PyExpression> qualifiers = resolveResult.myOriginalResolveResult.getQualifiers();
            boolean isByInstance = isConstructorCall || PyCallExpressionHelper.isQualifiedByInstance(callable, qualifiers, context);
            PyExpression lastQualifier = (PyExpression)ContainerUtil.getLastItem(qualifiers);
            boolean isByClass = lastQualifier != null && PyCallExpressionHelper.isQualifiedByClass(callable, lastQualifier, context);
            int resolvedImplicitOffset = PyCallExpressionHelper.getImplicitArgumentCount(callable, resolvedModifier, isConstructorCall, isByInstance, isByClass);
            PyType pyType = clarifiedConstructorCallType = PyUtil.isInitOrNewMethod(clarifiedResolved) ? PyCallExpressionHelper.clarifyConstructorCallType(resolveResult, callSite, context) : null;
            if (callableType.getModifier() == resolvedModifier && callableType.getImplicitOffset() == resolvedImplicitOffset && clarifiedConstructorCallType == null) {
                return callableType;
            }
            return new PyCallableTypeImpl(callableType.getParameters(context), (PyType)ObjectUtils.chooseNotNull((Object)clarifiedConstructorCallType, (Object)callableType.getCallType(context, callSite)), callable, resolvedModifier, Math.max(0, resolvedImplicitOffset));
        }
        return callableType;
    }

    public static int getImplicitArgumentCount(@NotNull PyReferenceExpression callReference, @NotNull PyFunction function, @NotNull PyResolveContext resolveContext) {
        if (callReference == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(38);
        }
        if (function == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(39);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(40);
        }
        QualifiedResolveResult followed = callReference.followAssignmentsChain(resolveContext);
        List<PyExpression> qualifiers = followed.getQualifiers();
        PyExpression firstQualifier = (PyExpression)ContainerUtil.getFirstItem(qualifiers);
        boolean isByInstance = PyCallExpressionHelper.isQualifiedByInstance((PyCallable)function, qualifiers, resolveContext.getTypeEvalContext());
        String name2 = callReference.getName();
        boolean isConstructorCall = PyUtil.isInitOrNewMethod(function) && (!callReference.isQualified() || !"__init__".equals(name2) && !"__new__".equals(name2));
        boolean isByClass = firstQualifier != null && PyCallExpressionHelper.isQualifiedByClass(function, firstQualifier, resolveContext.getTypeEvalContext());
        return PyCallExpressionHelper.getImplicitArgumentCount(function, function.getModifier(), isConstructorCall, isByInstance, isByClass);
    }

    private static int getImplicitArgumentCount(PyCallable callable, PyAstFunction.Modifier modifier, boolean isConstructorCall, boolean isByInstance, boolean isByClass) {
        PyFunction method;
        PyParameter first;
        PyNamedParameter named;
        int implicit_offset = 0;
        boolean firstIsArgsOrKwargs = false;
        PyParameter[] parameters = callable.getParameterList().getParameters();
        if (parameters.length > 0 && (named = (first = parameters[0]).getAsNamed()) != null && (named.isPositionalContainer() || named.isKeywordContainer())) {
            firstIsArgsOrKwargs = true;
        }
        if (!firstIsArgsOrKwargs && (isByInstance || isConstructorCall)) {
            ++implicit_offset;
        }
        if ((method = callable.asMethod()) == null) {
            return implicit_offset;
        }
        if (PyUtil.isNewMethod(method)) {
            return isConstructorCall ? 1 : 0;
        }
        if (!isByInstance && !isByClass && PyUtil.isInitMethod(method)) {
            return 1;
        }
        if (modifier == PyAstFunction.Modifier.STATICMETHOD) {
            if (isByInstance && implicit_offset > 0) {
                --implicit_offset;
            }
        } else if (modifier == PyAstFunction.Modifier.CLASSMETHOD && !isByInstance) {
            ++implicit_offset;
        }
        return implicit_offset;
    }

    private static boolean isQualifiedByInstance(@Nullable PyCallable resolved, @NotNull List<PyExpression> qualifiers, @NotNull TypeEvalContext context) {
        PyDocStringOwner owner;
        if (qualifiers == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(42);
        }
        if (!((owner = (PyDocStringOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolved, PyDocStringOwner.class)) instanceof PyClass)) {
            return false;
        }
        if (qualifiers.isEmpty()) {
            return true;
        }
        for (PyExpression qualifier : qualifiers) {
            ThreeState byInstance;
            if (qualifier == null || (byInstance = PyCallExpressionHelper.isQualifiedByInstance(resolved, qualifier, context)) == ThreeState.UNSURE) continue;
            return byInstance.toBoolean();
        }
        return true;
    }

    @NotNull
    private static ThreeState isQualifiedByInstance(@Nullable PyCallable resolved, @NotNull PyExpression qualifier, @NotNull TypeEvalContext context) {
        if (qualifier == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(44);
        }
        if (PyCallExpressionHelper.isQualifiedByClass(resolved, qualifier, context)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(45);
            }
            return threeState;
        }
        PyType qualifierType = context.getType(qualifier);
        if (qualifierType instanceof PyModuleType) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(46);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(47);
        }
        return threeState;
    }

    private static boolean isQualifiedByClass(@Nullable PyCallable resolved, @NotNull PyExpression qualifier, @NotNull TypeEvalContext context) {
        Collection<PyType> members;
        PyType qualifierType;
        if (qualifier == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(48);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(49);
        }
        if ((qualifierType = context.getType(qualifier)) instanceof PyClassType) {
            PyClassType qualifierClassType = (PyClassType)qualifierType;
            return qualifierClassType.isDefinition() && PyCallExpressionHelper.belongsToSpecifiedClassHierarchy((PsiElement)resolved, qualifierClassType.getPyClass(), context);
        }
        if (qualifierType instanceof PyClassLikeType) {
            return ((PyClassLikeType)qualifierType).isDefinition();
        }
        if (qualifierType instanceof PyUnionType && ContainerUtil.all(members = ((PyUnionType)qualifierType).getMembers(), type2 -> type2 == null || type2 instanceof PyNoneType || type2 instanceof PyClassType)) {
            return ((StreamEx)StreamEx.of(members).select(PyClassType.class).filter(type2 -> PyCallExpressionHelper.belongsToSpecifiedClassHierarchy((PsiElement)resolved, type2.getPyClass(), context))).allMatch(PyInstantiableType::isDefinition);
        }
        return false;
    }

    private static boolean belongsToSpecifiedClassHierarchy(@Nullable PsiElement element, @NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyClass parent;
        if (cls == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(51);
        }
        return (parent = (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PyClass.class)) != null && (cls.isSubclass(parent, context) || parent.isSubclass(cls, context));
    }

    @Nullable
    static PyType getCallType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyType parametrizedType;
        PyExpression callee;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(52);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(53);
        }
        if (key == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(54);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression) {
            PyExpression[] args;
            Maybe<PyType> superCallType;
            if ("super".equals(callee.getText()) && (superCallType = PyCallExpressionHelper.getSuperCallType(call, context)).isDefined()) {
                return superCallType.value();
            }
            if ("type".equals(callee.getText()) && (args = call.getArguments()).length == 1) {
                PyExpression arg = args[0];
                PyType argType = context.getType(arg);
                if (argType instanceof PyClassType) {
                    PyClassType classType = (PyClassType)argType;
                    if (!classType.isDefinition()) {
                        PyClass cls = classType.getPyClass();
                        return context.getType(cls);
                    }
                } else {
                    return null;
                }
            }
        }
        if (callee instanceof PySubscriptionExpression && (parametrizedType = (PyType)Ref.deref(PyTypingTypeProvider.getType(callee, context))) != null) {
            return parametrizedType;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return PyCallExpressionHelper.getCallType(PyCallExpressionHelper.multiResolveCallee(call, resolveContext), call, context);
    }

    @Nullable
    static PyType getCallType(@NotNull PySubscriptionExpression subscription, @NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (subscription == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(56);
        }
        if (key == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(57);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return PyCallExpressionHelper.getCallType(PyCallExpressionHelper.multiResolveCallee(subscription, resolveContext), subscription, context);
    }

    @Nullable
    private static PyType getCallType(@NotNull @NotNull List<@NotNull PyCallableType> callableTypes, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        if (callableTypes == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(58);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(59);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(60);
        }
        Map callableByScopeBins = ((StreamEx)StreamEx.of(callableTypes).filter(PyCallableType::isCallable)).groupingBy(type2 -> {
            PyCallable callable = type2.getCallable();
            return Pair.create((Object)ScopeUtil.getScopeOwner((PsiElement)callable), (Object)(callable != null && PyiUtil.isOverload((PsiElement)callable, context) ? 1 : 0));
        }, LinkedHashMap::new, Collectors.toList());
        return (PyType)StreamEx.of(callableByScopeBins.values()).flatCollection(callables -> PyCallExpressionHelper.getSameScopeCallablesCallTypes(callables, callSite, context)).collect(PyTypeUtil.toUnion());
    }

    @Nullable
    public static PyType getCallType(@NotNull PyBinaryExpression binaryExpression, @NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyResolveContext resolveContext;
        List<PyCallableType> callableTypes;
        List matchingCallableTypes;
        if (binaryExpression == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(62);
        }
        if (key == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(63);
        }
        return (matchingCallableTypes = ContainerUtil.filter(callableTypes = PyCallExpressionHelper.multiResolveCallee(binaryExpression, resolveContext = PyResolveContext.defaultContext(context)), callable -> {
            PyFunction function;
            PyCallable patt26680$temp = callable.getCallable();
            return patt26680$temp instanceof PyFunction && PyCallExpressionHelper.matchesByArgumentTypes(function = (PyFunction)patt26680$temp, binaryExpression, context);
        })).isEmpty() ? PyCallExpressionHelper.getCallType(callableTypes, binaryExpression, context) : PyCallExpressionHelper.getCallType(matchingCallableTypes, binaryExpression, context);
    }

    @NotNull
    private static List<PyType> getSameScopeCallablesCallTypes(@NotNull List<PyCallableType> callables, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyCallable firstCallable;
        if (callables == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(64);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(65);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(66);
        }
        if ((firstCallable = callables.get(0).getCallable()) != null && PyiUtil.isOverload((PsiElement)firstCallable, context)) {
            List<PyType> list = Collections.singletonList(PyCallExpressionHelper.resolveOverloadsCallType(callables, callSite, context));
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(67);
            }
            return list;
        }
        List list = ContainerUtil.map(callables, callable -> callable.getCallType(context, callSite));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(68);
        }
        return list;
    }

    @Nullable
    private static PyType resolveOverloadsCallType(@NotNull List<PyCallableType> overloads, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        if (overloads == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(69);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(71);
        }
        List<PyExpression> arguments = callSite.getArguments(overloads.get(0).getCallable());
        List matchingOverloads = ContainerUtil.filter(overloads, overload -> PyCallExpressionHelper.matchesByArgumentTypes((PyFunction)overload.getCallable(), callSite, context));
        if (matchingOverloads.isEmpty()) {
            return (PyType)StreamEx.of(overloads).map(overload -> overload.getCallType(context, callSite)).collect(PyTypeUtil.toUnion());
        }
        if (matchingOverloads.size() == 1) {
            return ((PyCallableType)matchingOverloads.get(0)).getCallType(context, callSite);
        }
        boolean someArgumentsHaveUnknownType = ContainerUtil.exists(arguments, arg -> context.getType((PyTypedElement)arg) == null);
        if (someArgumentsHaveUnknownType) {
            return (PyType)StreamEx.of((Collection)matchingOverloads).map(overload -> overload.getCallType(context, callSite)).collect(PyTypeUtil.toUnion());
        }
        return StreamEx.of((Collection)matchingOverloads).findFirst().map(callableType -> callableType.getCallType(context, callSite)).orElse(null);
    }

    @Nullable
    private static PyType clarifyConstructorCallType(@NotNull ClarifiedResolveResult initOrNew, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        if (initOrNew == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(72);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(74);
        }
        PyFunction initOrNewMethod = (PyFunction)initOrNew.myClarifiedResolved;
        PyClass initOrNewClass = initOrNewMethod.getContainingClass();
        PyClass receiverClass = (PyClass)ObjectUtils.notNull((Object)PyUtil.as(initOrNew.myOriginalResolveResult.getElement(), PyClass.class), (Object)Objects.requireNonNull(initOrNewClass));
        PyType initOrNewCallType = initOrNewMethod.getCallType(context, callSite);
        if (receiverClass != initOrNewClass) {
            if (initOrNewCallType instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)initOrNewCallType;
                return new PyTupleType(receiverClass, tupleType.getElementTypes(), tupleType.isHomogeneous());
            }
            if (initOrNewCallType instanceof PyCollectionType) {
                List<PyType> elementTypes = ((PyCollectionType)initOrNewCallType).getElementTypes();
                return new PyCollectionTypeImpl(receiverClass, false, elementTypes);
            }
            return new PyClassTypeImpl(receiverClass, false);
        }
        if (initOrNewCallType instanceof PyCollectionType) {
            return initOrNewCallType;
        }
        if (initOrNewCallType == null) {
            return PyUnionType.createWeakType(new PyClassTypeImpl(receiverClass, false));
        }
        return null;
    }

    @NotNull
    private static Maybe<PyType> getSuperCallType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyArgumentList argumentList;
        PsiElement must_be_super;
        PyExpression callee;
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(75);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(76);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression && (must_be_super = ((PyReferenceExpression)callee).getReference().resolve()) == PyBuiltinCache.getInstance((PsiElement)call).getClass("super") && (argumentList = call.getArgumentList()) != null) {
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)call, PyClass.class);
            PyExpression[] args = argumentList.getArguments();
            if (containingClass != null && args.length > 1) {
                PyExpression first_arg = args[0];
                if (first_arg instanceof PyReferenceExpression) {
                    PyClass first_class;
                    PsiElement possible_class;
                    PyReferenceExpression firstArgRef = (PyReferenceExpression)first_arg;
                    PyExpression qualifier = firstArgRef.getQualifier();
                    if (qualifier != null && "__class__".equals(firstArgRef.getReferencedName())) {
                        PyParameterList parameterList;
                        PsiElement element;
                        PsiReference qRef = qualifier.getReference();
                        PsiElement psiElement = element = qRef == null ? null : qRef.resolve();
                        if (element instanceof PyParameter && (parameterList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class)) != null && element == parameterList.getParameters()[0]) {
                            return new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, containingClass, args[1]));
                        }
                    }
                    if ((possible_class = firstArgRef.getReference().resolve()) instanceof PyClass && (first_class = (PyClass)possible_class).isNewStyleClass(context)) {
                        return new Maybe<PyType>(PyCallExpressionHelper.getSuperCallTypeForArguments(context, first_class, args[1]));
                    }
                }
            } else if (call.getContainingFile() instanceof PyFile && ((PyFile)call.getContainingFile()).getLanguageLevel().isPy3K() && containingClass != null) {
                return new Maybe<PyType>(PyCallExpressionHelper.getSuperClassUnionType(containingClass, context));
            }
        }
        return new Maybe<PyType>();
    }

    @Nullable
    private static PyType getSuperCallTypeForArguments(@NotNull TypeEvalContext context, @NotNull PyClass firstClass, @Nullable PyExpression second_arg) {
        PyType second_type;
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(77);
        }
        if (firstClass == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(78);
        }
        if (second_arg != null && (second_type = context.getType(second_arg)) instanceof PyClassType) {
            PyClass nextAfterFirstInMro;
            PyClass secondClass = ((PyClassType)second_type).getPyClass();
            if (CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)firstClass) == secondClass) {
                return PyCallExpressionHelper.getSuperClassUnionType(firstClass, context);
            }
            if (secondClass.isSubclass(firstClass, context) && (nextAfterFirstInMro = (PyClass)((StreamEx)((StreamEx)StreamEx.of(secondClass.getAncestorClasses(context)).dropWhile(it -> it != firstClass)).skip(1L)).findFirst().orElse(null)) != null) {
                return new PyClassTypeImpl(nextAfterFirstInMro, false);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getSuperClassUnionType(@NotNull PyClass pyClass, TypeEvalContext context) {
        PyClass[] supers;
        if (pyClass == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(79);
        }
        if ((supers = pyClass.getSuperClasses(context)).length > 0) {
            if (supers.length == 1) {
                return new PyClassTypeImpl(supers[0], false);
            }
            ArrayList<PyType> superTypes = new ArrayList<PyType>();
            for (PyClass aSuper : supers) {
                superTypes.add(new PyClassTypeImpl(aSuper, false));
            }
            return PyUnionType.union(superTypes);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static List<PyCallableParameter> getMappedParameters(@NotNull PyExpression argument, @NotNull PyResolveContext resolveContext) {
        PsiElement parent;
        PsiElement psiElement;
        if (argument == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(80);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(81);
        }
        while ((psiElement = argument.getParent()) instanceof PyParenthesizedExpression) {
            PyParenthesizedExpression parenthesizedExpr = (PyParenthesizedExpression)psiElement;
            argument = parenthesizedExpr;
        }
        psiElement = argument.getParent();
        if (psiElement instanceof PyKeywordArgument) {
            PyKeywordArgument keywordArgument = (PyKeywordArgument)psiElement;
            assert (keywordArgument.getValueExpression() == argument);
            argument = keywordArgument;
        }
        if ((parent = argument.getParent()) instanceof PyArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PyCallSiteExpression)) {
            return null;
        }
        PyCallSiteExpression callSite = (PyCallSiteExpression)parent;
        PyExpression finalArgument = argument;
        return ContainerUtil.mapNotNull(PyCallExpressionHelper.mapArguments(callSite, resolveContext), mapping -> mapping.getMappedParameters().get(finalArgument));
    }

    @NotNull
    public static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyCallableType callableType, @NotNull TypeEvalContext context) {
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(82);
        }
        if (callableType == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(83);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(84);
        }
        return PyCallExpressionHelper.mapArguments(callSite, callSite.getArguments(callableType.getCallable()), callableType, context);
    }

    @NotNull
    private static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull List<PyExpression> arguments, @NotNull PyCallableType callableType, @NotNull TypeEvalContext context) {
        List<PyCallableParameter> parameters;
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(85);
        }
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(86);
        }
        if (callableType == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(87);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(88);
        }
        if ((parameters = callableType.getParameters(context)) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callSite);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(89);
            }
            return pyArgumentsMapping;
        }
        int safeImplicitOffset = Math.min(callableType.getImplicitOffset(), parameters.size());
        List<PyCallableParameter> explicitParameters = parameters.subList(safeImplicitOffset, parameters.size());
        List<PyCallableParameter> implicitParameters = parameters.subList(0, safeImplicitOffset);
        ArgumentMappingResults mappingResults = PyCallExpressionHelper.analyzeArguments(arguments, explicitParameters, context);
        return new PyCallExpression.PyArgumentsMapping(callSite, callableType, implicitParameters, mappingResults.getMappedParameters(), mappingResults.getUnmappedParameters(), mappingResults.getUnmappedContainerParameters(), mappingResults.getUnmappedArguments(), mappingResults.getParametersMappedToVariadicPositionalArguments(), mappingResults.getParametersMappedToVariadicKeywordArguments(), mappingResults.getMappedTupleParameters());
    }

    @NotNull
    public static @NotNull List<@NotNull PyCallExpression.PyArgumentsMapping> mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(90);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(91);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List list = ContainerUtil.map(PyCallExpressionHelper.multiResolveCalleeFunction(callSite, resolveContext), type2 -> PyCallExpressionHelper.mapArguments(callSite, type2, context));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(92);
        }
        return list;
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> multiResolveCalleeFunction(@NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(93);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(94);
        }
        if (callSite instanceof PyCallExpression) {
            List<PyCallableType> list = ((PyCallExpression)callSite).multiResolveCallee(resolveContext);
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(95);
            }
            return list;
        }
        if (callSite instanceof PySubscriptionExpression) {
            return PyCallExpressionHelper.multiResolveCallee((PyReferenceOwner)((Object)callSite), resolveContext);
        }
        ArrayList<PyCallableType> results = new ArrayList<PyCallableType>();
        for (PsiElement result2 : PyUtil.multiResolveTopPriority((PsiElement)callSite, resolveContext)) {
            PyType resultType;
            if (result2 instanceof PyTypedElement && (resultType = resolveContext.getTypeEvalContext().getType((PyTypedElement)result2)) instanceof PyCallableType) {
                results.add((PyCallableType)resultType);
                continue;
            }
            List<PyCallableType> list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(96);
            }
            return list;
        }
        ArrayList<PyCallableType> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(97);
        }
        return arrayList;
    }

    @NotNull
    public static PyCallExpression.PyArgumentsMapping mapArguments(@NotNull PyCallSiteExpression callSite, @NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        PyCallableType callableType;
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(98);
        }
        if (callable == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(99);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(100);
        }
        if ((callableType = PyUtil.as(context.getType(callable), PyCallableType.class)) == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callSite);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(101);
            }
            return pyArgumentsMapping;
        }
        List<PyCallableParameter> parameters = callableType.getParameters(context);
        if (parameters == null) {
            PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpression.PyArgumentsMapping.empty(callSite);
            if (pyArgumentsMapping == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(102);
            }
            return pyArgumentsMapping;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        List<PyExpression> arguments = callSite.getArguments(callable);
        List<PyCallableParameter> explicitParameters = PyCallExpressionHelper.filterExplicitParameters(parameters, callable, callSite, resolveContext);
        List<PyCallableParameter> implicitParameters = parameters.subList(0, parameters.size() - explicitParameters.size());
        ArgumentMappingResults mappingResults = PyCallExpressionHelper.analyzeArguments(arguments, explicitParameters, context);
        return new PyCallExpression.PyArgumentsMapping(callSite, callableType, implicitParameters, mappingResults.getMappedParameters(), mappingResults.getUnmappedParameters(), mappingResults.getUnmappedContainerParameters(), mappingResults.getUnmappedArguments(), mappingResults.getParametersMappedToVariadicPositionalArguments(), mappingResults.getParametersMappedToVariadicKeywordArguments(), mappingResults.getMappedTupleParameters());
    }

    @NotNull
    public static <T> List<T> getArgumentsMappedToPositionalContainer(@NotNull Map<T, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(103);
        }
        List list = StreamEx.ofKeys(mapping, PyCallableParameter::isPositionalContainer).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(104);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> getArgumentsMappedToKeywordContainer(@NotNull Map<T, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(105);
        }
        List list = StreamEx.ofKeys(mapping, PyCallableParameter::isKeywordContainer).toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(106);
        }
        return list;
    }

    @NotNull
    public static <T> Map<T, PyCallableParameter> getRegularMappedParameters(@NotNull Map<T, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(107);
        }
        LinkedHashMap<T, PyCallableParameter> result2 = new LinkedHashMap<T, PyCallableParameter>();
        for (Map.Entry<T, PyCallableParameter> entry : mapping.entrySet()) {
            T argument = entry.getKey();
            PyCallableParameter parameter = entry.getValue();
            if (parameter.isPositionalContainer() || parameter.isKeywordContainer()) continue;
            result2.put(argument, parameter);
        }
        LinkedHashMap<T, PyCallableParameter> linkedHashMap = result2;
        if (linkedHashMap == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(108);
        }
        return linkedHashMap;
    }

    @Nullable
    public static <T> PyCallableParameter getMappedPositionalContainer(@NotNull Map<T, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(109);
        }
        return (PyCallableParameter)ContainerUtil.find(mapping.values(), p -> p.isPositionalContainer());
    }

    @Nullable
    public static <T> PyCallableParameter getMappedKeywordContainer(@NotNull Map<T, PyCallableParameter> mapping) {
        if (mapping == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(110);
        }
        return (PyCallableParameter)ContainerUtil.find(mapping.values(), p -> p.isKeywordContainer());
    }

    @NotNull
    public static List<? extends RatedResolveResult> resolveImplicitlyInvokedMethods(@NotNull PyClassType type2, @Nullable PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        if (type2 == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(111);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(112);
        }
        return type2.isDefinition() ? PyCallExpressionHelper.resolveConstructors(type2, callSite, resolveContext) : PyCallExpressionHelper.resolveDunderCall(type2, callSite, resolveContext);
    }

    @NotNull
    private static @NotNull List<@NotNull PyCallableType> changeToImplicitlyInvokedMethods(@NotNull PyClassType classType, @NotNull List<PsiElement> implicitlyInvokedMethods, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (classType == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(113);
        }
        if (implicitlyInvokedMethods == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(114);
        }
        if (call == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(115);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(116);
        }
        PyClass cls = classType.getPyClass();
        List list = StreamEx.of(implicitlyInvokedMethods).map(it -> new ClarifiedResolveResult(new QualifiedRatedResolveResult(cls, Collections.emptyList(), 0, false), (PsiElement)it, null, PyUtil.isInitOrNewMethod(it))).map(it -> PyCallExpressionHelper.toCallableType(call, it, context)).nonNull().toList();
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(117);
        }
        return list;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveConstructors(@NotNull PyClassType type2, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        List<? extends RatedResolveResult> metaclassDunderCall;
        if (type2 == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(118);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(119);
        }
        if (!(metaclassDunderCall = PyCallExpressionHelper.resolveMetaclassDunderCall(type2, location, resolveContext)).isEmpty()) {
            List<? extends RatedResolveResult> list = metaclassDunderCall;
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(120);
            }
            return list;
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        List<PyFunction> initAndNew = type2.getPyClass().multiFindInitOrNew(true, context);
        List list = ContainerUtil.map(PyCallExpressionHelper.preferInitOverNew(initAndNew), e -> new RatedResolveResult(PyReferenceImpl.getRate(e, context), (PsiElement)e));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(121);
        }
        return list;
    }

    @NotNull
    private static Collection<? extends PyFunction> preferInitOverNew(@NotNull List<PyFunction> initAndNew) {
        MultiMap functions;
        if (initAndNew == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(122);
        }
        Collection collection = (functions = ContainerUtil.groupBy(initAndNew, PyAstFunction::getName)).containsKey((Object)"__init__") ? functions.get((Object)"__init__") : functions.values();
        if (collection == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(123);
        }
        return collection;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveMetaclassDunderCall(@NotNull PyClassType type2, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        TypeEvalContext context;
        PyClassLikeType metaClassType;
        if (type2 == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(124);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(125);
        }
        if ((metaClassType = type2.getMetaClassType(context = resolveContext.getTypeEvalContext(), true)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(126);
            }
            return list;
        }
        PyClassType typeType = PyBuiltinCache.getInstance(type2.getPyClass()).getTypeType();
        if (metaClassType == typeType) {
            List list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(127);
            }
            return list;
        }
        List<? extends RatedResolveResult> results = PyCallExpressionHelper.resolveDunderCall(metaClassType, location, resolveContext);
        if (results.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(128);
            }
            return list;
        }
        Set typeDunderCall = typeType == null ? Collections.emptySet() : ContainerUtil.map2SetNotNull(PyCallExpressionHelper.resolveDunderCall(typeType, null, resolveContext), RatedResolveResult::getElement);
        List list = ContainerUtil.filter(results, it -> {
            PsiElement element = it.getElement();
            return !typeDunderCall.contains(element) && !ParamHelper.isSelfArgsKwargsCallable(element, context);
        });
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(129);
        }
        return list;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveDunderCall(@NotNull PyClassLikeType type2, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        if (type2 == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(130);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(131);
        }
        List list = ContainerUtil.notNullize(type2.resolveMember("__call__", location, AccessDirection.READ, resolveContext));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(132);
        }
        return list;
    }

    @NotNull
    public static ArgumentMappingResults analyzeArguments(@NotNull List<PyExpression> arguments, @NotNull List<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(133);
        }
        if (parameters == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(134);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(135);
        }
        boolean positionalOnlyMode = ContainerUtil.exists(parameters, p -> p.getParameter() instanceof PySlashParameter);
        boolean seenSingleStar = false;
        boolean mappedVariadicArgumentsToParameters = false;
        LinkedHashMap<PyExpression, PyCallableParameter> mappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        ArrayList<PyCallableParameter> unmappedParameters = new ArrayList<PyCallableParameter>();
        ArrayList<PyCallableParameter> unmappedContainerParameters = new ArrayList<PyCallableParameter>();
        ArrayList<PyExpression> unmappedArguments = new ArrayList<PyExpression>();
        ArrayList<PyCallableParameter> parametersMappedToVariadicKeywordArguments = new ArrayList<PyCallableParameter>();
        ArrayList<PyCallableParameter> parametersMappedToVariadicPositionalArguments = new ArrayList<PyCallableParameter>();
        LinkedHashMap<PyExpression, PyCallableParameter> tupleMappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PositionalArgumentsAnalysisResults positionalResults = PyCallExpressionHelper.filterPositionalAndVariadicArguments(arguments);
        List<PyKeywordArgument> keywordArguments = PyCallExpressionHelper.filterKeywordArguments(arguments);
        List<PyExpression> variadicPositionalArguments = positionalResults.variadicPositionalArguments;
        LinkedHashSet<PyExpression> positionalComponentsOfVariadicArguments = new LinkedHashSet<PyExpression>(positionalResults.componentsOfVariadicPositionalArguments);
        List<PyExpression> variadicKeywordArguments = PyCallExpressionHelper.filterVariadicKeywordArguments(arguments);
        List<PyExpression> allPositionalArguments = positionalResults.allPositionalArguments;
        for (PyCallableParameter parameter : parameters) {
            PyParameter psi = parameter.getParameter();
            if (psi instanceof PyNamedParameter || psi == null) {
                PyExpression positionalArgument;
                Object keywordArgument;
                String parameterName = parameter.getName();
                if (parameter.isPositionalContainer()) {
                    for (PyExpression pyExpression : allPositionalArguments) {
                        if (pyExpression == null) continue;
                        mappedParameters.put(pyExpression, parameter);
                    }
                    if (variadicPositionalArguments.size() == 1) {
                        mappedParameters.put(variadicPositionalArguments.get(0), parameter);
                    }
                    if (variadicPositionalArguments.size() != 1 && allPositionalArguments.isEmpty()) {
                        unmappedContainerParameters.add(parameter);
                    }
                    allPositionalArguments.clear();
                    variadicPositionalArguments.clear();
                    continue;
                }
                if (parameter.isKeywordContainer()) {
                    for (PyKeywordArgument pyKeywordArgument : keywordArguments) {
                        mappedParameters.put(pyKeywordArgument, parameter);
                    }
                    for (PyExpression pyExpression : variadicKeywordArguments) {
                        mappedParameters.put(pyExpression, parameter);
                    }
                    keywordArguments.clear();
                    variadicKeywordArguments.clear();
                    continue;
                }
                if (seenSingleStar) {
                    keywordArgument = PyCallExpressionHelper.removeKeywordArgument(keywordArguments, parameterName);
                    if (keywordArgument != null) {
                        mappedParameters.put((PyExpression)keywordArgument, parameter);
                        continue;
                    }
                    if (variadicKeywordArguments.isEmpty()) {
                        if (parameter.hasDefaultValue()) continue;
                        unmappedParameters.add(parameter);
                        continue;
                    }
                    parametersMappedToVariadicKeywordArguments.add(parameter);
                    mappedVariadicArgumentsToParameters = true;
                    continue;
                }
                if (PyCallExpressionHelper.isParamSpecOrConcatenate(parameter, context)) {
                    for (PyExpression pyExpression : arguments) {
                        mappedParameters.put(pyExpression, parameter);
                    }
                    allPositionalArguments.clear();
                    keywordArguments.clear();
                    variadicPositionalArguments.clear();
                    variadicKeywordArguments.clear();
                    continue;
                }
                if (positionalOnlyMode) {
                    positionalArgument = PyCallExpressionHelper.next(allPositionalArguments);
                    if (positionalArgument != null) {
                        mappedParameters.put(positionalArgument, parameter);
                        continue;
                    }
                    if (parameter.hasDefaultValue()) continue;
                    unmappedParameters.add(parameter);
                    continue;
                }
                if (allPositionalArguments.isEmpty()) {
                    keywordArgument = PyCallExpressionHelper.removeKeywordArgument(keywordArguments, parameterName);
                    if (keywordArgument != null) {
                        mappedParameters.put((PyExpression)keywordArgument, parameter);
                        continue;
                    }
                    if (variadicPositionalArguments.isEmpty() && variadicKeywordArguments.isEmpty() && !parameter.hasDefaultValue()) {
                        unmappedParameters.add(parameter);
                        continue;
                    }
                    if (!variadicPositionalArguments.isEmpty()) {
                        parametersMappedToVariadicPositionalArguments.add(parameter);
                    }
                    if (!variadicKeywordArguments.isEmpty()) {
                        parametersMappedToVariadicKeywordArguments.add(parameter);
                    }
                    mappedVariadicArgumentsToParameters = true;
                    continue;
                }
                positionalArgument = PyCallExpressionHelper.next(allPositionalArguments);
                if (positionalArgument != null) {
                    mappedParameters.put(positionalArgument, parameter);
                    if (!positionalComponentsOfVariadicArguments.contains(positionalArgument)) continue;
                    parametersMappedToVariadicPositionalArguments.add(parameter);
                    continue;
                }
                if (parameter.hasDefaultValue()) continue;
                unmappedParameters.add(parameter);
                continue;
            }
            if (psi instanceof PyTupleParameter) {
                PyExpression positionalArgument = PyCallExpressionHelper.next(allPositionalArguments);
                if (positionalArgument != null) {
                    tupleMappedParameters.put(positionalArgument, parameter);
                    TupleMappingResults tupleMappingResults = PyCallExpressionHelper.mapComponentsOfTupleParameter(positionalArgument, (PyTupleParameter)psi);
                    mappedParameters.putAll(tupleMappingResults.getParameters());
                    unmappedParameters.addAll(tupleMappingResults.getUnmappedParameters());
                    unmappedArguments.addAll(tupleMappingResults.getUnmappedArguments());
                    continue;
                }
                if (variadicPositionalArguments.isEmpty()) {
                    if (parameter.hasDefaultValue()) continue;
                    unmappedParameters.add(parameter);
                    continue;
                }
                mappedVariadicArgumentsToParameters = true;
                continue;
            }
            if (psi instanceof PySlashParameter) {
                positionalOnlyMode = false;
                continue;
            }
            if (psi instanceof PySingleStarParameter) {
                seenSingleStar = true;
                continue;
            }
            if (parameter.hasDefaultValue()) continue;
            unmappedParameters.add(parameter);
        }
        if (mappedVariadicArgumentsToParameters) {
            variadicPositionalArguments.clear();
            variadicKeywordArguments.clear();
        }
        unmappedArguments.addAll(allPositionalArguments);
        unmappedArguments.addAll(keywordArguments);
        unmappedArguments.addAll(variadicPositionalArguments);
        unmappedArguments.addAll(variadicKeywordArguments);
        return new ArgumentMappingResults(mappedParameters, unmappedParameters, unmappedContainerParameters, unmappedArguments, parametersMappedToVariadicPositionalArguments, parametersMappedToVariadicKeywordArguments, tupleMappedParameters);
    }

    private static boolean isParamSpecOrConcatenate(@NotNull PyCallableParameter parameter, @NotNull TypeEvalContext context) {
        PyType type2;
        if (parameter == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(137);
        }
        return (type2 = parameter.getType(context)) instanceof PyParamSpecType || type2 instanceof PyConcatenateType;
    }

    @NotNull
    private static List<PsiElement> forEveryScopeTakeOverloadsOtherwiseImplementations(@NotNull List<? extends ResolveResult> results, @NotNull TypeEvalContext context) {
        if (results == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(138);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(139);
        }
        List<PsiElement> list = PyUtil.filterTopPriorityElements(PyCallExpressionHelper.forEveryScopeTakeOverloadsOtherwiseImplementations(results, ResolveResult::getElement, context));
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(140);
        }
        return list;
    }

    @NotNull
    private static <E extends ResolveResult> List<E> forEveryScopeTakeOverloadsOtherwiseImplementations(@NotNull List<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(141);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(142);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(143);
        }
        if (!PyCallExpressionHelper.containsOverloadsAndImplementations(elements, mapper, context)) {
            List<E> list = elements;
            if (list == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(144);
            }
            return list;
        }
        List list = ((LinkedHashMap)StreamEx.of(elements).groupingBy(element -> Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)mapper.apply((Object)element))), LinkedHashMap::new, Collectors.toList())).values().stream().flatMap(oneScopeElements -> PyCallExpressionHelper.takeOverloadsOtherwiseImplementations(oneScopeElements, mapper, context)).collect(Collectors.toList());
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(145);
        }
        return list;
    }

    private static <E extends ResolveResult> boolean containsOverloadsAndImplementations(@NotNull Collection<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(146);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(147);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(148);
        }
        boolean containsOverloads = false;
        boolean containsImplementations = false;
        for (ResolveResult element : elements) {
            PsiElement mapped = mapper.apply(element);
            if (mapped == null) continue;
            boolean overload = PyiUtil.isOverload(mapped, context);
            if (!(containsOverloads |= overload) || !(containsImplementations |= !overload)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static <E extends ResolveResult> Stream<E> takeOverloadsOtherwiseImplementations(@NotNull List<E> elements, @NotNull Function<? super E, PsiElement> mapper, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(149);
        }
        if (mapper == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(150);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(151);
        }
        if (!PyCallExpressionHelper.containsOverloadsAndImplementations(elements, mapper, context)) {
            Stream stream = elements.stream();
            if (stream == null) {
                PyCallExpressionHelper.$$$reportNull$$$0(152);
            }
            return stream;
        }
        Stream<ResolveResult> stream = elements.stream().filter(element -> {
            PsiElement mapped = (PsiElement)mapper.apply((Object)element);
            return mapped != null && (PyiUtil.isInsideStub(mapped) || PyiUtil.isOverload(mapped, context));
        });
        if (stream == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(153);
        }
        return stream;
    }

    private static boolean matchesByArgumentTypes(@NotNull PyFunction callable, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyCallExpression.PyArgumentsMapping fullMapping;
        if (callable == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(154);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(155);
        }
        if (context == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(156);
        }
        if (!(fullMapping = PyCallExpressionHelper.mapArguments(callSite, callable, context)).isComplete()) {
            return false;
        }
        PyExpression receiver = callSite.getReceiver(callable);
        Map<PyExpression, PyCallableParameter> mappedExplicitParameters = fullMapping.getMappedParameters();
        LinkedHashMap<PyExpression, PyCallableParameter> allMappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PyCallableParameter firstImplicit = (PyCallableParameter)ContainerUtil.getFirstItem(fullMapping.getImplicitParameters());
        if (receiver != null && firstImplicit != null) {
            allMappedParameters.put(receiver, firstImplicit);
        }
        allMappedParameters.putAll(mappedExplicitParameters);
        return PyTypeChecker.unifyGenericCall(receiver, allMappedParameters, context) != null;
    }

    @NotNull
    private static TupleMappingResults mapComponentsOfTupleParameter(@Nullable PyExpression argument, @NotNull PyTupleParameter parameter) {
        if (parameter == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(157);
        }
        ArrayList<PyCallableParameter> unmappedParameters = new ArrayList<PyCallableParameter>();
        ArrayList<PyExpression> unmappedArguments = new ArrayList<PyExpression>();
        LinkedHashMap<PyExpression, PyCallableParameter> mappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        if ((argument = PyPsiUtils.flattenParens(argument)) instanceof PySequenceExpression) {
            int i;
            PySequenceExpression sequenceExpr = (PySequenceExpression)argument;
            PyExpression[] argumentComponents = sequenceExpr.getElements();
            PyParameter[] parameterComponents = parameter.getContents();
            for (i = 0; i < parameterComponents.length; ++i) {
                PyParameter param = parameterComponents[i];
                if (i < argumentComponents.length) {
                    PyExpression arg = argumentComponents[i];
                    if (arg != null) {
                        if (param instanceof PyNamedParameter) {
                            mappedParameters.put(arg, PyCallableParameterImpl.psi(param));
                            continue;
                        }
                        if (param instanceof PyTupleParameter) {
                            TupleMappingResults nestedResults = PyCallExpressionHelper.mapComponentsOfTupleParameter(arg, (PyTupleParameter)param);
                            mappedParameters.putAll(nestedResults.getParameters());
                            unmappedParameters.addAll(nestedResults.getUnmappedParameters());
                            unmappedArguments.addAll(nestedResults.getUnmappedArguments());
                            continue;
                        }
                        unmappedArguments.add(arg);
                        continue;
                    }
                    unmappedParameters.add(PyCallableParameterImpl.psi(param));
                    continue;
                }
                unmappedParameters.add(PyCallableParameterImpl.psi(param));
            }
            if (argumentComponents.length > parameterComponents.length) {
                for (i = parameterComponents.length; i < argumentComponents.length; ++i) {
                    PyExpression arg = argumentComponents[i];
                    if (arg == null) continue;
                    unmappedArguments.add(arg);
                }
            }
        }
        return new TupleMappingResults(mappedParameters, unmappedParameters, unmappedArguments);
    }

    @Nullable
    private static PyKeywordArgument removeKeywordArgument(@NotNull List<PyKeywordArgument> arguments, @Nullable String name2) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(158);
        }
        PyKeywordArgument result2 = null;
        for (PyKeywordArgument argument : arguments) {
            String keyword = argument.getKeyword();
            if (keyword == null || !keyword.equals(name2)) continue;
            result2 = argument;
            break;
        }
        if (result2 != null) {
            arguments.remove(result2);
        }
        return result2;
    }

    @NotNull
    private static List<PyKeywordArgument> filterKeywordArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(159);
        }
        ArrayList<PyKeywordArgument> results = new ArrayList<PyKeywordArgument>();
        for (PyExpression argument : arguments) {
            if (!(argument instanceof PyKeywordArgument)) continue;
            results.add((PyKeywordArgument)argument);
        }
        ArrayList<PyKeywordArgument> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(160);
        }
        return arrayList;
    }

    @NotNull
    private static PositionalArgumentsAnalysisResults filterPositionalAndVariadicArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(161);
        }
        ArrayList<PyExpression> variadicArguments = new ArrayList<PyExpression>();
        ArrayList<PyExpression> allPositionalArguments = new ArrayList<PyExpression>();
        ArrayList<PyExpression> componentsOfVariadicPositionalArguments = new ArrayList<PyExpression>();
        boolean seenVariadicPositionalArgument = false;
        boolean seenVariadicKeywordArgument = false;
        boolean seenKeywordArgument = false;
        for (PyExpression argument : arguments) {
            if (argument instanceof PyStarArgument) {
                if (((PyStarArgument)argument).isKeyword()) {
                    seenVariadicKeywordArgument = true;
                    continue;
                }
                seenVariadicPositionalArgument = true;
                PyExpression expr = PyPsiUtils.flattenParens((PyExpression)PsiTreeUtil.getChildOfType((PsiElement)argument, PyExpression.class));
                if (expr instanceof PySequenceExpression) {
                    PySequenceExpression sequenceExpr = (PySequenceExpression)expr;
                    List<PyExpression> elements = Arrays.asList(sequenceExpr.getElements());
                    allPositionalArguments.addAll(elements);
                    componentsOfVariadicPositionalArguments.addAll(elements);
                    continue;
                }
                variadicArguments.add(argument);
                continue;
            }
            if (argument instanceof PyKeywordArgument) {
                seenKeywordArgument = true;
                continue;
            }
            if (seenKeywordArgument || seenVariadicKeywordArgument || seenVariadicPositionalArgument && LanguageLevel.forElement((PsiElement)argument).isOlderThan(LanguageLevel.PYTHON35)) continue;
            allPositionalArguments.add(argument);
        }
        return new PositionalArgumentsAnalysisResults(allPositionalArguments, componentsOfVariadicPositionalArguments, variadicArguments);
    }

    @NotNull
    private static List<PyExpression> filterVariadicKeywordArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(162);
        }
        ArrayList<PyExpression> results = new ArrayList<PyExpression>();
        for (PyExpression argument : arguments) {
            if (argument == null || !PyCallExpressionHelper.isVariadicKeywordArgument(argument)) continue;
            results.add(argument);
        }
        ArrayList<PyExpression> arrayList = results;
        if (arrayList == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(163);
        }
        return arrayList;
    }

    public static boolean isVariadicKeywordArgument(@NotNull PyExpression argument) {
        if (argument == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(164);
        }
        return argument instanceof PyStarArgument && ((PyStarArgument)argument).isKeyword();
    }

    public static boolean isVariadicPositionalArgument(@NotNull PyExpression argument) {
        if (argument == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(165);
        }
        return argument instanceof PyStarArgument && !((PyStarArgument)argument).isKeyword();
    }

    @Nullable
    private static <T> T next(@NotNull List<T> list) {
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(166);
        }
        return list.isEmpty() ? null : (T)list.remove(0);
    }

    @NotNull
    private static List<PyCallableParameter> filterExplicitParameters(@NotNull List<PyCallableParameter> parameters, @Nullable PyCallable callable, @NotNull PyCallSiteExpression callSite, @NotNull PyResolveContext resolveContext) {
        PyCallExpression callExpr;
        PyExpression callee;
        if (parameters == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(167);
        }
        if (callSite == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(168);
        }
        if (resolveContext == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(169);
        }
        int implicitOffset = callSite instanceof PyCallExpression ? ((callee = (callExpr = (PyCallExpression)callSite).getCallee()) instanceof PyReferenceExpression && callable instanceof PyFunction ? PyCallExpressionHelper.getImplicitArgumentCount((PyReferenceExpression)callee, (PyFunction)callable, resolveContext) : 0) : 1;
        List<PyCallableParameter> list = parameters.subList(Math.min(implicitOffset, parameters.size()), parameters.size());
        if (list == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(170);
        }
        return list;
    }

    public static boolean canQualifyAnImplicitName(@NotNull PyExpression qualifier) {
        PsiElement target;
        PyExpression callee;
        if (qualifier == null) {
            PyCallExpressionHelper.$$$reportNull$$$0(171);
        }
        return !(qualifier instanceof PyCallExpression) || !((callee = ((PyCallExpression)qualifier).getCallee()) instanceof PyReferenceExpression) || !"super".equals(callee.getName()) || (target = ((PyReferenceExpression)callee).getReference().resolve()) == null || !PyBuiltinCache.getInstance((PsiElement)qualifier).isBuiltin(target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 14, 15, 16, 17, 20, 21, 22, 25, 27, 28, 29, 32, 33, 34, 45, 46, 47, 67, 68, 89, 92, 95, 96, 97, 101, 102, 104, 106, 108, 117, 120, 121, 123, 126, 127, 128, 129, 132, 140, 144, 145, 152, 153, 160, 163, 170 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 19: 
            case 26: 
            case 31: 
            case 40: 
            case 81: 
            case 91: 
            case 94: 
            case 112: 
            case 119: 
            case 125: 
            case 131: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 45: 
            case 46: 
            case 47: 
            case 67: 
            case 68: 
            case 89: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 140: 
            case 144: 
            case 145: 
            case 152: 
            case 153: 
            case 160: 
            case 163: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper";
                break;
            }
            case 5: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscription";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 24: 
            case 37: 
            case 42: 
            case 44: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 62: 
            case 66: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 84: 
            case 88: 
            case 100: 
            case 116: 
            case 135: 
            case 137: 
            case 139: 
            case 143: 
            case 148: 
            case 151: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 35: 
            case 59: 
            case 65: 
            case 70: 
            case 73: 
            case 82: 
            case 85: 
            case 90: 
            case 93: 
            case 98: 
            case 155: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callReference";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiers";
                break;
            }
            case 43: 
            case 48: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 54: 
            case 57: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableTypes";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callables";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initOrNew";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstClass";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 80: 
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 83: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableType";
                break;
            }
            case 86: 
            case 133: 
            case 158: 
            case 159: 
            case 161: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 99: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 111: 
            case 118: 
            case 124: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitlyInvokedMethods";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initAndNew";
                break;
            }
            case 134: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 136: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 141: 
            case 146: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 142: 
            case 147: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper";
                break;
            }
            case 4: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCallee";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitResolveResults";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitResolveResults";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteResolveResults";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCallableTypes";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyResolveResult";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "isQualifiedByInstance";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameScopeCallablesCallTypes";
                break;
            }
            case 89: 
            case 92: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "mapArguments";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCalleeFunction";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsMappedToPositionalContainer";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsMappedToKeywordContainer";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularMappedParameters";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "changeToImplicitlyInvokedMethods";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructors";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "preferInitOverNew";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMetaclassDunderCall";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDunderCall";
                break;
            }
            case 140: 
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "forEveryScopeTakeOverloadsOtherwiseImplementations";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "takeOverloadsOtherwiseImplementations";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "filterKeywordArguments";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVariadicKeywordArguments";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExplicitParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCallee";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 45: 
            case 46: 
            case 47: 
            case 67: 
            case 68: 
            case 89: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 140: 
            case 144: 
            case 145: 
            case 152: 
            case 153: 
            case 160: 
            case 163: 
            case 170: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitResolveResults";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitResolveResults";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteResolveResults";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "selectCallableTypes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "clarifyResolveResult";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toCallableType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitArgumentCount";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isQualifiedByInstance";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isQualifiedByClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "belongsToSpecifiedClassHierarchy";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSameScopeCallablesCallTypes";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverloadsCallType";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "clarifyConstructorCallType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallType";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallTypeForArguments";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassUnionType";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getMappedParameters";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "mapArguments";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCalleeFunction";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsMappedToPositionalContainer";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsMappedToKeywordContainer";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getRegularMappedParameters";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getMappedPositionalContainer";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKeywordContainer";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "resolveImplicitlyInvokedMethods";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "changeToImplicitlyInvokedMethods";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructors";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "preferInitOverNew";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "resolveMetaclassDunderCall";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "resolveDunderCall";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "analyzeArguments";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isParamSpecOrConcatenate";
                break;
            }
            case 138: 
            case 139: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "forEveryScopeTakeOverloadsOtherwiseImplementations";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "containsOverloadsAndImplementations";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "takeOverloadsOtherwiseImplementations";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "matchesByArgumentTypes";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "mapComponentsOfTupleParameter";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "removeKeywordArgument";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "filterKeywordArguments";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "filterPositionalAndVariadicArguments";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "filterVariadicKeywordArguments";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isVariadicKeywordArgument";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "isVariadicPositionalArgument";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "filterExplicitParameters";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "canQualifyAnImplicitName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 14, 15, 16, 17, 20, 21, 22, 25, 27, 28, 29, 32, 33, 34, 45, 46, 47, 67, 68, 89, 92, 95, 96, 97, 101, 102, 104, 106, 108, 117, 120, 121, 123, 126, 127, 128, 129, 132, 140, 144, 145, 152, 153, 160, 163, 170 -> new IllegalStateException(string);
        };
    }

    private static class ClarifiedResolveResult {
        @NotNull
        private final QualifiedRatedResolveResult myOriginalResolveResult;
        @NotNull
        private final PsiElement myClarifiedResolved;
        @Nullable
        private final PyAstFunction.Modifier myWrappedModifier;
        private final boolean myIsConstructor;

        ClarifiedResolveResult(@NotNull QualifiedRatedResolveResult originalResolveResult, @NotNull PsiElement clarifiedResolved, @Nullable PyAstFunction.Modifier wrappedModifier, boolean isConstructor) {
            if (originalResolveResult == null) {
                ClarifiedResolveResult.$$$reportNull$$$0(0);
            }
            if (clarifiedResolved == null) {
                ClarifiedResolveResult.$$$reportNull$$$0(1);
            }
            this.myOriginalResolveResult = originalResolveResult;
            this.myClarifiedResolved = clarifiedResolved;
            this.myWrappedModifier = wrappedModifier;
            this.myIsConstructor = isConstructor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clarifiedResolved";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ClarifiedResolveResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ArgumentMappingResults {
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedContainerParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicPositionalArguments;
        @NotNull
        private final List<PyCallableParameter> myParametersMappedToVariadicKeywordArguments;
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myMappedTupleParameters;

        ArgumentMappingResults(@NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyCallableParameter> unmappedContainerParameters, @NotNull List<PyExpression> unmappedArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicPositionalArguments, @NotNull List<PyCallableParameter> parametersMappedToVariadicKeywordArguments, @NotNull Map<PyExpression, PyCallableParameter> mappedTupleParameters) {
            if (mappedParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(0);
            }
            if (unmappedParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(1);
            }
            if (unmappedContainerParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(2);
            }
            if (unmappedArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(3);
            }
            if (parametersMappedToVariadicPositionalArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(4);
            }
            if (parametersMappedToVariadicKeywordArguments == null) {
                ArgumentMappingResults.$$$reportNull$$$0(5);
            }
            if (mappedTupleParameters == null) {
                ArgumentMappingResults.$$$reportNull$$$0(6);
            }
            this.myMappedParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedContainerParameters = unmappedContainerParameters;
            this.myUnmappedArguments = unmappedArguments;
            this.myParametersMappedToVariadicPositionalArguments = parametersMappedToVariadicPositionalArguments;
            this.myParametersMappedToVariadicKeywordArguments = parametersMappedToVariadicKeywordArguments;
            this.myMappedTupleParameters = mappedTupleParameters;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedParameters;
            if (map2 == null) {
                ArgumentMappingResults.$$$reportNull$$$0(7);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list = this.myUnmappedParameters;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list = this.myUnmappedArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicPositionalArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicPositionalArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(10);
            }
            return list;
        }

        @NotNull
        public List<PyCallableParameter> getParametersMappedToVariadicKeywordArguments() {
            List<PyCallableParameter> list = this.myParametersMappedToVariadicKeywordArguments;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getMappedTupleParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myMappedTupleParameters;
            if (map2 == null) {
                ArgumentMappingResults.$$$reportNull$$$0(12);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedContainerParameters() {
            List<PyCallableParameter> list = this.myUnmappedContainerParameters;
            if (list == null) {
                ArgumentMappingResults.$$$reportNull$$$0(13);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedContainerParameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedTupleParameters";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ArgumentMappingResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$ArgumentMappingResults";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedParameters";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicPositionalArguments";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersMappedToVariadicKeywordArguments";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedTupleParameters";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedContainerParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }

    private static class PositionalArgumentsAnalysisResults {
        @NotNull
        private final List<PyExpression> allPositionalArguments;
        @NotNull
        private final List<PyExpression> componentsOfVariadicPositionalArguments;
        @NotNull
        private final List<PyExpression> variadicPositionalArguments;

        PositionalArgumentsAnalysisResults(@NotNull List<PyExpression> allPositionalArguments, @NotNull List<PyExpression> componentsOfVariadicPositionalArguments, @NotNull List<PyExpression> variadicPositionalArguments) {
            if (allPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(0);
            }
            if (componentsOfVariadicPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(1);
            }
            if (variadicPositionalArguments == null) {
                PositionalArgumentsAnalysisResults.$$$reportNull$$$0(2);
            }
            this.allPositionalArguments = allPositionalArguments;
            this.componentsOfVariadicPositionalArguments = componentsOfVariadicPositionalArguments;
            this.variadicPositionalArguments = variadicPositionalArguments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allPositionalArguments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentsOfVariadicPositionalArguments";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variadicPositionalArguments";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$PositionalArgumentsAnalysisResults";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TupleMappingResults {
        @NotNull
        private final Map<PyExpression, PyCallableParameter> myParameters;
        @NotNull
        private final List<PyCallableParameter> myUnmappedParameters;
        @NotNull
        private final List<PyExpression> myUnmappedArguments;

        TupleMappingResults(@NotNull Map<PyExpression, PyCallableParameter> mappedParameters, @NotNull List<PyCallableParameter> unmappedParameters, @NotNull List<PyExpression> unmappedArguments) {
            if (mappedParameters == null) {
                TupleMappingResults.$$$reportNull$$$0(0);
            }
            if (unmappedParameters == null) {
                TupleMappingResults.$$$reportNull$$$0(1);
            }
            if (unmappedArguments == null) {
                TupleMappingResults.$$$reportNull$$$0(2);
            }
            this.myParameters = mappedParameters;
            this.myUnmappedParameters = unmappedParameters;
            this.myUnmappedArguments = unmappedArguments;
        }

        @NotNull
        public Map<PyExpression, PyCallableParameter> getParameters() {
            Map<PyExpression, PyCallableParameter> map2 = this.myParameters;
            if (map2 == null) {
                TupleMappingResults.$$$reportNull$$$0(3);
            }
            return map2;
        }

        @NotNull
        public List<PyCallableParameter> getUnmappedParameters() {
            List<PyCallableParameter> list = this.myUnmappedParameters;
            if (list == null) {
                TupleMappingResults.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public List<PyExpression> getUnmappedArguments() {
            List<PyExpression> list = this.myUnmappedArguments;
            if (list == null) {
                TupleMappingResults.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$TupleMappingResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyCallExpressionHelper$TupleMappingResults";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

