/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class VersionRangeResolutionException
extends RepositoryException {
    private final transient VersionRangeResult result;

    public VersionRangeResolutionException(VersionRangeResult result2) {
        super(VersionRangeResolutionException.getMessage(result2), VersionRangeResolutionException.getCause(result2));
        this.result = result2;
    }

    private static String getMessage(VersionRangeResult result2) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("Failed to resolve version range");
        if (result2 != null) {
            buffer.append(" for ").append(result2.getRequest().getArtifact());
            if (!result2.getExceptions().isEmpty()) {
                buffer.append(": ").append(result2.getExceptions().iterator().next().getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(VersionRangeResult result2) {
        Throwable cause = null;
        if (result2 != null && !result2.getExceptions().isEmpty()) {
            cause = result2.getExceptions().get(0);
        }
        return cause;
    }

    public VersionRangeResolutionException(VersionRangeResult result2, String message) {
        super(message);
        this.result = result2;
    }

    public VersionRangeResolutionException(VersionRangeResult result2, String message, Throwable cause) {
        super(message, cause);
        this.result = result2;
    }

    public VersionRangeResult getResult() {
        return this.result;
    }
}

