/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.db2.Db2DateTimeLanguageHelper;
import com.intellij.sql.dialects.db2.Db2ElementTypes;
import com.intellij.sql.dialects.db2.Db2LUWDialect;
import com.intellij.sql.dialects.db2.Db2OptionalKeywords;
import com.intellij.sql.dialects.db2.Db2Tokens;
import com.intellij.sql.dialects.db2.Db2Types;
import com.intellij.sql.dialects.db2.refactoring.Db2ExtractFunctionHelper;
import com.intellij.sql.dialects.db2.refactoring.Db2ExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.virtual.DasVirtualSymbol;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2DialectBase
extends SqlLanguageDialectBase {
    private final NotNullLazyValue<ReservedEntity> myPrevValColumn = NotNullLazyValue.atomicLazy(() -> new ReservedEntity(this.getDbms(), "prevval", ObjectKind.COLUMN));

    protected Db2DialectBase(String id) {
        super(id);
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(Db2Tokens.class);
        if (tokensHelper == null) {
            Db2DialectBase.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(2);
        }
        if (symbol instanceof DasVirtualSymbol && type == ObjectKind.OBJECT_TYPE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Db2DialectBase.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            Db2DialectBase.$$$reportNull$$$0(4);
        }
        if (super.isTableAliasAllowedAt(element)) {
            return true;
        }
        if (PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null) {
            return true;
        }
        SqlOnTargetClauseImpl onTargetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlOnTargetClauseImpl.class});
        SqlCreateStatement definition = (SqlCreateStatement)PsiTreeUtil.getContextOfType((PsiElement)onTargetClause, (Class[])new Class[]{SqlCreateStatement.class});
        ObjectKind kind = definition != null ? definition.getKind() : ObjectKind.NONE;
        return kind == Db2ElementTypes.Kinds.MASK || kind == Db2ElementTypes.Kinds.PERMISSION;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            Db2DialectBase.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            Db2DialectBase.$$$reportNull$$$0(6);
        }
        ReservedEntity prevValColumn = (ReservedEntity)this.myPrevValColumn.getValue();
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, prevValColumn.name, resolve2) && SqlImplUtil.getQualifierKind(place) == ObjectKind.SEQUENCE && !processor2.executeTarget((DasSymbol)prevValColumn, this.getTypeSystem().getIntType(), Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.ROUTINE || type == ObjectKind.METHOD) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    private static boolean isMethodReference(PsiElement element) {
        if (!(element instanceof SqlReferenceExpression)) {
            return false;
        }
        for (PsiElement child : element.getChildren()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != Db2Types.DB2_DOUBLE_DOT) continue;
            return true;
        }
        return false;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        DasObject dasObject;
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(7);
        }
        DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
        if (type == ObjectKind.ROUTINE && dasObject instanceof DasRoutine && dasObject.getDasParent() instanceof DasUserDefinedType && !Db2DialectBase.isMethodReference(place)) {
            return true;
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new Db2ExtractVariableHelper(this);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return Db2ExtractFunctionHelper.INSTANCE;
    }

    @Override
    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        Db2DateTimeLanguageHelper db2DateTimeLanguageHelper = Db2DateTimeLanguageHelper.INSTANCE;
        if (db2DateTimeLanguageHelper == null) {
            Db2DialectBase.$$$reportNull$$$0(8);
        }
        return db2DateTimeLanguageHelper;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_FOR, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_ATOMIC, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATIC, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATEMENTS, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_WHILE, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Db2DialectBase INSTANCE = Db2LUWDialect.INSTANCE;
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, Db2OptionalKeywords.DB2_CONCAT, SqlElementTypes.SQL_LEFT_BRACKET);
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX, Db2ElementTypes.Kinds.MASK, Db2ElementTypes.Kinds.PERMISSION);

        LazyData() {
        }
    }
}

