/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasCasingAware;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAltNamesProvider;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public final String sourceText;
    public final boolean sourcePlain;
    @Nullable
    public final SqlLanguageDialect dialect;
    public final CasingProvider casingProvider;
    public final String[] actualCache;

    public NameChecker(@NotNull String name2, boolean quoted, @NotNull CasingProvider provider, @Nullable SqlLanguageDialect dialect) {
        if (name2 == null) {
            NameChecker.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            NameChecker.$$$reportNull$$$0(1);
        }
        this.actualCache = new String[2];
        this.dialect = dialect;
        this.sourcePlain = !quoted;
        this.sourceText = name2;
        this.casingProvider = provider;
    }

    public NameChecker(@NotNull DasObject object, @NotNull SqlLanguageDialect dialect) {
        if (object == null) {
            NameChecker.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(3);
        }
        this(object.getName(), DbSqlUtilCore.isQuoted(object), (CasingProvider)dialect, dialect);
    }

    public NameChecker(@NotNull SqlReferenceExpression ref2, @NotNull SqlLanguageDialect dialect, CasingProvider provider) {
        if (ref2 == null) {
            NameChecker.$$$reportNull$$$0(4);
        }
        if (dialect == null) {
            NameChecker.$$$reportNull$$$0(5);
        }
        this(ref2.getName(), DbSqlUtilCore.isQuoted((SqlNameElement)ref2), provider, dialect);
    }

    public boolean checkName(@Nullable DasNamed named, @Nullable Boolean forcedCaseSens) {
        boolean caseSensitive;
        if (named == null) {
            return false;
        }
        String name2 = named.getName();
        if (this.dialect != null && this.dialect.getDbms().in(Dbms.DOCUMENT_ORIENTED) && named.getKind() == ObjectKind.COLUMN) {
            int pos = name2.lastIndexOf(46);
            String string = name2 = pos == -1 ? name2 : name2.substring(pos + 1);
        }
        if (!NameChecker.compareNames(name2, this.sourceText, false) && (name2 = this.getAltName(named)) == null) {
            return false;
        }
        boolean isBuiltInFunction = named instanceof BuiltinFunction;
        if (this.dialect != null) {
            Dbms dbms = this.dialect.getDbms();
            if (isBuiltInFunction && dbms.isSybase()) {
                return true;
            }
            if (isBuiltInFunction && dbms.isTransactSql() && ((BuiltinFunction)named).getPostfixType() == null) {
                return this.sourcePlain;
            }
        }
        boolean targetIsPlain = !named.isQuoted();
        Casing inPlaceCasing = NameChecker.getCasing(named, this.casingProvider);
        Case targetCase = inPlaceCasing.choose(targetIsPlain);
        Case sourceCase = inPlaceCasing.choose(this.sourcePlain);
        String targetActual = NameChecker.getActualName(named, name2, targetIsPlain, this.casingProvider);
        if (forcedCaseSens != null) {
            return this.compareWithSource(targetActual, sourceCase, forcedCaseSens == Boolean.TRUE);
        }
        if (isBuiltInFunction) {
            return this.compareWithSource(targetActual, sourceCase, sourceCase == Case.EXACT && !this.sourcePlain);
        }
        boolean targetCaseSensitive = targetCase != Case.MIXED;
        boolean sourceCaseSensitive = sourceCase != Case.MIXED;
        boolean bl = caseSensitive = sourceCaseSensitive && targetCaseSensitive;
        return this.compareWithSource(targetActual, sourceCase, caseSensitive);
    }

    @Nullable
    protected String getAltName(@NotNull DasNamed named) {
        SqlAltNamesProvider altNames;
        if (named == null) {
            NameChecker.$$$reportNull$$$0(6);
        }
        if ((altNames = (SqlAltNamesProvider)ObjectUtils.tryCast((Object)named, SqlAltNamesProvider.class)) == null) {
            return null;
        }
        for (String text2 : altNames.getAltNames()) {
            if (!NameChecker.compareNames(text2, this.sourceText, false)) continue;
            return text2;
        }
        return null;
    }

    @NotNull
    private static Casing getCasing(@NotNull DasNamed named, CasingProvider casingProvider) {
        if (named == null) {
            NameChecker.$$$reportNull$$$0(7);
        }
        if (named instanceof DasCasingAware) {
            Casing casing = ((DasCasingAware)((Object)named)).getCustomCasing(casingProvider);
            if (casing == null) {
                NameChecker.$$$reportNull$$$0(8);
            }
            return casing;
        }
        Casing casing = casingProvider.getCasing(named.getKind(), DbSqlUtilCore.getDasObject(named));
        if (casing == null) {
            NameChecker.$$$reportNull$$$0(9);
        }
        return casing;
    }

    private boolean compareWithSource(String targetActual, Case sourceCase, boolean caseSensitive) {
        String sourceActual = caseSensitive ? this.getSourceActual(sourceCase) : this.sourceText;
        return NameChecker.compareNames(targetActual, sourceActual, caseSensitive);
    }

    private static boolean compareNames(String targetActual, String sourceActual, boolean caseSensitive) {
        return Comparing.strEqual((String)targetActual, (String)sourceActual, (boolean)caseSensitive);
    }

    private String getSourceActual(Case sourceCase) {
        if (sourceCase == Case.EXACT || sourceCase == Case.MIXED) {
            return this.sourceText;
        }
        int i2 = sourceCase == Case.LOWER ? 0 : 1;
        return this.actualCache[i2] == null ? sourceCase.apply(this.sourceText) : this.actualCache[i2];
    }

    @Nullable
    private static String getActualName(DasNamed named, @Nullable String name2, boolean isPlain, @NotNull CasingProvider casingProvider) {
        if (casingProvider == null) {
            NameChecker.$$$reportNull$$$0(10);
        }
        if (name2 == null || DasUtil.isNoName(name2)) {
            return null;
        }
        ObjectKind kind = named.getKind();
        if (kind == ObjectKind.SCHEMA && StringUtil.isEmpty((String)name2) && named instanceof DbElement) {
            return QNameUtil.getQualifiedName((DbElement)named);
        }
        Casing casing = NameChecker.getCasing(named, casingProvider);
        return casing.choose(isPlain).apply(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/NameChecker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAltName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActualName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

