/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.serialization.FixHierarchicalStreamWriter;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelExporter;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.util.TreePattern;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0012"}, d2={"serialize", "", "model", "Lcom/intellij/database/model/DasModel;", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "scope", "Lcom/intellij/database/util/TreePattern;", "deserialize", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "dataSourceName", "", "exporter", "Lcom/intellij/database/model/serialization/ModelExporter;", "intellij.database.core.impl"})
public final class ModelSerializerKt {
    public static final void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer, @Nullable TreePattern scope2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ModelSerializerKt.serialize(model, writer, new ModelExporter(), scope2);
    }

    @NotNull
    public static final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory, @Nullable String dataSourceName) throws ImportException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BasicModModel basicModModel = new ModelImporter(modelFactory).deserialize(reader, dataSourceName);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"deserialize(...)");
        return basicModModel;
    }

    public static /* synthetic */ BasicModModel deserialize$default(HierarchicalStreamReader hierarchicalStreamReader, ModelFactory modelFactory, String string, int n, Object object) throws ImportException {
        if ((n & 4) != 0) {
            string = null;
        }
        return ModelSerializerKt.deserialize(hierarchicalStreamReader, modelFactory, string);
    }

    private static final void serialize(DasModel model, HierarchicalStreamWriter writer, ModelExporter exporter, TreePattern scope2) {
        if (!(model instanceof BasicModel)) {
            throw new IllegalArgumentException("Unknown how to export model class " + model.getClass().getSimpleName());
        }
        exporter.saveModel((BasicModel)model, new FixHierarchicalStreamWriter(writer), scope2);
    }
}

