/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlLineBreakpointType;
import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointProperties;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.oracle.psi.OraCreateTriggerStatementImpl;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u00020\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J(\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J!\u0010\u001f\u001a\u00020\u0012*\u00020\u001d2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cH\u0082\u0004\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointType;", "Lcom/intellij/database/debugger/SqlLineBreakpointType;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "<init>", "()V", "createBreakpointProperties", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "canPutAt", "", "checkPositionInScript", "document", "Lcom/intellij/openapi/editor/Document;", "checkPositionInsideRoutine", "start", "end", "checkPositionInsideBody", "checkPositionInsidePsiElement", "elementPredicate", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "checkPositionInsideTrigger", "isInside", "Companion", "intellij.database.dialects.oracle.ex"})
public final class OraLineBreakpointType
extends SqlLineBreakpointType<OraLineBreakpointProperties> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    public static final String BREAKPOINT_TYPE_ID = "OracleBreakpointType";

    public OraLineBreakpointType() {
        super(BREAKPOINT_TYPE_ID, DatabaseBundle.message("oracle.debugger.line.breakpoint.type.name", new Object[0]));
    }

    @NotNull
    public OraLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new OraLineBreakpointProperties();
    }

    @Override
    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        int end;
        DbElement dbElement;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SqlDebugFunKt.sqlDebuggerIsEnabled()) {
            return false;
        }
        Object modelElement = DbImplUtilCore.findElement(project, file);
        if (modelElement instanceof DbElement) {
            modelElement = modelElement.getDelegate();
        }
        OraSourceAware sa = (dbElement = modelElement) instanceof OraSourceAware ? (OraSourceAware)((Object)dbElement) : null;
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        int start2 = document2.getLineStartOffset(line);
        if (start2 == (end = document2.getLineEndOffset(line))) {
            return false;
        }
        OraSourceAware oraSourceAware = sa;
        return oraSourceAware == null ? this.checkPositionInScript(project, document2, line) : (oraSourceAware instanceof OraRoutine ? this.checkPositionInsideRoutine(project, file, start2, end) : (oraSourceAware instanceof OraBody ? this.checkPositionInsideBody(project, document2, line) : (oraSourceAware instanceof OraTrigger ? this.checkPositionInsideTrigger(project, file, start2, end) : false)));
    }

    private final boolean checkPositionInScript(Project project, Document document, int line) {
        return this.checkPositionInsidePsiElement(project, document, line, (Function1<? super PsiElement, Boolean>)((Function1)OraLineBreakpointType::checkPositionInScript$lambda$0));
    }

    private final boolean checkPositionInsideRoutine(Project project, VirtualFile file, int start2, int end) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        PsiFile root = psiFile;
        SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)root), SqlRoutineDefinition.class);
        if (sqlRoutineDefinition == null) {
            return false;
        }
        SqlRoutineDefinition routineDefinition = sqlRoutineDefinition;
        return routineDefinition.getTextRange().intersects(start2, end);
    }

    private final boolean checkPositionInsideBody(Project project, Document document, int line) {
        return this.checkPositionInsidePsiElement(project, document, line, (Function1<? super PsiElement, Boolean>)((Function1)OraLineBreakpointType::checkPositionInsideBody$lambda$1));
    }

    private final boolean checkPositionInsidePsiElement(Project project, Document document, int line, Function1<? super PsiElement, Boolean> elementPredicate) {
        Ref.BooleanRef ok2 = new Ref.BooleanRef();
        XDebuggerUtil.getInstance().iterateLine(project, document, line, arg_0 -> OraLineBreakpointType.checkPositionInsidePsiElement$lambda$3(arg_0 -> OraLineBreakpointType.checkPositionInsidePsiElement$lambda$2(this, elementPredicate, ok2, arg_0), arg_0));
        return ok2.element;
    }

    private final boolean checkPositionInsideTrigger(Project project, VirtualFile file, int start2, int end) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        PsiFile root = psiFile;
        OraCreateTriggerStatementImpl oraCreateTriggerStatementImpl = (OraCreateTriggerStatementImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)root), OraCreateTriggerStatementImpl.class);
        if (oraCreateTriggerStatementImpl == null) {
            return false;
        }
        OraCreateTriggerStatementImpl routineDefinition = oraCreateTriggerStatementImpl;
        return routineDefinition.getTextRange().intersects(start2, end);
    }

    private final boolean isInside(PsiElement $this$isInside, Function1<? super PsiElement, Boolean> elementPredicate) {
        return SyntaxTraverser.psiApi().parents((Object)$this$isInside).find(arg_0 -> OraLineBreakpointType.isInside$lambda$4(elementPredicate, arg_0)) != null;
    }

    private static final boolean checkPositionInScript$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof SqlBlockStatement;
    }

    private static final boolean checkPositionInsideBody$lambda$1(PsiElement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return o instanceof DasRoutine || o instanceof DasTrigger;
    }

    private static final boolean checkPositionInsidePsiElement$lambda$2(OraLineBreakpointType this$0, Function1 $elementPredicate, Ref.BooleanRef $ok, PsiElement element) {
        boolean result2;
        PsiElement st = PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class, (boolean)false);
        $ok.element = result2 = st != null && this$0.isInside(st, (Function1<? super PsiElement, Boolean>)$elementPredicate);
        return !result2;
    }

    private static final boolean checkPositionInsidePsiElement$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isInside$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointType$Companion;", "", "<init>", "()V", "BREAKPOINT_TYPE_ID", "", "intellij.database.dialects.oracle.ex"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

