/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSrcChangesTracker
implements Disposable {
    protected final EventDispatcher<ModificationTrackerListener<DbSrcChangesTracker>> myDispatcher = DataSourceUtil.eventDispatcher(ModificationTrackerListener.class);
    protected final Project myProject;

    @NotNull
    public static DbSrcChangesTracker getInstance(@Nullable Project project) {
        DbSrcChangesTracker dbSrcChangesTracker = project == null ? (DbSrcChangesTracker)ApplicationManager.getApplication().getService(DbSrcChangesTracker.class) : (DbSrcChangesTracker)project.getService(DbSrcChangesTracker.class);
        if (dbSrcChangesTracker == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(0);
        }
        return dbSrcChangesTracker;
    }

    public DbSrcChangesTracker(@Nullable Project project) {
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public abstract DbSrcFileStatus getFileStatus();

    public void rescanDbSrcIndex(@NotNull Project project, @NotNull String reason) {
        if (project == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(1);
        }
        if (reason == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(2);
        }
    }

    public boolean isDisposed() {
        return this.myProject != null ? this.myProject.isDisposed() : ApplicationManager.getApplication().isDisposed();
    }

    public void addListener(@NotNull ModificationTrackerListener<DbSrcChangesTracker> listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener(listener2, parent);
    }

    protected void invokeLater(@NotNull Runnable r) {
        if (r == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(5);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(r, this.myProject == null ? app.getDisposed() : this.myProject.getDisposed());
    }

    public abstract void distributeUpdates(List<VirtualFile> var1);

    public static void flushAndUpdateFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            FileDocumentManager docManager = FileDocumentManager.getInstance();
            for (VirtualFile file : files2) {
                Document document = docManager.getDocument(file);
                if (document != null) {
                    docManager.saveDocument(document);
                }
                DbSrcFileSystem.getInstance().getBaseFile(file, false, true);
            }
        });
        ((DbSrcChangesTracker)ApplicationManager.getApplication().getService(DbSrcChangesTracker.class)).distributeUpdates(files2);
    }

    public static DbSrcFileStatus getFileStatuses() {
        return DbSrcChangesTracker.getInstance(null).getFileStatus();
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rescanDbSrcIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flushAndUpdateFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

