/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u001f\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getPosition", "Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$Position;", "useCaretPositon", "", "restorePosition", "", "position", "keepScrollingPositionWhile", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOffsetProvider", "Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$OffsetProvider;", "OffsetProvider", "Position", "intellij.notebooks.visualization"})
public final class NotebookPositionKeeper {
    @NotNull
    private final EditorImpl editor;

    public NotebookPositionKeeper(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final Position getPosition(boolean useCaretPositon) {
        int n;
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleAreaOnScrollingFinished(...)");
        Rectangle visibleArea = rectangle;
        if (useCaretPositon) {
            int caretY = this.editor.visualLineToY(this.editor.getCaretModel().getVisualPosition().line);
            n = visibleArea.height > 0 && (caretY + this.editor.getLineHeight() <= visibleArea.y || caretY >= visibleArea.y + visibleArea.height) ? this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(visibleArea.getLocation())) : this.editor.getCaretModel().getOffset();
        } else {
            n = this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(visibleArea.getLocation()));
        }
        int topLeftCornerOffset = n;
        int viewportShift = this.editor.offsetToXY((int)topLeftCornerOffset).y - visibleArea.y;
        Position position = new Position(topLeftCornerOffset, viewportShift);
        return position;
    }

    public static /* synthetic */ Position getPosition$default(NotebookPositionKeeper notebookPositionKeeper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return notebookPositionKeeper.getPosition(bl);
    }

    public final void restorePosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int topLeftCornerOffset = position.component1();
        int viewportShift = position.component2();
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        scrollingModel.disableAnimation();
        int newY = this.editor.offsetToXY((int)topLeftCornerOffset).y - viewportShift;
        scrollingModel.scrollVertically(newY);
        scrollingModel.enableAnimation();
    }

    public final <T> T keepScrollingPositionWhile(@NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return (T)WriteIntentReadAction.compute(() -> NotebookPositionKeeper.keepScrollingPositionWhile$lambda$1(this, task));
    }

    private final OffsetProvider getOffsetProvider(Position position) {
        return this.editor.getCaretModel().getOffset() == position.getTopLeftCornerOffset() ? (OffsetProvider)new OffsetProvider(this){
            final /* synthetic */ NotebookPositionKeeper this$0;
            {
                this.this$0 = $receiver;
            }

            public int getOffset() {
                return this.this$0.getEditor().getCaretModel().getOffset();
            }

            public void close() {
            }
        } : (OffsetProvider)new OffsetProvider(this, position){
            private final RangeMarker myTopLeftCornerMarker;
            {
                RangeMarker rangeMarker = $receiver.getEditor().getDocument().createRangeMarker($position.getTopLeftCornerOffset(), $position.getTopLeftCornerOffset());
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                this.myTopLeftCornerMarker = rangeMarker;
            }

            public final RangeMarker getMyTopLeftCornerMarker() {
                return this.myTopLeftCornerMarker;
            }

            public int getOffset() {
                return this.myTopLeftCornerMarker.getStartOffset();
            }

            public void close() {
                this.myTopLeftCornerMarker.dispose();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object keepScrollingPositionWhile$lambda$1(NotebookPositionKeeper this$0, Function0 $task) {
        Pair pair;
        if (this$0.editor.isDisposed()) {
            return $task.invoke();
        }
        Position position = this$0.getPosition(false);
        AutoCloseable autoCloseable = this$0.getOffsetProvider(position);
        Throwable throwable = null;
        try {
            OffsetProvider offsetProvider = (OffsetProvider)autoCloseable;
            boolean bl = false;
            pair = TuplesKt.to((Object)$task.invoke(), (Object)offsetProvider.getOffset());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Pair pair2 = pair;
        Object r = pair2.component1();
        int newOffset = ((Number)pair2.component2()).intValue();
        this$0.restorePosition(new Position(newOffset, position.getViewportShift()));
        return r;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00060\u0001j\u0002`\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$OffsetProvider;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "getOffset", "", "intellij.notebooks.visualization"})
    private static interface OffsetProvider
    extends AutoCloseable {
        public int getOffset();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookPositionKeeper$Position;", "", "topLeftCornerOffset", "", "viewportShift", "<init>", "(II)V", "getTopLeftCornerOffset", "()I", "getViewportShift", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.notebooks.visualization"})
    public static final class Position {
        private final int topLeftCornerOffset;
        private final int viewportShift;

        public Position(int topLeftCornerOffset, int viewportShift) {
            this.topLeftCornerOffset = topLeftCornerOffset;
            this.viewportShift = viewportShift;
        }

        public final int getTopLeftCornerOffset() {
            return this.topLeftCornerOffset;
        }

        public final int getViewportShift() {
            return this.viewportShift;
        }

        public final int component1() {
            return this.topLeftCornerOffset;
        }

        public final int component2() {
            return this.viewportShift;
        }

        @NotNull
        public final Position copy(int topLeftCornerOffset, int viewportShift) {
            return new Position(topLeftCornerOffset, viewportShift);
        }

        public static /* synthetic */ Position copy$default(Position position, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = position.topLeftCornerOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = position.viewportShift;
            }
            return position.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Position(topLeftCornerOffset=" + this.topLeftCornerOffset + ", viewportShift=" + this.viewportShift + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.topLeftCornerOffset);
            result = result * 31 + Integer.hashCode(this.viewportShift);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            Position position = (Position)other;
            if (this.topLeftCornerOffset != position.topLeftCornerOffset) {
                return false;
            }
            return this.viewportShift == position.viewportShift;
        }
    }
}

