/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public abstract class AbstractRepeatedWordsRule
extends TextLevelRule {
    private static final Pattern PUNCT_PATTERN = Pattern.compile("\\p{P}");
    private static final Pattern HASH_PATTERN = Pattern.compile("#.*");
    private static final String FILE_ENCODING = "utf-8";
    private final String ruleId;
    protected final Language language;

    protected abstract Map<String, SynonymsData> getWordsToCheck();

    protected abstract Synthesizer getSynthesizer();

    @Override
    public int minToCheckParagraph() {
        return 1;
    }

    protected int maxWordsDistance() {
        return 150;
    }

    protected abstract String getMessage();

    protected abstract String getShortMessage();

    @Override
    public String getId() {
        return this.ruleId;
    }

    @Override
    public abstract String getDescription();

    public AbstractRepeatedWordsRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.REPETITIONS_STYLE.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Style);
        this.ruleId = language.getShortCode().toUpperCase() + "_REPEATEDWORDS";
        this.language = language;
    }

    protected String adjustPostag(String postag) {
        return postag;
    }

    protected abstract boolean isException(AnalyzedTokenReadings[] var1, int var2, boolean var3, boolean var4, boolean var5);

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences2) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int wordNumber = 0;
        HashMap<String, Integer> wordsLastSeen = new HashMap<String, Integer>();
        int pos = 0;
        int prevSentenceLength = 0;
        for (AnalyzedSentence sentence : sentences2) {
            AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
            pos += prevSentenceLength;
            prevSentenceLength = sentence.getText().length();
            String lastToken = tokens[tokens.length - 1].getToken();
            if (!lastToken.equals(".") && !lastToken.equals("!") && !lastToken.equals("?")) continue;
            boolean sentStart = true;
            ArrayList<String> lemmasInSentece = new ArrayList<String>();
            int i = -1;
            for (AnalyzedTokenReadings atrs : tokens) {
                boolean isException;
                if (atrs.isImmunized()) continue;
                String token = atrs.getToken();
                if (!token.isEmpty()) {
                    ++wordNumber;
                }
                boolean isCapitalized = StringTools.isCapitalizedWord(token);
                boolean isAllUppercase = StringTools.isAllUppercase(token);
                boolean bl = isException = token.isEmpty() || this.isException(tokens, ++i, sentStart, isCapitalized, isAllUppercase);
                if (sentStart && !token.isEmpty() && !PUNCT_PATTERN.matcher(token).matches()) {
                    sentStart = false;
                }
                if (isException) continue;
                ArrayList<String> lemmas = new ArrayList<String>();
                for (AnalyzedToken atr : atrs) {
                    String chunk;
                    String lemma = atr.getLemma();
                    lemmas.add(lemma);
                    Integer seenInWordPosition = (Integer)wordsLastSeen.get(lemma);
                    if (seenInWordPosition == null || lemmasInSentece.contains(lemma) || wordNumber - seenInWordPosition > this.maxWordsDistance()) continue;
                    boolean createMatch = true;
                    String postag = this.getWordsToCheck().get(lemma).getPostag();
                    if (postag != null && !atr.getPOSTag().matches(postag)) {
                        createMatch = false;
                    }
                    if ((chunk = this.getWordsToCheck().get(lemma).getChunk()) != null && !atrs.matchesChunkRegex(chunk)) {
                        createMatch = false;
                    }
                    if (!createMatch) continue;
                    RuleMatch rulematch = new RuleMatch(this, sentence, pos + atrs.getStartPos(), pos + atrs.getEndPos(), this.getMessage(), this.getShortMessage());
                    rulematch.setSpecificRuleId(this.ruleId + "_" + StringTools.toId(lemma, this.language));
                    List<String> replacementLemmas = this.getWordsToCheck().get(lemma).getSynonyms();
                    for (String replacementLemma : replacementLemmas) {
                        String[] replacements = this.getSynthesizer().synthesize(new AnalyzedToken(token, atr.getPOSTag(), replacementLemma), this.adjustPostag(atr.getPOSTag()), true);
                        if (replacements.length == 0) {
                            replacements = new String[]{replacementLemma};
                        }
                        for (String r : replacements) {
                            if (isAllUppercase) {
                                r = r.toUpperCase();
                            } else if (isCapitalized) {
                                r = StringTools.uppercaseFirstChar(r);
                            }
                            rulematch.addSuggestedReplacement(r);
                        }
                    }
                    matches.add(rulematch);
                    break;
                }
                for (String lemma : lemmas) {
                    if (!this.getWordsToCheck().containsKey(lemma)) continue;
                    wordsLastSeen.put(lemma, wordNumber);
                    lemmasInSentece.add(lemma);
                }
            }
        }
        return this.toRuleMatchArray(matches);
    }

    protected static Map<String, SynonymsData> loadWords(String path) {
        InputStream inputStream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        HashMap<String, SynonymsData> map = new HashMap<String, SynonymsData>();
        try (Scanner scanner = new Scanner(inputStream, FILE_ENCODING);){
            while (scanner.hasNextLine()) {
                String word;
                String line = HASH_PATTERN.matcher(scanner.nextLine()).replaceFirst("").trim();
                if (line.isEmpty()) continue;
                String[] mainParts = line.split("=");
                String[] parts = null;
                String postag = null;
                String chunk = null;
                if (mainParts.length == 2) {
                    parts = mainParts[1].split(";");
                    word = mainParts[0];
                    String[] wordPosChunk = word.split("/");
                    word = wordPosChunk[0];
                    if (wordPosChunk.length > 1) {
                        postag = wordPosChunk[1];
                    }
                    if (wordPosChunk.length > 2) {
                        chunk = wordPosChunk[2];
                    }
                } else if (mainParts.length == 1) {
                    parts = line.split(";");
                    word = "";
                } else {
                    throw new RuntimeException("Format error in file " + path + ", line: " + line);
                }
                if (word.isEmpty() && parts.length < 2 || !word.isEmpty() && parts.length < 1) {
                    throw new RuntimeException("Format error in file " + path + ", line: " + line);
                }
                if (!word.isEmpty()) {
                    if (!map.containsKey(word)) {
                        SynonymsData synonymsData = new SynonymsData(Arrays.asList(parts), postag, chunk);
                        map.put(word, synonymsData);
                        continue;
                    }
                    throw new RuntimeException("Word found in more than one line. \"" + word + "\" in line: " + line);
                }
                for (String key2 : parts) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String value : parts) {
                        if (value.equals(key2)) continue;
                        values.add(value);
                    }
                    if (map.containsKey(key2)) {
                        throw new RuntimeException("Word found in more than one line. \"" + key2 + "\" in line: " + line);
                    }
                    SynonymsData synonymsData = new SynonymsData(values, postag, chunk);
                    map.put(key2, synonymsData);
                }
            }
        }
        return map;
    }
}

