/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.ide.startup.importSettings.jb.JbImportSpecialHandlersKt;
import com.intellij.ide.startup.importSettings.jb.JbImportXmlHandler;
import com.intellij.ide.startup.importSettings.jb.OtherXmlHandler;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportSpecialHandler;", "", "<init>", "()V", "specialHandlers", "", "Lcom/intellij/ide/startup/importSettings/jb/JbImportXmlHandler;", "postProcess", "", "prevConfigDir", "Ljava/nio/file/Path;", "intellij.ide.startup.importSettings"})
public final class JbImportSpecialHandler {
    @NotNull
    public static final JbImportSpecialHandler INSTANCE = new JbImportSpecialHandler();
    @NotNull
    private static final List<JbImportXmlHandler> specialHandlers = CollectionsKt.listOf((Object)OtherXmlHandler.INSTANCE);

    private JbImportSpecialHandler() {
    }

    public final void postProcess(@NotNull Path prevConfigDir) {
        Intrinsics.checkNotNullParameter((Object)prevConfigDir, (String)"prevConfigDir");
        for (JbImportXmlHandler handler : specialHandlers) {
            try {
                handler.process(prevConfigDir);
            }
            catch (Throwable th) {
                JbImportSpecialHandlersKt.access$getLogger$p().warn("error during special import handler " + handler.getName(), th);
            }
        }
    }
}

