/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime.tz;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.WeekDay;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.DateSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/DateSpecs;", "", "()V", "first", "Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/DateSpec;", "weekDay", "Lorg/jetbrains/letsPlot/commons/intern/datetime/WeekDay;", "month", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Month;", "number", "", "last", "commons"})
public final class DateSpecs {
    @NotNull
    public static final DateSpecs INSTANCE = new DateSpecs();

    private DateSpecs() {
    }

    @NotNull
    public final DateSpec last(@NotNull WeekDay weekDay, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new DateSpec(weekDay, month){
            final /* synthetic */ WeekDay $weekDay;
            final /* synthetic */ Month $month;
            {
                this.$weekDay = $weekDay;
                this.$month = $month;
            }

            @NotNull
            public String getRRule() {
                return "RRULE:FREQ=YEARLY;BYDAY=-1" + this.$weekDay.getAbbreviation() + ";BYMONTH=" + (this.$month.ordinal() + 1);
            }

            @NotNull
            public Date getDate(int year) {
                int days;
                for (int d = days = this.$month.getDaysInYear(year); 0 < d; --d) {
                    Date date = new Date(d, this.$month, year);
                    if (date.getWeekDay() != this.$weekDay) continue;
                    return date;
                }
                throw new RuntimeException();
            }
        };
    }

    @JvmOverloads
    @NotNull
    public final DateSpec first(@NotNull WeekDay weekDay, @NotNull Month month, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new DateSpec(number, weekDay, month){
            final /* synthetic */ int $number;
            final /* synthetic */ WeekDay $weekDay;
            final /* synthetic */ Month $month;
            {
                this.$number = $number;
                this.$weekDay = $weekDay;
                this.$month = $month;
            }

            @NotNull
            public String getRRule() {
                return "RRULE:FREQ=YEARLY;BYDAY=" + this.$number + this.$weekDay.getAbbreviation() + ";BYMONTH=" + (this.$month.ordinal() + 1);
            }

            @NotNull
            public Date getDate(int year) {
                int days;
                int startDay = (this.$number - 1) * WeekDay.values().length + 1;
                int d = startDay;
                if (d <= (days = this.$month.getDaysInYear(year))) {
                    while (true) {
                        Date date;
                        if ((date = new Date(d, this.$month, year)).getWeekDay() == this.$weekDay) {
                            return date;
                        }
                        if (d == days) break;
                        ++d;
                    }
                }
                throw new RuntimeException();
            }
        };
    }

    public static /* synthetic */ DateSpec first$default(DateSpecs dateSpecs, WeekDay weekDay, Month month, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return dateSpecs.first(weekDay, month, n);
    }

    @JvmOverloads
    @NotNull
    public final DateSpec first(@NotNull WeekDay weekDay, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return DateSpecs.first$default(this, weekDay, month, 0, 4, null);
    }
}

