/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer;

import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.python.scientific.powerfuldataviewer.CustomRowSorter;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellRenderer;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellRendererBase;
import com.intellij.python.scientific.powerfuldataviewer.HeaderMouseListener;
import com.intellij.python.scientific.powerfuldataviewer.PowerfulPyDataViewerPanel;
import com.intellij.python.scientific.powerfuldataviewer.actions.CopyAction;
import com.intellij.python.scientific.powerfuldataviewer.actions.SetFilterAction;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.dataframe.DataFrameTableModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataViewTableImpl
extends AbstractDataViewTable {
    private static final int MAX_INIT_COLUMN_WIDTH = 250;
    private static final int MAX_ITEM_FOR_SIZE_CALCULATION = 50;
    private static final AsyncArrayTableModel EMPTY_TABLE_MODEL = new AsyncArrayTableModel(0, 0, null, null, null);
    private final JBScrollPane myScrollPane;
    private JBTable myRowHeader;
    private JTableHeader myCorner;
    private ActionGroup myContextMenu;
    private final PowerfulPyDataViewerPanel myDataViewerPanel;
    private final CustomRowSorter myRowSorter;
    @NotNull
    private AsyncArrayTableModel myModel = EMPTY_TABLE_MODEL;
    private RowSorter.SortKey mySortKey = new RowSorter.SortKey(0, SortOrder.UNSORTED);
    private final Map<Integer, ColumnFilter> myFilters = new HashMap<Integer, ColumnFilter>();

    public DataViewTableImpl(PowerfulPyDataViewerPanel dataViewerPanel, boolean autoResize) {
        this.myDataViewerPanel = dataViewerPanel;
        this.setupRowHeader();
        this.setupTableHeader();
        this.setupSelectionModel();
        this.setupColumnModelListener();
        this.myScrollPane = new JBScrollPane((Component)((Object)this));
        this.myScrollPane.setRowHeaderView((Component)this.myRowHeader);
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.myCorner);
        this.setupContextMenu();
        this.setTransferHandler(null);
        this.setAutoResizeMode(0);
        this.setMaxItemsForSizeCalculation(50);
        this.myRowSorter = new CustomRowSorter(this);
        this.setEmpty();
    }

    private void setupSelectionModel() {
        this.setSelectionModel(new DefaultListSelectionModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().addListSelectionListener(e -> this.myRowHeader.repaint());
        this.getColumnModel().getSelectionModel().addListSelectionListener(e -> this.getTableHeader().repaint());
        ListSelectionListener focusListener = e -> {
            int row = this.getSelectionModel().getLeadSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            this.myDataViewerPanel.focusConsumer.accept((Pair<Integer, Integer>)new Pair((Object)row, (Object)column));
        };
        this.getSelectionModel().addListSelectionListener(focusListener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(focusListener);
    }

    private void setupTableHeader() {
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().getColumnModel().setColumnSelectionAllowed(true);
        HeaderMouseListener mouseListener2 = new HeaderMouseListener(this);
        this.getTableHeader().addMouseListener(mouseListener2);
        this.getTableHeader().addMouseMotionListener(mouseListener2);
        this.getTableHeader().setDefaultRenderer(new HeaderCellRenderer(this, false, mouseListener2.getColumnHoverProducer()));
    }

    private void setupRowHeader() {
        this.myRowHeader = new JBTable();
        this.myRowHeader.setAutoscrolls(false);
        this.myRowHeader.setFocusable(false);
        this.myRowHeader.setPreferredScrollableViewportSize(this.myRowHeader.getPreferredSize());
        this.myRowHeader.setDefaultRenderer(Object.class, (TableCellRenderer)new HeaderCellRendererBase(this, true));
        this.myRowHeader.getEmptyText().setText("");
        this.myRowHeader.setGridColor(this.getGridColor());
        this.myRowHeader.setCellSelectionEnabled(true);
        final DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && selectionModel.getMaxSelectionIndex() != -1) {
                    DataViewTableImpl.this.getColumnModel().getSelectionModel().setSelectionInterval(0, DataViewTableImpl.this.getColumnCount() - 1);
                    DataViewTableImpl.this.getSelectionModel().setSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
                }
            }
        });
        this.myRowHeader.setSelectionModel((ListSelectionModel)selectionModel);
        this.myRowHeader.setSelectionMode(1);
        this.myRowHeader.setMaxItemsForSizeCalculation(50);
        this.myCorner = this.myRowHeader.getTableHeader();
        this.myCorner.setResizingAllowed(true);
        this.myCorner.setReorderingAllowed(false);
        this.myCorner.setBackground(this.getBackground());
        this.myCorner.setDefaultRenderer(new HeaderCellRenderer(this, true, null));
        MouseAdapter mouseAdapter = new MouseAdapter(){
            TableColumn column;
            int columnWidth;
            int pressedX;

            @Override
            public void mousePressed(MouseEvent e) {
                TableColumnModel tcm = DataViewTableImpl.this.myCorner.getColumnModel();
                Cursor cursor = DataViewTableImpl.this.myCorner.getCursor();
                if (cursor.getType() == 11 || cursor.getType() == 10) {
                    this.column = tcm.getColumn(0);
                    this.columnWidth = this.column.getWidth();
                    this.pressedX = e.getX();
                    DataViewTableImpl.this.myCorner.addMouseMotionListener(this);
                } else {
                    DataViewTableImpl.this.selectAll();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataViewTableImpl.this.myCorner.removeMouseMotionListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int width = this.columnWidth - this.pressedX + e.getX();
                this.column.setPreferredWidth(width);
                DataViewTableImpl.this.myRowHeader.setPreferredScrollableViewportSize(DataViewTableImpl.this.myRowHeader.getPreferredSize());
                DataViewTableImpl.this.myScrollPane.revalidate();
            }
        };
        this.myCorner.addMouseListener(mouseAdapter);
    }

    private void setupColumnModelListener() {
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                DataViewTableImpl.this.adjustColumnWidth(e.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void setupContextMenu() {
        this.myContextMenu = new DefaultActionGroup(new AnAction[]{new CopyAction(this)});
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int row = DataViewTableImpl.this.rowAtPoint(new Point(x, y));
                int column = DataViewTableImpl.this.columnAtPoint(new Point(x, y));
                if (row != -1 && column != -1) {
                    if (!DataViewTableImpl.this.isRowSelected(row) || !DataViewTableImpl.this.isColumnSelected(column)) {
                        DataViewTableImpl.this.getSelectionModel().setSelectionInterval(row, row);
                        DataViewTableImpl.this.getColumnModel().getSelectionModel().setSelectionInterval(column, column);
                    }
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", DataViewTableImpl.this.myContextMenu).getComponent().show(comp, x, y);
                }
            }
        });
        final DataViewTableImpl table = this;
        this.getTableHeader().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int column = DataViewTableImpl.this.getTableHeader().columnAtPoint(new Point(x, y));
                if (column != -1) {
                    DefaultActionGroup headerContextMenu = new DefaultActionGroup();
                    headerContextMenu.add((AnAction)new SetFilterAction(table, column));
                    if (DataViewTableImpl.this.getColumnFilter(column) != null) {
                        headerContextMenu.add((AnAction)new SetFilterAction.RemoveFilterAction(table, column, null));
                    }
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", (ActionGroup)headerContextMenu).getComponent().show(comp, x, y);
                }
            }
        });
    }

    public boolean isStrSearchAvailable() {
        return this.myModel instanceof DataFrameTableModel;
    }

    public String getColumnFormat() {
        return this.myDataViewerPanel.getFormat();
    }

    public String getVariableName() {
        return this.myDataViewerPanel.getOriginalVarName();
    }

    public PyDebugValue getDebugValue() {
        return this.myModel.getDebugValue();
    }

    public JBScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public void setAutoResize(boolean autoResize) {
    }

    public void setEmpty() {
        super.setModel(EMPTY_TABLE_MODEL, false);
        this.myRowHeader.setModel((TableModel)EMPTY_TABLE_MODEL);
        this.myScrollPane.getRowHeader().setVisible(false);
    }

    public void setModel(AsyncArrayTableModel model, boolean modifier) {
        super.setModel(model, modifier);
        this.myModel = model;
        if (!modifier) {
            this.resetModifiers();
        }
        this.myRowHeader.setModel(this.myModel.getRowHeaderModel());
        this.myScrollPane.getRowHeader().setVisible(true);
    }

    public AsyncArrayTableModel getAsyncModel() {
        return this.myModel;
    }

    public void adjustColumnWidth(int col) {
        TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent((JTable)((Object)this), Strings.repeat((String)"_", (int)6), false, false, 0, col);
        int minWidth = component.getMinimumSize().width;
        component = renderer.getTableCellRendererComponent((JTable)((Object)this), this.getHeaderValueAt(col), false, false, 0, col);
        TableColumn column = this.getTableHeader().getColumnModel().getColumn(col);
        column.setMinWidth(minWidth);
        column.setPreferredWidth(Math.min(component.getPreferredSize().width, 250));
    }

    private void resetModifiers() {
        this.myRowSorter.reset();
        this.myFilters.clear();
        this.setAutoCreateColumnsFromModel(true);
    }

    private void applyModifiers() {
        String varName = this.myDataViewerPanel.getOriginalVarName();
        this.setAutoCreateColumnsFromModel(false);
        boolean modified = false;
        DataViewStrategy strategy = this.myModel.getStrategy();
        for (ColumnFilter filter : this.myFilters.values()) {
            varName = strategy.filterModifier(varName, filter);
            modified = true;
        }
        if (this.mySortKey.getSortOrder() != SortOrder.UNSORTED) {
            varName = strategy.sortModifier(varName, this.mySortKey);
            modified = true;
        }
        this.myDataViewerPanel.apply(varName, modified, null);
    }

    public void goToCell(@NotNull Pair<Integer, Integer> location) {
        if (location == null) {
            DataViewTableImpl.$$$reportNull$$$0(0);
        }
        int cRow = Math.min(Math.max((Integer)location.first, 0), this.getRowCount() - 1);
        int cCol = Math.min(Math.max((Integer)location.second, 0), this.getColumnCount() - 1);
        this.changeSelection(cRow, cCol, false, false);
    }

    public void toggleSortOrder(int column) {
        this.myRowSorter.toggleSortOrder(column);
    }

    @Nullable
    public ColumnFilter getColumnFilter(int column) {
        return this.myFilters.get(column);
    }

    public void setSortKey(@NotNull RowSorter.SortKey key) {
        if (key == null) {
            DataViewTableImpl.$$$reportNull$$$0(1);
        }
        this.mySortKey = key;
        this.applyModifiers();
    }

    public void setFilter(@NotNull ColumnFilter filter) {
        if (filter == null) {
            DataViewTableImpl.$$$reportNull$$$0(2);
        }
        this.myFilters.put(filter.getColumn(), filter);
        this.applyModifiers();
    }

    public void removeFilter(int column) {
        this.myFilters.remove(column);
        this.applyModifiers();
    }

    public Object getHeaderValueAt(int column) {
        return this.getModel().getColumnName(column);
    }

    public Object getIndexValueAt(int row) {
        return this.myRowHeader.getValueAt(row, 0);
    }

    public RowSorter.SortKey getSortKey() {
        return this.myRowSorter.getSortKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/scientific/powerfuldataviewer/DataViewTableImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "goToCell";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSortKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

