/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class SetupProjectSdkUtil {
    private static final Logger LOG = Logger.getInstance(SetupProjectSdkUtil.class);

    @VisibleForTesting
    public static Sdk setupOrDetectSdk(@NotNull String name, @NotNull String type, @NotNull String home) {
        if (name == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(1);
        }
        if (home == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(2);
        }
        Ref sdkRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            Sdk sdk = SetupProjectSdkUtil.setup(name, type, home);
            sdkRef.set((Object)sdk);
        }));
        return (Sdk)sdkRef.get();
    }

    @VisibleForTesting
    public static void setupOrDetectSdk(@NotNull Project project, @NotNull String name, @NotNull String type, @NotNull String home) {
        if (project == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(5);
        }
        if (home == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            Sdk sdk = SetupProjectSdkUtil.setup(name, type, home);
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            Sdk projectSdk = rootManager.getProjectSdk();
            if (!Objects.equals(projectSdk, sdk)) {
                LOG.info("Project uses different SDK: " + String.valueOf(projectSdk) + " (sdkName is " + rootManager.getProjectSdkName() + ", type " + rootManager.getProjectSdkTypeName() + "). Updating...");
                rootManager.setProjectSdk(sdk);
            }
            LOG.info("Project SDK is set to use the new SDK");
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (Objects.equals(moduleSdk, sdk)) continue;
                LOG.info("Module " + module.getName() + " uses different SDK: " + String.valueOf(moduleSdk) + " IGNORING!");
            }
        }));
    }

    @NotNull
    private static Sdk setup(String mySdkName, String mySdkType, String mySdkHome) {
        boolean isValidSdkHome;
        SdkType sdkType;
        Sdk oldSdk = ProjectJdkTable.getInstance().findJdk(mySdkName);
        if (oldSdk != null) {
            if (Objects.equals(oldSdk.getSdkType().getName(), mySdkName) && FileUtil.pathsEqual((String)oldSdk.getHomePath(), (String)mySdkHome)) {
                LOG.info("Existing SDK is already configured the expected way");
                Sdk sdk = oldSdk;
                if (sdk == null) {
                    SetupProjectSdkUtil.$$$reportNull$$$0(7);
                }
                return sdk;
            }
            LOG.info("Existing different SDK will be removed: " + String.valueOf(oldSdk));
            ProjectJdkTable.getInstance().removeJdk(oldSdk);
        }
        if ((sdkType = SdkType.findByName((String)mySdkType)) == null) {
            throw new IllegalArgumentException("Failed to find SdkType: " + mySdkType);
        }
        try {
            isValidSdkHome = sdkType.isValidSdkHome(mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Sdk home " + mySdkHome + " for " + String.valueOf(sdkType) + " is not valid. " + t.getMessage(), t);
        }
        if (!isValidSdkHome) {
            throw new IllegalArgumentException("Sdk home " + mySdkHome + " for " + String.valueOf(sdkType) + " is not valid");
        }
        Sdk newSdk = ProjectJdkTable.getInstance().createSdk(mySdkName, (SdkTypeId)sdkType);
        SdkModificator mod = newSdk.getSdkModificator();
        try {
            mod.setVersionString(sdkType.getVersionString(mySdkHome));
            mod.setHomePath(mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to configure Sdk instance home for " + mySdkHome + " for " + String.valueOf(sdkType) + " is not valid. " + t.getMessage(), t);
        }
        finally {
            mod.commitChanges();
        }
        try {
            sdkType.setupSdkPaths(newSdk);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to setup Sdk home for " + mySdkHome + " for " + String.valueOf(sdkType) + " is not valid. " + t.getMessage(), t);
        }
        ProjectJdkTable.getInstance().addJdk(newSdk);
        LOG.info("Registered new SDK to ProjectJdkTable: " + String.valueOf(newSdk));
        Sdk sdk = newSdk;
        if (sdk == null) {
            SetupProjectSdkUtil.$$$reportNull$$$0(8);
        }
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupOrDetectSdk";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

