/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PuppetDataTypeParameterInfo {
    private static final int CLASS = 1;
    private static final int DATA_TYPE = 2;
    private static final int RESOURCE_TYPE = 4;
    private static final int RESOURCE_INSTANCE = 8;
    private final int myFlags;
    @Nullable
    private String myResourceDataType;

    private PuppetDataTypeParameterInfo(int flags) {
        this.myFlags = flags;
    }

    private PuppetDataTypeParameterInfo(@NotNull String resourceDataType) {
        if (resourceDataType == null) {
            PuppetDataTypeParameterInfo.$$$reportNull$$$0(0);
        }
        this(8);
        this.myResourceDataType = resourceDataType;
    }

    public boolean isClass() {
        return (this.myFlags & 1) == 1;
    }

    public boolean isDataType() {
        return (this.myFlags & 2) == 2;
    }

    public boolean isResourceType() {
        return (this.myFlags & 4) == 4;
    }

    public boolean isResourceInstance() {
        return (this.myFlags & 8) == 8;
    }

    @Nullable
    public String getResourceDataType() {
        return this.myResourceDataType;
    }

    @NotNull
    public static PuppetDataTypeParameterInfo forClass() {
        return new PuppetDataTypeParameterInfo(1);
    }

    @NotNull
    public static PuppetDataTypeParameterInfo forDataType() {
        return new PuppetDataTypeParameterInfo(2);
    }

    @NotNull
    public static PuppetDataTypeParameterInfo forResourceType() {
        return new PuppetDataTypeParameterInfo(4);
    }

    @NotNull
    public static PuppetDataTypeParameterInfo forAnyType() {
        return new PuppetDataTypeParameterInfo(6);
    }

    @Contract(value="null -> null")
    public static PuppetDataTypeParameterInfo forResourceInstance(@Nullable String dataTypeName) {
        return dataTypeName == null ? null : new PuppetDataTypeParameterInfo(dataTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDataType", "com/intellij/lang/puppet/psi/PuppetDataTypeParameterInfo", "<init>"));
    }
}

