/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.util.EventDispatcher;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0014J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0007R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/JupyterRemoteLocalRootManager;", "", "<init>", "()V", "currentLocalRoot", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/nio/file/Path;", "localRootChangeDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/jupyter/core/jupyter/remote/JupyterRemoteLocalRootManager$OnLocalRootChange;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "localRoot", "getLocalRoot", "()Ljava/nio/file/Path;", "defaultLocalRoot", "getDefaultLocalRoot", "onLocalRootChange", "", "handler", "Lkotlin/Function1;", "updateLocalRoot", "path", "OnLocalRootChange", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteLocalRootManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteLocalRootManager.kt\ncom/intellij/jupyter/core/jupyter/remote/JupyterRemoteLocalRootManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class JupyterRemoteLocalRootManager {
    @NotNull
    public static final JupyterRemoteLocalRootManager INSTANCE = new JupyterRemoteLocalRootManager();
    @NotNull
    private static final AtomicReference<Path> currentLocalRoot = new AtomicReference();
    @NotNull
    private static final EventDispatcher<OnLocalRootChange> localRootChangeDispatcher;

    private JupyterRemoteLocalRootManager() {
    }

    @NotNull
    public final Path getLocalRoot() {
        Path path = currentLocalRoot.get();
        Path path2 = path;
        if (path2 == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException(("Local root for remote Jupyter subsystems must be specified explicitly when running in unit-test mode. Otherwise, it would reuse files from " + this.getDefaultLocalRoot()).toString());
            }
            Path path3 = this.getDefaultLocalRoot();
            AtomicReference<Path> atomicReference = currentLocalRoot;
            Path p0 = path3;
            boolean bl = false;
            atomicReference.set(p0);
            Path path4 = path3;
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"also(...)");
        }
        return path2;
    }

    private final Path getDefaultLocalRoot() {
        String[] stringArray = new String[]{"jupyterRemote"};
        return Paths.get(PathManager.getSystemPath(), stringArray).toAbsolutePath();
    }

    public final void onLocalRootChange(@NotNull Function1<? super Path, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        localRootChangeDispatcher.addListener((EventListener)new OnLocalRootChange(handler2){
            final /* synthetic */ Function1<Path, Unit> $handler;
            {
                this.$handler = $handler;
            }

            public void invoke(Path p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$handler.invoke((Object)p1);
            }
        });
    }

    @TestOnly
    public final void updateLocalRoot(@Nullable Path path) {
        ApplicationManager.getApplication().invokeAndWait(JupyterRemoteLocalRootManager::updateLocalRoot$lambda$0);
        currentLocalRoot.set(path);
        if (path != null) {
            ((OnLocalRootChange)localRootChangeDispatcher.getMulticaster()).invoke(path);
        }
    }

    private static final void updateLocalRoot$lambda$0() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        for (Document document : fileDocumentManager2.getUnsavedDocuments()) {
            if (!BackedNotebookVirtualFile.Companion.isBacked(fileDocumentManager2.getFile(document))) continue;
            fileDocumentManager2.reloadFromDisk(document);
        }
    }

    static {
        EventDispatcher eventDispatcher = EventDispatcher.create(OnLocalRootChange.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        localRootChangeDispatcher = eventDispatcher;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/JupyterRemoteLocalRootManager$OnLocalRootChange;", "Ljava/util/EventListener;", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "intellij.jupyter.core"})
    private static interface OnLocalRootChange
    extends EventListener,
    Function1<Path, Unit> {
    }
}

