/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown.latex;

import com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexFontConfig;
import com.intellij.jupyter.core.jupyter.editor.markdown.latex.TeXIconWrapper;
import com.intellij.jupyter.core.jupyter.editor.markdown.latex.TexLexer;
import com.intellij.jupyter.core.jupyter.editor.markdown.latex.TexLexerToolsKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.NewEnvironmentMacro;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXFormula;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexMarkdownConverter;", "", "markdown", "", "<init>", "(Ljava/lang/String;)V", "inlineFormulas", "Ljava/util/ArrayList;", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper;", "Lkotlin/collections/ArrayList;", "texLexer", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TexLexer;", "convert", "editor", "Lcom/intellij/openapi/util/UserDataHolder;", "fontConfig", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexFontConfig;", "closeLine", "", "TexFormulaKeeper", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nLatexMarkdownConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexMarkdownConverter.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexMarkdownConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class LatexMarkdownConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String markdown;
    @NotNull
    private final ArrayList<TeXIconWrapper> inlineFormulas;
    @NotNull
    private final TexLexer texLexer;
    @NotNull
    private static final Set<String> allowedCommands;
    @NotNull
    private static final Regex headerPattern;

    private LatexMarkdownConverter(String markdown) {
        this.markdown = markdown;
        this.inlineFormulas = new ArrayList();
        this.texLexer = new TexLexer(this.markdown);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final String convert(@NotNull UserDataHolder editor, @NotNull LatexFontConfig fontConfig) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fontConfig, (String)"fontConfig");
        result = new StringBuilder(this.markdown.length());
        lineStart = 0;
        currentFormulaKeeper = null;
        block10: while (this.texLexer.yychar < this.markdown.length()) {
            v0 = token = this.texLexer.yylex();
            switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case -1: {
                    break block10;
                }
                case 1: {
                    char = this.markdown.charAt(this.texLexer.yychar);
                    result.append(char);
                    if (char == '\n') {
                        this.closeLine();
                        lineStart = this.texLexer.yychar + 1;
                    }
                    v1 = Unit.INSTANCE;
                    break;
                }
                case 2: 
                case 3: {
                    headerSize = 0;
                    if (token == TexLexer.TexType.OPEN_INLINE_TEX) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.markdown.substring(lineStart, this.texLexer.yychar), (String)"substring(...)");
                        if (Regex.find$default((Regex)LatexMarkdownConverter.headerPattern, (CharSequence)lineFromBeginning, (int)0, (int)2, null) != null) {
                            $i$a$-let-LatexMarkdownConverter$convert$1 = false;
                            headerSize = it.getValue().length();
                        }
                    }
                    currentFormulaKeeper = new TexFormulaKeeper(token == TexLexer.TexType.OPEN_INLINE_TEX ? Integer.valueOf(headerSize) : null);
                    v1 = currentFormulaKeeper.getTex().append(com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexMarkdownConverter$Companion.access$processEnvironment(LatexMarkdownConverter.Companion, this.texLexer.yytext().toString(), true));
                    break;
                }
                case 4: {
                    v2 = currentFormulaKeeper;
                    Intrinsics.checkNotNull((Object)v2);
                    v1 = v2.getTex().append(com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexMarkdownConverter$Companion.access$processEscapedCommand(LatexMarkdownConverter.Companion, this.texLexer.yytext().toString(), fontConfig));
                    break;
                }
                case 5: {
                    v3 = currentFormulaKeeper;
                    Intrinsics.checkNotNull((Object)v3);
                    v1 = v3.getTex().append(com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexMarkdownConverter$Companion.access$processEnvironment(LatexMarkdownConverter.Companion, this.texLexer.yytext().toString(), true));
                    break;
                }
                case 6: {
                    v4 = currentFormulaKeeper;
                    Intrinsics.checkNotNull((Object)v4);
                    v1 = v4.getTex().append(com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexMarkdownConverter$Companion.access$processEnvironment(LatexMarkdownConverter.Companion, this.texLexer.yytext().toString(), false));
                    break;
                }
                case 7: {
                    v5 = currentFormulaKeeper;
                    Intrinsics.checkNotNull((Object)v5);
                    v1 = v5.getTex().append(this.markdown.charAt(this.texLexer.yychar));
                    break;
                }
                case 8: {
                    v6 = currentFormulaKeeper;
                    Intrinsics.checkNotNull((Object)v6);
                    inlineHeaderSize = v6.getInlineHeaderSize();
                    currentFormulaKeeper.getTex().append(com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexMarkdownConverter$Companion.access$processEnvironment(LatexMarkdownConverter.Companion, this.texLexer.yytext().toString(), false));
                    if (inlineHeaderSize == null) {
                        result.append("\n\n<p align='center'>");
                        this.closeLine();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)currentFormulaKeeper.getTex().toString(), (String)"toString(...)");
                    v7 /* !! */  = inlineHeaderSize;
                    if (v7 /* !! */  == null) ** GOTO lbl70
                    it = ((Number)v7 /* !! */ ).intValue();
                    $i$a$-let-LatexMarkdownConverter$convert$fontSize$1 = false;
                    v8 = (Integer)ArraysKt.getOrNull((Object[])fontConfig.getHeaderSizes(), (int)(it - 1));
                    v7 /* !! */  = v8;
                    if (v8 != null) ** GOTO lbl71
lbl70:
                    // 2 sources

                    v7 /* !! */  = Float.valueOf(fontConfig.getRegularFontSize());
lbl71:
                    // 2 sources

                    if ((v9 = (teXIconWrapper = TeXIconWrapper.Companion.create(tex, editor, fontSize = ((Number)v7 /* !! */ ).floatValue(), fontConfig.getForegroundColor()))) == null || (v9 = v9.toString()) == null) {
                        v10 = StringUtil.escapeXmlEntities((String)tex);
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"escapeXmlEntities(...)");
                        v9 = StringsKt.replace$default((String)v10, (String)"\n", (String)" ", (boolean)false, (int)4, null);
                    }
                    result.append((String)v9);
                    if (inlineHeaderSize == null) {
                        result.append("\n\n</p>\n\n");
                    } else if (teXIconWrapper != null) {
                        ((Collection)this.inlineFormulas).add(teXIconWrapper);
                    }
                    currentFormulaKeeper = null;
                    v1 = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        v11 = currentFormulaKeeper;
        if (v11 != null) {
            it = v11;
            $i$a$-let-LatexMarkdownConverter$convert$2 = false;
            result.append((CharSequence)it.getTex());
        }
        this.closeLine();
        v12 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"toString(...)");
        return v12;
    }

    private final void closeLine() {
        TeXIconWrapper.Companion.alignToSameHeight((Collection<TeXIconWrapper>)this.inlineFormulas);
        this.inlineFormulas.clear();
    }

    public /* synthetic */ LatexMarkdownConverter(String markdown, DefaultConstructorMarker $constructor_marker) {
        this(markdown);
    }

    static {
        Object[] objectArray = new String[]{"begin", "end", "makeatletter", "makeatother", "left", "right"};
        allowedCommands = SetsKt.setOf((Object[])objectArray);
        headerPattern = new Regex("^#+");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexMarkdownConverter$Companion;", "", "<init>", "()V", "allowedCommands", "", "", "headerPattern", "Lkotlin/text/Regex;", "processEscapedCommand", "command", "uiSettings", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexFontConfig;", "processEnvironment", "currentToken", "open", "", "convertTexToImageInMarkdown", "markdown", "editor", "Lcom/intellij/openapi/util/UserDataHolder;", "fontConfig", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String processEscapedCommand(String command, LatexFontConfig uiSettings) {
            if (StringsKt.endsWith$default((String)command, (String)"@env", (boolean)false, (int)2, null)) {
                return command;
            }
            String commandNoEscape = ((Object)command.subSequence(1, command.length())).toString();
            if (allowedCommands.contains(commandNoEscape)) {
                return command;
            }
            new TeXFormula();
            if (Intrinsics.areEqual((Object)commandNoEscape, (Object)"tag")) {
                return "\\boxed";
            }
            HashMap<String, MacroInfo> hashMap = MacroInfo.Commands;
            Intrinsics.checkNotNullExpressionValue(hashMap, (String)"Commands");
            if (((Map)hashMap).containsKey(commandNoEscape)) {
                return command;
            }
            try {
                Atom cfr_ignored_0 = TeXFormula.get((String)commandNoEscape).root;
                return command;
            }
            catch (FormulaNotFoundException formulaNotFoundException) {
                try {
                    SymbolAtom.get(commandNoEscape);
                    return command;
                }
                catch (SymbolNotFoundException symbolNotFoundException) {
                    Color color = uiSettings.getErrorColor();
                    return "\\textcolor{" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "}{\\backslash " + commandNoEscape + "}";
                }
            }
        }

        private final String processEnvironment(String currentToken, boolean open) {
            CharSequence charSequence = TexLexerToolsKt.getEnvName(currentToken, open);
            if (charSequence == null) {
                return currentToken;
            }
            CharSequence environment = charSequence;
            return NewEnvironmentMacro.isMacro(environment + "@env") ? currentToken : TexLexerToolsKt.getTag(open) + "align}";
        }

        @NotNull
        public final String convertTexToImageInMarkdown(@NotNull String markdown, @NotNull UserDataHolder editor, @NotNull LatexFontConfig fontConfig) {
            Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)fontConfig, (String)"fontConfig");
            return new LatexMarkdownConverter(markdown, null).convert(editor, fontConfig);
        }

        public static final /* synthetic */ String access$processEnvironment(Companion $this, String currentToken, boolean open) {
            return $this.processEnvironment(currentToken, open);
        }

        public static final /* synthetic */ String access$processEscapedCommand(Companion $this, String command, LatexFontConfig uiSettings) {
            return $this.processEscapedCommand(command, uiSettings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/LatexMarkdownConverter$TexFormulaKeeper;", "", "inlineHeaderSize", "", "<init>", "(Ljava/lang/Integer;)V", "getInlineHeaderSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "tex", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTex", "()Ljava/lang/StringBuilder;", "intellij.jupyter.core"})
    private static final class TexFormulaKeeper {
        @Nullable
        private final Integer inlineHeaderSize;
        @NotNull
        private final StringBuilder tex;

        public TexFormulaKeeper(@Nullable Integer inlineHeaderSize) {
            this.inlineHeaderSize = inlineHeaderSize;
            this.tex = new StringBuilder();
        }

        @Nullable
        public final Integer getInlineHeaderSize() {
            return this.inlineHeaderSize;
        }

        @NotNull
        public final StringBuilder getTex() {
            return this.tex;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TexLexer.TexType.values().length];
            try {
                nArray[TexLexer.TexType.PLAIN_CHAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.OPEN_INLINE_TEX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.OPEN_BLOCK_TEX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.TEX_ESCAPED_KEY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.TEX_OPEN_SUB_ENV.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.TEX_CLOSE_SUB_ENV.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.TEX_CHAR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TexLexer.TexType.CLOSE_TEX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

