/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputFileName;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/InputCellFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;)V", "getFileName", "()Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "relativePath", "Ljava/nio/file/Path;", "getRelativePath", "()Ljava/nio/file/Path;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jupyter.core"})
final class InputCellFileAction
extends DumbAwareAction {
    @NotNull
    private final JupyterDataInputFileName fileName;
    @NotNull
    private final Path relativePath;

    public InputCellFileAction(@NotNull VirtualFile file, @NotNull Editor editor, @NotNull JupyterDataInputFileName fileName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(file.getName(), null, JupyterCoreIcons.ImportDataCell);
        this.fileName = fileName;
        Path path = editor.getVirtualFile().getParent().toNioPath().toAbsolutePath().relativize(file.toNioPath().toAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        this.relativePath = path;
    }

    @NotNull
    public final JupyterDataInputFileName getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Path getRelativePath() {
        return this.relativePath;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fileName.set(((Object)this.relativePath).toString());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.relativePath.getParent();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        Object parentPath = object;
        e.getPresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, parentPath);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

