/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellDropHandler;
import com.intellij.jupyter.core.core.impl.file.singleFile.JupyterFileModelCache;
import com.intellij.jupyter.core.core.impl.file.singleFile.JupyterFileSaveChangeListener;
import com.intellij.jupyter.core.editor.JupyterExecutionHistoryProvider;
import com.intellij.jupyter.core.editor.JupyterLineNumberConverterSetter;
import com.intellij.jupyter.core.editor.NotebookCellInlayManagerUtilKt;
import com.intellij.jupyter.core.editor.NotebookContextMenuMouseManagementKt;
import com.intellij.jupyter.core.editor.NotebookEditorCreatedCallback;
import com.intellij.jupyter.core.editor.NotebookEditorScrollEndDetector;
import com.intellij.jupyter.core.editor.NotebookExecutionInfo;
import com.intellij.jupyter.core.editor.NotebookFileListenerService;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManager;
import com.intellij.jupyter.core.editor.NotebookToolbarManager;
import com.intellij.jupyter.core.editor.markdown.MarkdownNotebookPostprocessor;
import com.intellij.jupyter.core.editor.ui.NotebookCellMarkerDecorator;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookConnectionListener;
import com.intellij.jupyter.core.jupyter.editor.JupyterAboveCellToolbarManager;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlag;
import com.intellij.jupyter.core.jupyter.editor.JupyterIntervalPointerChangeListener;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputApi;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.trust.JupyterNotebookTrustManager;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookEditorAppearanceProvider;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.DecoratedEditor;
import com.intellij.notebooks.visualization.ui.NotebookVisibleCellsBatchUpdater;
import com.intellij.notebooks.visualization.ui.jupyterToolbars.NotebookCellActionsToolbarStateTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileEditorService;", "", "<init>", "()V", "onNotebookFileEditorCreated", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "setupGutter", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookFileEditorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileEditorService.kt\ncom/intellij/jupyter/core/editor/NotebookFileEditorService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class NotebookFileEditorService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void onNotebookFileEditorCreated(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor) == null) {
            return;
        }
        JupyterFileModelCache.Companion.registryForEditor((Editor)editor);
        if (JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor) == null) {
            return;
        }
        JupyterFileSaveChangeListener.Companion.setup((Editor)editor);
        NotebookCellLinesProvider.Companion.install((Editor)editor);
        JupyterNotebookTrustManager.Companion.install((Editor)editor);
        JupyterWebOutputApi.Companion.installWebOutputApi(editor);
        if (!AppMode.isRemoteDevHost()) {
            NotebookCellMarkerDecorator.Companion.attach((Editor)editor);
        }
        JupyterIntervalPointerChangeListener.Companion.install(editor);
        NotebookEditorAppearanceProvider.Companion.install((Editor)editor);
        this.setupGutter(editor);
        NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editor));
        if (!AppMode.isRemoteDevHost()) {
            JupyterAboveCellToolbarManager.Companion.install(editor);
            JupyterBoundsChangeHandler.Companion.install(editor);
            NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.install(editor, true, CollectionsKt.listOf((Object)new MarkdownNotebookPostprocessor()));
            NotebookCellMarkerDecorator.Companion.attach((Editor)editor);
            NotebookToolbarManager.Companion.install(editor);
            DecoratedEditor.Companion.install(editor, notebookCellInlayManager);
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            NotebookCellInlayManagerUtilKt.addJupyterListeners(notebookCellInlayManager, JupyterInlayProgressStatusManager.Companion.getInstance(project));
            NotebookMarkdownEditorManager.Companion.install(editor);
            NotebookEditorScrollEndDetector.Companion.install(editor);
            NotebookVisibleCellsBatchUpdater.Companion.install(editor);
            NotebookCellDropHandler.Companion.install(editor);
            NotebookCellActionsToolbarStateTracker.Companion.install(editor);
        }
        NotebookContextMenuMouseManagementKt.installNotebookContextMenuMouseManager(editor);
        NotebookEditorModeKt.setMode((Editor)((Editor)editor), (NotebookEditorMode)NotebookEditorMode.COMMAND);
        JupyterExecutionHistoryProvider.Companion.getOrInstall((Editor)editor);
        JupyterEditorInitializationFlag.INSTANCE.install((Editor)editor);
        NotebookEditorCreatedCallback.Companion.call((Editor)editor);
        NotebookExecutionInfo.Companion.install(editor);
        Project project = editor.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            NotebookFileListenerService.Companion.getInstance(it).installListenerIfNeeded();
        }
        editor.putUserData(EditorMarkupModelImpl.DISABLE_CODE_LENS, (Object)true);
        editor.getSettings().setShowIntentionBulb(false);
        JupyterNotebookConnectionListener.Companion.initFor(editor);
    }

    private final void setupGutter(EditorImpl editor) {
        editor.getSettings().setLineNumbersAfterIcons(true);
        editor.getSettings().setFoldingOutlineShown(false);
        editor.getGutterComponentEx().setPaintBackground(false);
        JupyterLineNumberConverterSetter.Companion.getInstance().setConverterToEditor((Editor)editor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileEditorService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/editor/NotebookFileEditorService;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookFileEditorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileEditorService.kt\ncom/intellij/jupyter/core/editor/NotebookFileEditorService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,104:1\n40#2,3:105\n*S KotlinDebug\n*F\n+ 1 NotebookFileEditorService.kt\ncom/intellij/jupyter/core/editor/NotebookFileEditorService$Companion\n*L\n102#1:105,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookFileEditorService getInstance() {
            boolean $i$f$service = false;
            Class<NotebookFileEditorService> serviceClass$iv = NotebookFileEditorService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NotebookFileEditorService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

