//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdata?language=objc)
#[repr(C)]
pub struct CFData {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFData"]
    unsafe impl CFData {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutabledata?language=objc)
#[repr(C)]
pub struct CFMutableData {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFData"]
    unsafe impl CFMutableData: CFData {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFData {
    #[doc(alias = "CFDataGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFDataGetTypeID() -> CFTypeID;
        }
        unsafe { CFDataGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreate(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreate(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreate(allocator, bytes, length) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateWithBytesNoCopy(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
    bytes_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreateWithBytesNoCopy(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
            bytes_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreateWithBytesNoCopy(allocator, bytes, length, bytes_deallocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateCopy(
    allocator: Option<&CFAllocator>,
    the_data: Option<&CFData>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreateCopy(
            allocator: Option<&CFAllocator>,
            the_data: Option<&CFData>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreateCopy(allocator, the_data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
) -> Option<CFRetained<CFMutableData>> {
    extern "C-unwind" {
        fn CFDataCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
        ) -> Option<NonNull<CFMutableData>>;
    }
    let ret = unsafe { CFDataCreateMutable(allocator, capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    the_data: Option<&CFData>,
) -> Option<CFRetained<CFMutableData>> {
    extern "C-unwind" {
        fn CFDataCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            the_data: Option<&CFData>,
        ) -> Option<NonNull<CFMutableData>>;
    }
    let ret = unsafe { CFDataCreateMutableCopy(allocator, capacity, the_data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataGetLength(the_data: &CFData) -> CFIndex;
}

extern "C-unwind" {
    pub fn CFDataGetBytePtr(the_data: &CFData) -> *const u8;
}

extern "C-unwind" {
    pub fn CFDataGetMutableBytePtr(the_data: Option<&CFMutableData>) -> *mut u8;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataGetBytes(the_data: &CFData, range: CFRange, buffer: *mut u8);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataSetLength(the_data: Option<&CFMutableData>, length: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataIncreaseLength(the_data: Option<&CFMutableData>, extra_length: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataAppendBytes(the_data: Option<&CFMutableData>, bytes: *const u8, length: CFIndex);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataReplaceBytes(
        the_data: Option<&CFMutableData>,
        range: CFRange,
        new_bytes: *const u8,
        new_length: CFIndex,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataDeleteBytes(the_data: Option<&CFMutableData>, range: CFRange);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdatasearchflags?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFDataSearchFlags(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFDataSearchFlags: CFOptionFlags {
        #[doc(alias = "kCFDataSearchBackwards")]
        const Backwards = 1<<0;
        #[doc(alias = "kCFDataSearchAnchored")]
        const Anchored = 1<<1;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFDataSearchFlags {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFDataSearchFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFDataFind(
        the_data: &CFData,
        data_to_find: Option<&CFData>,
        search_range: CFRange,
        compare_options: CFDataSearchFlags,
    ) -> CFRange;
}
