#ifndef _GNET_CHANNEL_H_
#define _GNET_CHANNEL_H_

#define GNET_OP_EX	0x00
#define GNET_OP_READ	0x01
#define GNET_OP_WRITE	0x02


#define CHANNEL_STATE_DISCONNECTED	0x00
#define CHANNEL_STATE_CONNECTING	0x01
#define CHANNEL_STATE_CONNECTED		0x02

#define CONNECT_STATE_START		0x00
#define CONNECT_STATE_HANDSHAKE1	0x01
#define CONNECT_STATE_HANDSHAKE2	0x02
#define CONNECT_STATE_HANDSHAKE3	0x03

#define CONNECTED(c)		(c->c_state == CHANNEL_STATE_CONNECTED)

struct gnet;

struct channel {
    int			c_fd;
    int			c_state;
    int			c_substate;
    int			c_testrd;
    int			c_testwr;
    int			c_failures;
    int 		c_out_index;
    int			c_in_index;
    unsigned short	c_port;
    char		c_addr[4];
    char		c_buf[MAX_BUFFER];
    time_t		c_stamp;
    struct gnet		*c_engine;
    struct list_head	c_list;
    struct list_head	c_out;
    struct list_head	c_guids;
};

int gnet_add_peer(struct gnet*, char*, unsigned short);
int gnet_channel_connect(struct channel*);
void gnet_channel_destroy(struct gnet*, struct channel*);
void gnet_channel_io(struct gnet*, struct channel*, int);
void gnet_test_rd(struct gnet*, struct channel*);
void gnet_test_wr(struct gnet*, struct channel*);
void gnet_untest_rd(struct gnet*, struct channel*);
void gnet_untest_wr(struct gnet*, struct channel*);
void gnet_drop_channel(struct gnet*, struct channel*);
struct channel *gnet_channel_create(struct gnet*);

#endif
