// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudGlobalNetworkManager20220215PeerDialer PeerDialer is used when creating a peering connection in order to specify
// options only available to the Dialer peer
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.PeerDialer
type HashicorpCloudGlobalNetworkManager20220215PeerDialer struct {

	// cluster
	Cluster *cloud.HashicorpCloudLocationLink `json:"cluster,omitempty"`

	// cluster partition
	ClusterPartition string `json:"cluster_partition,omitempty"`

	// network connectivity
	NetworkConnectivity *HashicorpCloudGlobalNetworkManager20220215NetworkConnectivity `json:"network_connectivity,omitempty"`

	// peer meta
	PeerMeta map[string]string `json:"peer_meta,omitempty"`

	// peer name
	PeerName string `json:"peer_name,omitempty"`
}

// Validate validates this hashicorp cloud global network manager 20220215 peer dialer
func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworkConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) validateNetworkConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.NetworkConnectivity) { // not required
		return nil
	}

	if m.NetworkConnectivity != nil {
		if err := m.NetworkConnectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_connectivity")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network_connectivity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 peer dialer based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {

		if swag.IsZero(m.Cluster) { // not required
			return nil
		}

		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) contextValidateNetworkConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.NetworkConnectivity != nil {

		if swag.IsZero(m.NetworkConnectivity) { // not required
			return nil
		}

		if err := m.NetworkConnectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_connectivity")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network_connectivity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215PeerDialer) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215PeerDialer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
