// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudConsulTelemetry20230414IntentionsEntry an entry is a single intention in GNM. This contains minimal information: the location,
// cluster name, and id of the intention so it can be retrieved from GNM.
//
// swagger:model hashicorp.cloud.consul_telemetry_20230414.Intentions.Entry
type HashicorpCloudConsulTelemetry20230414IntentionsEntry struct {

	// cluster_location is the location of the intention in GNM: org and project.
	ClusterLocation *cloud.HashicorpCloudLocationLocation `json:"cluster_location,omitempty"`

	// cluster_name is the name of the cluster in GNM.
	ClusterName string `json:"cluster_name,omitempty"`

	// intention_id is the id of the intention in GNM.
	IntentionID string `json:"intention_id,omitempty"`

	// intention_precedence is the precedence of the intention from 1-9.
	// see: https://developer.hashicorp.com/consul/docs/connect/intentions#precedence-and-match-order
	IntentionPrecedence int64 `json:"intention_precedence,omitempty"`
}

// Validate validates this hashicorp cloud consul telemetry 20230414 intentions entry
func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClusterLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) validateClusterLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterLocation) { // not required
		return nil
	}

	if m.ClusterLocation != nil {
		if err := m.ClusterLocation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster_location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud consul telemetry 20230414 intentions entry based on the context it is used
func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClusterLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) contextValidateClusterLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.ClusterLocation != nil {

		if swag.IsZero(m.ClusterLocation) { // not required
			return nil
		}

		if err := m.ClusterLocation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster_location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudConsulTelemetry20230414IntentionsEntry) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudConsulTelemetry20230414IntentionsEntry
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
