// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/computed_routes.proto

package meshv2beta1

import (
	v2beta1 "github.com/hashicorp/consul/proto-public/pbcatalog/v2beta1"
	pbproxystate "github.com/hashicorp/consul/proto-public/pbmesh/v2beta1/pbproxystate"
	pbresource "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=BACKEND_TARGET_DETAILS_TYPE_UNSPECIFIED;BACKEND_TARGET_DETAILS_TYPE_DIRECT;BACKEND_TARGET_DETAILS_TYPE_INDIRECT
// +kubebuilder:validation:Type=string
type BackendTargetDetailsType int32

const (
	BackendTargetDetailsType_BACKEND_TARGET_DETAILS_TYPE_UNSPECIFIED BackendTargetDetailsType = 0
	// Direct means that the target is directly routable from a route. This does
	// not mean that the target is not also indirect though.
	BackendTargetDetailsType_BACKEND_TARGET_DETAILS_TYPE_DIRECT BackendTargetDetailsType = 1
	// Indirect means that the target is not directly routable from a route.
	//
	// One example would be for a FailoverPolicy destination.
	BackendTargetDetailsType_BACKEND_TARGET_DETAILS_TYPE_INDIRECT BackendTargetDetailsType = 2
)

// Enum value maps for BackendTargetDetailsType.
var (
	BackendTargetDetailsType_name = map[int32]string{
		0: "BACKEND_TARGET_DETAILS_TYPE_UNSPECIFIED",
		1: "BACKEND_TARGET_DETAILS_TYPE_DIRECT",
		2: "BACKEND_TARGET_DETAILS_TYPE_INDIRECT",
	}
	BackendTargetDetailsType_value = map[string]int32{
		"BACKEND_TARGET_DETAILS_TYPE_UNSPECIFIED": 0,
		"BACKEND_TARGET_DETAILS_TYPE_DIRECT":      1,
		"BACKEND_TARGET_DETAILS_TYPE_INDIRECT":    2,
	}
)

func (x BackendTargetDetailsType) Enum() *BackendTargetDetailsType {
	p := new(BackendTargetDetailsType)
	*p = x
	return p
}

func (x BackendTargetDetailsType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendTargetDetailsType) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_computed_routes_proto_enumTypes[0].Descriptor()
}

func (BackendTargetDetailsType) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_computed_routes_proto_enumTypes[0]
}

func (x BackendTargetDetailsType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendTargetDetailsType.Descriptor instead.
func (BackendTargetDetailsType) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{0}
}

// This is a Resource type.
type ComputedRoutes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PortedConfigs is the map of service ports to the ComputedPortRoutes for
	// those ports.
	//
	// The port identifier key here is always normalized to the target (workload)
	// port name regardless of whether a virtual or target port identifier was
	// provided in input config.
	PortedConfigs map[string]*ComputedPortRoutes `protobuf:"bytes,1,rep,name=ported_configs,json=portedConfigs,proto3" json:"ported_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// BoundReferences is a slice of mixed type references of resources that were
	// involved in the formulation of this resource.
	BoundReferences []*pbresource.Reference `protobuf:"bytes,2,rep,name=bound_references,json=boundReferences,proto3" json:"bound_references,omitempty"`
}

func (x *ComputedRoutes) Reset() {
	*x = ComputedRoutes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedRoutes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedRoutes) ProtoMessage() {}

func (x *ComputedRoutes) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedRoutes.ProtoReflect.Descriptor instead.
func (*ComputedRoutes) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{0}
}

func (x *ComputedRoutes) GetPortedConfigs() map[string]*ComputedPortRoutes {
	if x != nil {
		return x.PortedConfigs
	}
	return nil
}

func (x *ComputedRoutes) GetBoundReferences() []*pbresource.Reference {
	if x != nil {
		return x.BoundReferences
	}
	return nil
}

type ComputedPortRoutes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Config:
	//
	//	*ComputedPortRoutes_Http
	//	*ComputedPortRoutes_Grpc
	//	*ComputedPortRoutes_Tcp
	Config             isComputedPortRoutes_Config `protobuf_oneof:"config"`
	UsingDefaultConfig bool                        `protobuf:"varint,4,opt,name=using_default_config,json=usingDefaultConfig,proto3" json:"using_default_config,omitempty"` // TODO
	ParentRef          *ParentReference            `protobuf:"bytes,5,opt,name=parent_ref,json=parentRef,proto3" json:"parent_ref,omitempty"`
	// Protocol is the ParentRef.Port's protocol. It is based on the value in the
	// Service object, but may differ depending upon which xRoutes are actually
	// in use.
	Protocol v2beta1.Protocol `protobuf:"varint,6,opt,name=protocol,proto3,enum=hashicorp.consul.catalog.v2beta1.Protocol" json:"protocol,omitempty"`
	// map key is an opaque string; like disco chain target name
	Targets map[string]*BackendTargetDetails `protobuf:"bytes,7,rep,name=targets,proto3" json:"targets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ComputedPortRoutes) Reset() {
	*x = ComputedPortRoutes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedPortRoutes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedPortRoutes) ProtoMessage() {}

func (x *ComputedPortRoutes) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedPortRoutes.ProtoReflect.Descriptor instead.
func (*ComputedPortRoutes) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{1}
}

func (m *ComputedPortRoutes) GetConfig() isComputedPortRoutes_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *ComputedPortRoutes) GetHttp() *ComputedHTTPRoute {
	if x, ok := x.GetConfig().(*ComputedPortRoutes_Http); ok {
		return x.Http
	}
	return nil
}

func (x *ComputedPortRoutes) GetGrpc() *ComputedGRPCRoute {
	if x, ok := x.GetConfig().(*ComputedPortRoutes_Grpc); ok {
		return x.Grpc
	}
	return nil
}

func (x *ComputedPortRoutes) GetTcp() *ComputedTCPRoute {
	if x, ok := x.GetConfig().(*ComputedPortRoutes_Tcp); ok {
		return x.Tcp
	}
	return nil
}

func (x *ComputedPortRoutes) GetUsingDefaultConfig() bool {
	if x != nil {
		return x.UsingDefaultConfig
	}
	return false
}

func (x *ComputedPortRoutes) GetParentRef() *ParentReference {
	if x != nil {
		return x.ParentRef
	}
	return nil
}

func (x *ComputedPortRoutes) GetProtocol() v2beta1.Protocol {
	if x != nil {
		return x.Protocol
	}
	return v2beta1.Protocol(0)
}

func (x *ComputedPortRoutes) GetTargets() map[string]*BackendTargetDetails {
	if x != nil {
		return x.Targets
	}
	return nil
}

type isComputedPortRoutes_Config interface {
	isComputedPortRoutes_Config()
}

type ComputedPortRoutes_Http struct {
	Http *ComputedHTTPRoute `protobuf:"bytes,1,opt,name=http,proto3,oneof"`
}

type ComputedPortRoutes_Grpc struct {
	Grpc *ComputedGRPCRoute `protobuf:"bytes,2,opt,name=grpc,proto3,oneof"`
}

type ComputedPortRoutes_Tcp struct {
	Tcp *ComputedTCPRoute `protobuf:"bytes,3,opt,name=tcp,proto3,oneof"`
}

func (*ComputedPortRoutes_Http) isComputedPortRoutes_Config() {}

func (*ComputedPortRoutes_Grpc) isComputedPortRoutes_Config() {}

func (*ComputedPortRoutes_Tcp) isComputedPortRoutes_Config() {}

type ComputedHTTPRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules []*ComputedHTTPRouteRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ComputedHTTPRoute) Reset() {
	*x = ComputedHTTPRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedHTTPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedHTTPRoute) ProtoMessage() {}

func (x *ComputedHTTPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedHTTPRoute.ProtoReflect.Descriptor instead.
func (*ComputedHTTPRoute) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{2}
}

func (x *ComputedHTTPRoute) GetRules() []*ComputedHTTPRouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type ComputedHTTPRouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Matches     []*HTTPRouteMatch         `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	Filters     []*HTTPRouteFilter        `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	BackendRefs []*ComputedHTTPBackendRef `protobuf:"bytes,3,rep,name=backend_refs,json=backendRefs,proto3" json:"backend_refs,omitempty"`
	Timeouts    *HTTPRouteTimeouts        `protobuf:"bytes,4,opt,name=timeouts,proto3" json:"timeouts,omitempty"`
	Retries     *HTTPRouteRetries         `protobuf:"bytes,5,opt,name=retries,proto3" json:"retries,omitempty"`
}

func (x *ComputedHTTPRouteRule) Reset() {
	*x = ComputedHTTPRouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedHTTPRouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedHTTPRouteRule) ProtoMessage() {}

func (x *ComputedHTTPRouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedHTTPRouteRule.ProtoReflect.Descriptor instead.
func (*ComputedHTTPRouteRule) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{3}
}

func (x *ComputedHTTPRouteRule) GetMatches() []*HTTPRouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *ComputedHTTPRouteRule) GetFilters() []*HTTPRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *ComputedHTTPRouteRule) GetBackendRefs() []*ComputedHTTPBackendRef {
	if x != nil {
		return x.BackendRefs
	}
	return nil
}

func (x *ComputedHTTPRouteRule) GetTimeouts() *HTTPRouteTimeouts {
	if x != nil {
		return x.Timeouts
	}
	return nil
}

func (x *ComputedHTTPRouteRule) GetRetries() *HTTPRouteRetries {
	if x != nil {
		return x.Retries
	}
	return nil
}

type ComputedHTTPBackendRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BackendTarget indicates which key in the targets map provides
	// the rest of the configuration.
	//
	// If this field is set to the empty string, or is the sentinel value
	// "NULL-ROUTE" is an indication that all of the traffic destined for this
	// backend reference should be null routed in a format appropriate for the
	// protocol (i.e. for HTTP use 5xx).
	BackendTarget string             `protobuf:"bytes,1,opt,name=backend_target,json=backendTarget,proto3" json:"backend_target,omitempty"`
	Weight        uint32             `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	Filters       []*HTTPRouteFilter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *ComputedHTTPBackendRef) Reset() {
	*x = ComputedHTTPBackendRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedHTTPBackendRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedHTTPBackendRef) ProtoMessage() {}

func (x *ComputedHTTPBackendRef) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedHTTPBackendRef.ProtoReflect.Descriptor instead.
func (*ComputedHTTPBackendRef) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{4}
}

func (x *ComputedHTTPBackendRef) GetBackendTarget() string {
	if x != nil {
		return x.BackendTarget
	}
	return ""
}

func (x *ComputedHTTPBackendRef) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *ComputedHTTPBackendRef) GetFilters() []*HTTPRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type ComputedGRPCRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules []*ComputedGRPCRouteRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ComputedGRPCRoute) Reset() {
	*x = ComputedGRPCRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedGRPCRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedGRPCRoute) ProtoMessage() {}

func (x *ComputedGRPCRoute) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedGRPCRoute.ProtoReflect.Descriptor instead.
func (*ComputedGRPCRoute) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{5}
}

func (x *ComputedGRPCRoute) GetRules() []*ComputedGRPCRouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type ComputedGRPCRouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Matches     []*GRPCRouteMatch         `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	Filters     []*GRPCRouteFilter        `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	BackendRefs []*ComputedGRPCBackendRef `protobuf:"bytes,3,rep,name=backend_refs,json=backendRefs,proto3" json:"backend_refs,omitempty"`
	Timeouts    *HTTPRouteTimeouts        `protobuf:"bytes,4,opt,name=timeouts,proto3" json:"timeouts,omitempty"`
	Retries     *HTTPRouteRetries         `protobuf:"bytes,5,opt,name=retries,proto3" json:"retries,omitempty"`
}

func (x *ComputedGRPCRouteRule) Reset() {
	*x = ComputedGRPCRouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedGRPCRouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedGRPCRouteRule) ProtoMessage() {}

func (x *ComputedGRPCRouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedGRPCRouteRule.ProtoReflect.Descriptor instead.
func (*ComputedGRPCRouteRule) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{6}
}

func (x *ComputedGRPCRouteRule) GetMatches() []*GRPCRouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *ComputedGRPCRouteRule) GetFilters() []*GRPCRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *ComputedGRPCRouteRule) GetBackendRefs() []*ComputedGRPCBackendRef {
	if x != nil {
		return x.BackendRefs
	}
	return nil
}

func (x *ComputedGRPCRouteRule) GetTimeouts() *HTTPRouteTimeouts {
	if x != nil {
		return x.Timeouts
	}
	return nil
}

func (x *ComputedGRPCRouteRule) GetRetries() *HTTPRouteRetries {
	if x != nil {
		return x.Retries
	}
	return nil
}

type ComputedGRPCBackendRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BackendTarget indicates which key in the targets map provides
	// the rest of the configuration.
	//
	// If this field is set to the empty string, or is the sentinel value
	// "NULL-ROUTE" is an indication that all of the traffic destined for this
	// backend reference should be null routed in a format appropriate for the
	// protocol (i.e. for HTTP use 5xx).
	BackendTarget string             `protobuf:"bytes,1,opt,name=backend_target,json=backendTarget,proto3" json:"backend_target,omitempty"`
	Weight        uint32             `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	Filters       []*GRPCRouteFilter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (x *ComputedGRPCBackendRef) Reset() {
	*x = ComputedGRPCBackendRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedGRPCBackendRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedGRPCBackendRef) ProtoMessage() {}

func (x *ComputedGRPCBackendRef) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedGRPCBackendRef.ProtoReflect.Descriptor instead.
func (*ComputedGRPCBackendRef) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{7}
}

func (x *ComputedGRPCBackendRef) GetBackendTarget() string {
	if x != nil {
		return x.BackendTarget
	}
	return ""
}

func (x *ComputedGRPCBackendRef) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *ComputedGRPCBackendRef) GetFilters() []*GRPCRouteFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type ComputedTCPRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules []*ComputedTCPRouteRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ComputedTCPRoute) Reset() {
	*x = ComputedTCPRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedTCPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedTCPRoute) ProtoMessage() {}

func (x *ComputedTCPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedTCPRoute.ProtoReflect.Descriptor instead.
func (*ComputedTCPRoute) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{8}
}

func (x *ComputedTCPRoute) GetRules() []*ComputedTCPRouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type ComputedTCPRouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BackendRefs []*ComputedTCPBackendRef `protobuf:"bytes,1,rep,name=backend_refs,json=backendRefs,proto3" json:"backend_refs,omitempty"`
}

func (x *ComputedTCPRouteRule) Reset() {
	*x = ComputedTCPRouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedTCPRouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedTCPRouteRule) ProtoMessage() {}

func (x *ComputedTCPRouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedTCPRouteRule.ProtoReflect.Descriptor instead.
func (*ComputedTCPRouteRule) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{9}
}

func (x *ComputedTCPRouteRule) GetBackendRefs() []*ComputedTCPBackendRef {
	if x != nil {
		return x.BackendRefs
	}
	return nil
}

// TODO: look into smuggling the target through a different typeURL, or just skip in favor of letting the caller do their own lookups?
type ComputedTCPBackendRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BackendTarget indicates which key in the targets map provides
	// the rest of the configuration.
	//
	// If this field is set to the empty string, or is the sentinel value
	// "NULL-ROUTE" is an indication that all of the traffic destined for this
	// backend reference should be null routed in a format appropriate for the
	// protocol (i.e. for HTTP use 5xx).
	BackendTarget string `protobuf:"bytes,1,opt,name=backend_target,json=backendTarget,proto3" json:"backend_target,omitempty"`
	Weight        uint32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (x *ComputedTCPBackendRef) Reset() {
	*x = ComputedTCPBackendRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedTCPBackendRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedTCPBackendRef) ProtoMessage() {}

func (x *ComputedTCPBackendRef) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedTCPBackendRef.ProtoReflect.Descriptor instead.
func (*ComputedTCPBackendRef) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{10}
}

func (x *ComputedTCPBackendRef) GetBackendTarget() string {
	if x != nil {
		return x.BackendTarget
	}
	return ""
}

func (x *ComputedTCPBackendRef) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

type BackendTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type              BackendTargetDetailsType `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.consul.mesh.v2beta1.BackendTargetDetailsType" json:"type,omitempty"`
	BackendRef        *BackendReference        `protobuf:"bytes,2,opt,name=backend_ref,json=backendRef,proto3" json:"backend_ref,omitempty"`
	MeshPort          string                   `protobuf:"bytes,3,opt,name=mesh_port,json=meshPort,proto3" json:"mesh_port,omitempty"`
	FailoverConfig    *ComputedFailoverConfig  `protobuf:"bytes,4,opt,name=failover_config,json=failoverConfig,proto3" json:"failover_config,omitempty"`
	DestinationConfig *DestinationConfig       `protobuf:"bytes,5,opt,name=destination_config,json=destinationConfig,proto3" json:"destination_config,omitempty"`
	// ServiceEndpointsRef is not populated naturally and the field exists only for downstream consumers.
	ServiceEndpointsRef *pbproxystate.EndpointRef `protobuf:"bytes,24,opt,name=service_endpoints_ref,json=serviceEndpointsRef,proto3" json:"service_endpoints_ref,omitempty"`
	// IdentityRefs are not populated naturally and the field exists only for
	// downstream consumers.
	IdentityRefs []*pbresource.Reference `protobuf:"bytes,23,rep,name=identity_refs,json=identityRefs,proto3" json:"identity_refs,omitempty"`
}

func (x *BackendTargetDetails) Reset() {
	*x = BackendTargetDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendTargetDetails) ProtoMessage() {}

func (x *BackendTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendTargetDetails.ProtoReflect.Descriptor instead.
func (*BackendTargetDetails) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{11}
}

func (x *BackendTargetDetails) GetType() BackendTargetDetailsType {
	if x != nil {
		return x.Type
	}
	return BackendTargetDetailsType_BACKEND_TARGET_DETAILS_TYPE_UNSPECIFIED
}

func (x *BackendTargetDetails) GetBackendRef() *BackendReference {
	if x != nil {
		return x.BackendRef
	}
	return nil
}

func (x *BackendTargetDetails) GetMeshPort() string {
	if x != nil {
		return x.MeshPort
	}
	return ""
}

func (x *BackendTargetDetails) GetFailoverConfig() *ComputedFailoverConfig {
	if x != nil {
		return x.FailoverConfig
	}
	return nil
}

func (x *BackendTargetDetails) GetDestinationConfig() *DestinationConfig {
	if x != nil {
		return x.DestinationConfig
	}
	return nil
}

func (x *BackendTargetDetails) GetServiceEndpointsRef() *pbproxystate.EndpointRef {
	if x != nil {
		return x.ServiceEndpointsRef
	}
	return nil
}

func (x *BackendTargetDetails) GetIdentityRefs() []*pbresource.Reference {
	if x != nil {
		return x.IdentityRefs
	}
	return nil
}

type ComputedFailoverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Destinations []*ComputedFailoverDestination `protobuf:"bytes,1,rep,name=destinations,proto3" json:"destinations,omitempty"`
	Mode         v2beta1.FailoverMode           `protobuf:"varint,2,opt,name=mode,proto3,enum=hashicorp.consul.catalog.v2beta1.FailoverMode" json:"mode,omitempty"`
	Regions      []string                       `protobuf:"bytes,3,rep,name=regions,proto3" json:"regions,omitempty"`
	// SamenessGroup specifies the sameness group to failover to.
	SamenessGroup string `protobuf:"bytes,4,opt,name=sameness_group,json=samenessGroup,proto3" json:"sameness_group,omitempty"`
}

func (x *ComputedFailoverConfig) Reset() {
	*x = ComputedFailoverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedFailoverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedFailoverConfig) ProtoMessage() {}

func (x *ComputedFailoverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedFailoverConfig.ProtoReflect.Descriptor instead.
func (*ComputedFailoverConfig) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{12}
}

func (x *ComputedFailoverConfig) GetDestinations() []*ComputedFailoverDestination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *ComputedFailoverConfig) GetMode() v2beta1.FailoverMode {
	if x != nil {
		return x.Mode
	}
	return v2beta1.FailoverMode(0)
}

func (x *ComputedFailoverConfig) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

func (x *ComputedFailoverConfig) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

type ComputedFailoverDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BackendTarget must be a Service.
	BackendTarget string `protobuf:"bytes,1,opt,name=backend_target,json=backendTarget,proto3" json:"backend_target,omitempty"`
}

func (x *ComputedFailoverDestination) Reset() {
	*x = ComputedFailoverDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputedFailoverDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputedFailoverDestination) ProtoMessage() {}

func (x *ComputedFailoverDestination) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_computed_routes_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputedFailoverDestination.ProtoReflect.Descriptor instead.
func (*ComputedFailoverDestination) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP(), []int{13}
}

func (x *ComputedFailoverDestination) GetBackendTarget() string {
	if x != nil {
		return x.BackendTarget
	}
	return ""
}

var File_pbmesh_v2beta1_computed_routes_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_computed_routes_proto_rawDesc = []byte{
	0x0a, 0x24, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x27, 0x70, 0x62, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65,
	0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x70, 0x62, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x70,
	0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x28, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x62, 0x6d,
	0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x70, 0x62, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x70, 0x62, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xc7, 0x02, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x0e, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x50, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x4f,
	0x0a, 0x10, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a,
	0x73, 0x0a, 0x12, 0x50, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x50,
	0x6f, 0x72, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x06, 0xa2, 0x93, 0x04, 0x02, 0x08, 0x03, 0x22, 0x87, 0x05, 0x0a,
	0x12, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x04, 0x68, 0x74, 0x74, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x48, 0x00, 0x52, 0x04, 0x68, 0x74, 0x74, 0x70, 0x12, 0x46, 0x0a, 0x04, 0x67,
	0x72, 0x70, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x64, 0x47, 0x52, 0x50, 0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x48, 0x00, 0x52, 0x04, 0x67,
	0x72, 0x70, 0x63, 0x12, 0x43, 0x0a, 0x03, 0x74, 0x63, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x03, 0x74, 0x63, 0x70, 0x12, 0x30, 0x0a, 0x14, 0x75, 0x73, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x58, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x1a, 0x6f, 0x0a, 0x0c, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x49, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x65, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0x9d, 0x03,
	0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x12, 0x48, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x52, 0x65, 0x66, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xa1, 0x01,
	0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x48, 0x54, 0x54, 0x50, 0x42, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x22, 0x65, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x47, 0x52, 0x50,
	0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x47, 0x52,
	0x50, 0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0x9d, 0x03, 0x0a, 0x15, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x64, 0x47, 0x52, 0x50, 0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x52, 0x50, 0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x07, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x52, 0x50,
	0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x64, 0x47, 0x52, 0x50, 0x43, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52,
	0x65, 0x66, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x73, 0x12,
	0x4c, 0x0a, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x73, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x49, 0x0a,
	0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48,
	0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x64, 0x47, 0x52, 0x50, 0x43, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x52, 0x65, 0x66, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x62, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x52, 0x50, 0x43, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0x5d, 0x0a, 0x10,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x49, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x6f, 0x0a, 0x14, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x72,
	0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x64, 0x54, 0x43, 0x50, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x52,
	0x0b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x73, 0x22, 0x56, 0x0a, 0x15,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x54, 0x43, 0x50, 0x42, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x52, 0x65, 0x66, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x22, 0xd7, 0x04, 0x0a, 0x14, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4b, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x65, 0x66, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x65, 0x73, 0x68, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x65, 0x73, 0x68, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x66, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f,
	0x72, 0x65, 0x66, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52,
	0x65, 0x66, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x66, 0x12, 0x49, 0x0a, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x66, 0x73, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x15, 0x4a, 0x04, 0x08, 0x16, 0x10, 0x17, 0x22, 0xfd,
	0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x0c, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x61, 0x6d, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x73, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x44,
	0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x2a, 0x99, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x2b, 0x0a, 0x27, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x41, 0x52,
	0x47, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x26,
	0x0a, 0x22, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54,
	0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x49,
	0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e,
	0x44, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x02,
	0x42, 0x94, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x6d, 0x65, 0x73, 0x68, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0xa2, 0x02, 0x03, 0x48, 0x43, 0x4d, 0xaa, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68,
	0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68,
	0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xe2, 0x02, 0x29, 0x48, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68,
	0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x20, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a, 0x3a,
	0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_computed_routes_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_computed_routes_proto_rawDescData = file_pbmesh_v2beta1_computed_routes_proto_rawDesc
)

func file_pbmesh_v2beta1_computed_routes_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_computed_routes_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_computed_routes_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_computed_routes_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_computed_routes_proto_rawDescData
}

var file_pbmesh_v2beta1_computed_routes_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pbmesh_v2beta1_computed_routes_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_pbmesh_v2beta1_computed_routes_proto_goTypes = []interface{}{
	(BackendTargetDetailsType)(0),       // 0: hashicorp.consul.mesh.v2beta1.BackendTargetDetailsType
	(*ComputedRoutes)(nil),              // 1: hashicorp.consul.mesh.v2beta1.ComputedRoutes
	(*ComputedPortRoutes)(nil),          // 2: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes
	(*ComputedHTTPRoute)(nil),           // 3: hashicorp.consul.mesh.v2beta1.ComputedHTTPRoute
	(*ComputedHTTPRouteRule)(nil),       // 4: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule
	(*ComputedHTTPBackendRef)(nil),      // 5: hashicorp.consul.mesh.v2beta1.ComputedHTTPBackendRef
	(*ComputedGRPCRoute)(nil),           // 6: hashicorp.consul.mesh.v2beta1.ComputedGRPCRoute
	(*ComputedGRPCRouteRule)(nil),       // 7: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule
	(*ComputedGRPCBackendRef)(nil),      // 8: hashicorp.consul.mesh.v2beta1.ComputedGRPCBackendRef
	(*ComputedTCPRoute)(nil),            // 9: hashicorp.consul.mesh.v2beta1.ComputedTCPRoute
	(*ComputedTCPRouteRule)(nil),        // 10: hashicorp.consul.mesh.v2beta1.ComputedTCPRouteRule
	(*ComputedTCPBackendRef)(nil),       // 11: hashicorp.consul.mesh.v2beta1.ComputedTCPBackendRef
	(*BackendTargetDetails)(nil),        // 12: hashicorp.consul.mesh.v2beta1.BackendTargetDetails
	(*ComputedFailoverConfig)(nil),      // 13: hashicorp.consul.mesh.v2beta1.ComputedFailoverConfig
	(*ComputedFailoverDestination)(nil), // 14: hashicorp.consul.mesh.v2beta1.ComputedFailoverDestination
	nil,                                 // 15: hashicorp.consul.mesh.v2beta1.ComputedRoutes.PortedConfigsEntry
	nil,                                 // 16: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.TargetsEntry
	(*pbresource.Reference)(nil),        // 17: hashicorp.consul.resource.Reference
	(*ParentReference)(nil),             // 18: hashicorp.consul.mesh.v2beta1.ParentReference
	(v2beta1.Protocol)(0),               // 19: hashicorp.consul.catalog.v2beta1.Protocol
	(*HTTPRouteMatch)(nil),              // 20: hashicorp.consul.mesh.v2beta1.HTTPRouteMatch
	(*HTTPRouteFilter)(nil),             // 21: hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	(*HTTPRouteTimeouts)(nil),           // 22: hashicorp.consul.mesh.v2beta1.HTTPRouteTimeouts
	(*HTTPRouteRetries)(nil),            // 23: hashicorp.consul.mesh.v2beta1.HTTPRouteRetries
	(*GRPCRouteMatch)(nil),              // 24: hashicorp.consul.mesh.v2beta1.GRPCRouteMatch
	(*GRPCRouteFilter)(nil),             // 25: hashicorp.consul.mesh.v2beta1.GRPCRouteFilter
	(*BackendReference)(nil),            // 26: hashicorp.consul.mesh.v2beta1.BackendReference
	(*DestinationConfig)(nil),           // 27: hashicorp.consul.mesh.v2beta1.DestinationConfig
	(*pbproxystate.EndpointRef)(nil),    // 28: hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointRef
	(v2beta1.FailoverMode)(0),           // 29: hashicorp.consul.catalog.v2beta1.FailoverMode
}
var file_pbmesh_v2beta1_computed_routes_proto_depIdxs = []int32{
	15, // 0: hashicorp.consul.mesh.v2beta1.ComputedRoutes.ported_configs:type_name -> hashicorp.consul.mesh.v2beta1.ComputedRoutes.PortedConfigsEntry
	17, // 1: hashicorp.consul.mesh.v2beta1.ComputedRoutes.bound_references:type_name -> hashicorp.consul.resource.Reference
	3,  // 2: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.http:type_name -> hashicorp.consul.mesh.v2beta1.ComputedHTTPRoute
	6,  // 3: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.grpc:type_name -> hashicorp.consul.mesh.v2beta1.ComputedGRPCRoute
	9,  // 4: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.tcp:type_name -> hashicorp.consul.mesh.v2beta1.ComputedTCPRoute
	18, // 5: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.parent_ref:type_name -> hashicorp.consul.mesh.v2beta1.ParentReference
	19, // 6: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.protocol:type_name -> hashicorp.consul.catalog.v2beta1.Protocol
	16, // 7: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.targets:type_name -> hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.TargetsEntry
	4,  // 8: hashicorp.consul.mesh.v2beta1.ComputedHTTPRoute.rules:type_name -> hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule
	20, // 9: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule.matches:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteMatch
	21, // 10: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule.filters:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	5,  // 11: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule.backend_refs:type_name -> hashicorp.consul.mesh.v2beta1.ComputedHTTPBackendRef
	22, // 12: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule.timeouts:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteTimeouts
	23, // 13: hashicorp.consul.mesh.v2beta1.ComputedHTTPRouteRule.retries:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteRetries
	21, // 14: hashicorp.consul.mesh.v2beta1.ComputedHTTPBackendRef.filters:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteFilter
	7,  // 15: hashicorp.consul.mesh.v2beta1.ComputedGRPCRoute.rules:type_name -> hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule
	24, // 16: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule.matches:type_name -> hashicorp.consul.mesh.v2beta1.GRPCRouteMatch
	25, // 17: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule.filters:type_name -> hashicorp.consul.mesh.v2beta1.GRPCRouteFilter
	8,  // 18: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule.backend_refs:type_name -> hashicorp.consul.mesh.v2beta1.ComputedGRPCBackendRef
	22, // 19: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule.timeouts:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteTimeouts
	23, // 20: hashicorp.consul.mesh.v2beta1.ComputedGRPCRouteRule.retries:type_name -> hashicorp.consul.mesh.v2beta1.HTTPRouteRetries
	25, // 21: hashicorp.consul.mesh.v2beta1.ComputedGRPCBackendRef.filters:type_name -> hashicorp.consul.mesh.v2beta1.GRPCRouteFilter
	10, // 22: hashicorp.consul.mesh.v2beta1.ComputedTCPRoute.rules:type_name -> hashicorp.consul.mesh.v2beta1.ComputedTCPRouteRule
	11, // 23: hashicorp.consul.mesh.v2beta1.ComputedTCPRouteRule.backend_refs:type_name -> hashicorp.consul.mesh.v2beta1.ComputedTCPBackendRef
	0,  // 24: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.type:type_name -> hashicorp.consul.mesh.v2beta1.BackendTargetDetailsType
	26, // 25: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.backend_ref:type_name -> hashicorp.consul.mesh.v2beta1.BackendReference
	13, // 26: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.failover_config:type_name -> hashicorp.consul.mesh.v2beta1.ComputedFailoverConfig
	27, // 27: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.destination_config:type_name -> hashicorp.consul.mesh.v2beta1.DestinationConfig
	28, // 28: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.service_endpoints_ref:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.EndpointRef
	17, // 29: hashicorp.consul.mesh.v2beta1.BackendTargetDetails.identity_refs:type_name -> hashicorp.consul.resource.Reference
	14, // 30: hashicorp.consul.mesh.v2beta1.ComputedFailoverConfig.destinations:type_name -> hashicorp.consul.mesh.v2beta1.ComputedFailoverDestination
	29, // 31: hashicorp.consul.mesh.v2beta1.ComputedFailoverConfig.mode:type_name -> hashicorp.consul.catalog.v2beta1.FailoverMode
	2,  // 32: hashicorp.consul.mesh.v2beta1.ComputedRoutes.PortedConfigsEntry.value:type_name -> hashicorp.consul.mesh.v2beta1.ComputedPortRoutes
	12, // 33: hashicorp.consul.mesh.v2beta1.ComputedPortRoutes.TargetsEntry.value:type_name -> hashicorp.consul.mesh.v2beta1.BackendTargetDetails
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_computed_routes_proto_init() }
func file_pbmesh_v2beta1_computed_routes_proto_init() {
	if File_pbmesh_v2beta1_computed_routes_proto != nil {
		return
	}
	file_pbmesh_v2beta1_common_proto_init()
	file_pbmesh_v2beta1_destination_policy_proto_init()
	file_pbmesh_v2beta1_grpc_route_proto_init()
	file_pbmesh_v2beta1_http_route_proto_init()
	file_pbmesh_v2beta1_http_route_retries_proto_init()
	file_pbmesh_v2beta1_http_route_timeouts_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedRoutes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedPortRoutes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedHTTPRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedHTTPRouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedHTTPBackendRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedGRPCRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedGRPCRouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedGRPCBackendRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedTCPRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedTCPRouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedTCPBackendRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackendTargetDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedFailoverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_computed_routes_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputedFailoverDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_computed_routes_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ComputedPortRoutes_Http)(nil),
		(*ComputedPortRoutes_Grpc)(nil),
		(*ComputedPortRoutes_Tcp)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_computed_routes_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_computed_routes_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_computed_routes_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_computed_routes_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_computed_routes_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_computed_routes_proto = out.File
	file_pbmesh_v2beta1_computed_routes_proto_rawDesc = nil
	file_pbmesh_v2beta1_computed_routes_proto_goTypes = nil
	file_pbmesh_v2beta1_computed_routes_proto_depIdxs = nil
}
