FIND_PACKAGE(Git)
FIND_PACKAGE(Tar)

IF(NOT VERBOSE)
  SET(ffmpegGitOutput OUTPUT_VARIABLE FFMPEG_GIT_OUTPUT)
  SET(swscaleGitOutput OUTPUT_VARIABLE SWSCALE_GIT_OUTPUT)
ENDIF()

# Checkout FFmpeg source and patch it
IF(NOT EXISTS  "${FFMPEG_SOURCE_DIR}/${FFMPEG_VERSION}")
  MESSAGE(STATUS "Checking out FFmpeg from git repository")
  EXECUTE_PROCESS(COMMAND ${GIT_EXECUTABLE} clone git://git.videolan.org/ffmpeg.git "${FFMPEG_SOURCE_DIR}"
    ${ffmpegGitOutput})
  MESSAGE(STATUS "Going to revision ${FFMPEG_VERSION}")
  EXECUTE_PROCESS(COMMAND ${GIT_EXECUTABLE} checkout tags/n${FFMPEG_VERSION} -b ${FFMPEG_VERSION}
    WORKING_DIRECTORY "${FFMPEG_SOURCE_DIR}"
    ${ffmpegSvnOutput})
  EXECUTE_PROCESS(COMMAND touch "${FFMPEG_SOURCE_DIR}/${FFMPEG_VERSION}")
  MESSAGE(STATUS "Archiving ffmpeg ${FFMPEG_VERSION}")
  MESSAGE(STATUS "${TAR_EXECUTABLE} cjf ${FFMPEG_ROOT_DIR}/${FFMPEG_SOURCE_ARCHIVE} --exclude .git source; DIR=${FFMPEG_BASE_DIR}")
  EXECUTE_PROCESS(COMMAND ${TAR_EXECUTABLE} cjf "${FFMPEG_ROOT_DIR}/${FFMPEG_SOURCE_ARCHIVE}" --exclude .git source
    WORKING_DIRECTORY "${FFMPEG_BASE_DIR}"
    )
  SET(FFMPEG_PERFORM_PATCH 1)
ENDIF()

# Check version
IF(IS_DIRECTORY ${FFMPEG_SOURCE_DIR}/.git)
  admGetRevision(${FFMPEG_SOURCE_DIR} ffmpeg_WC_REVISION)
  MESSAGE(STATUS "Current revision ${ffmpeg_WC_REVISION}")
ENDIF()
MESSAGE("")
