/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Dependency;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Parent;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Repository;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.FileModelSource;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.building.ModelSource;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystem;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.DefaultArtifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RepositoryPolicy;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.resolution.ArtifactRequest;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.resolution.ArtifactResolutionException;

class AntModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final String context;
    private List<RemoteRepository> repositories;
    private final RepositorySystem repoSys;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    AntModelResolver(RepositorySystemSession session, String context, RepositorySystem repoSys, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.context = context;
        this.repoSys = repoSys;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        this.repositoryIds = new HashSet<String>();
    }

    private AntModelResolver(AntModelResolver original) {
        this.session = original.session;
        this.context = original.context;
        this.repoSys = original.repoSys;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = original.repositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(AntModelResolver.convert(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    static RemoteRepository convert(Repository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
        builder.setSnapshotPolicy(AntModelResolver.convert(repository.getSnapshots()));
        builder.setReleasePolicy(AntModelResolver.convert(repository.getReleases()));
        return builder.build();
    }

    private static RepositoryPolicy convert(org.apache.maven.resolver.internal.ant.org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    @Override
    public ModelResolver newCopy() {
        return new AntModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, this.context);
            pomArtifact = this.repoSys.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        this.addRepository(repository);
    }
}

