// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateTCPRequestRuleBackendCreatedCode is the HTTP code returned for type CreateTCPRequestRuleBackendCreated
const CreateTCPRequestRuleBackendCreatedCode int = 201

/*
CreateTCPRequestRuleBackendCreated TCP Request Rule created

swagger:response createTcpRequestRuleBackendCreated
*/
type CreateTCPRequestRuleBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleBackendCreated creates CreateTCPRequestRuleBackendCreated with default headers values
func NewCreateTCPRequestRuleBackendCreated() *CreateTCPRequestRuleBackendCreated {

	return &CreateTCPRequestRuleBackendCreated{}
}

// WithPayload adds the payload to the create Tcp request rule backend created response
func (o *CreateTCPRequestRuleBackendCreated) WithPayload(payload *models.TCPRequestRule) *CreateTCPRequestRuleBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule backend created response
func (o *CreateTCPRequestRuleBackendCreated) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleBackendAcceptedCode is the HTTP code returned for type CreateTCPRequestRuleBackendAccepted
const CreateTCPRequestRuleBackendAcceptedCode int = 202

/*
CreateTCPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response createTcpRequestRuleBackendAccepted
*/
type CreateTCPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleBackendAccepted creates CreateTCPRequestRuleBackendAccepted with default headers values
func NewCreateTCPRequestRuleBackendAccepted() *CreateTCPRequestRuleBackendAccepted {

	return &CreateTCPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Tcp request rule backend accepted response
func (o *CreateTCPRequestRuleBackendAccepted) WithReloadID(reloadID string) *CreateTCPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Tcp request rule backend accepted response
func (o *CreateTCPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Tcp request rule backend accepted response
func (o *CreateTCPRequestRuleBackendAccepted) WithPayload(payload *models.TCPRequestRule) *CreateTCPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule backend accepted response
func (o *CreateTCPRequestRuleBackendAccepted) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleBackendBadRequestCode is the HTTP code returned for type CreateTCPRequestRuleBackendBadRequest
const CreateTCPRequestRuleBackendBadRequestCode int = 400

/*
CreateTCPRequestRuleBackendBadRequest Bad request

swagger:response createTcpRequestRuleBackendBadRequest
*/
type CreateTCPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleBackendBadRequest creates CreateTCPRequestRuleBackendBadRequest with default headers values
func NewCreateTCPRequestRuleBackendBadRequest() *CreateTCPRequestRuleBackendBadRequest {

	return &CreateTCPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp request rule backend bad request response
func (o *CreateTCPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp request rule backend bad request response
func (o *CreateTCPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp request rule backend bad request response
func (o *CreateTCPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *CreateTCPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule backend bad request response
func (o *CreateTCPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPRequestRuleBackendConflictCode is the HTTP code returned for type CreateTCPRequestRuleBackendConflict
const CreateTCPRequestRuleBackendConflictCode int = 409

/*
CreateTCPRequestRuleBackendConflict The specified resource already exists

swagger:response createTcpRequestRuleBackendConflict
*/
type CreateTCPRequestRuleBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleBackendConflict creates CreateTCPRequestRuleBackendConflict with default headers values
func NewCreateTCPRequestRuleBackendConflict() *CreateTCPRequestRuleBackendConflict {

	return &CreateTCPRequestRuleBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp request rule backend conflict response
func (o *CreateTCPRequestRuleBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp request rule backend conflict response
func (o *CreateTCPRequestRuleBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp request rule backend conflict response
func (o *CreateTCPRequestRuleBackendConflict) WithPayload(payload *models.Error) *CreateTCPRequestRuleBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp request rule backend conflict response
func (o *CreateTCPRequestRuleBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateTCPRequestRuleBackendDefault General Error

swagger:response createTcpRequestRuleBackendDefault
*/
type CreateTCPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPRequestRuleBackendDefault creates CreateTCPRequestRuleBackendDefault with default headers values
func NewCreateTCPRequestRuleBackendDefault(code int) *CreateTCPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateTCPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) WithStatusCode(code int) *CreateTCPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateTCPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) WithPayload(payload *models.Error) *CreateTCPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create TCP request rule backend default response
func (o *CreateTCPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
