// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllFilterFrontendOKCode is the HTTP code returned for type ReplaceAllFilterFrontendOK
const ReplaceAllFilterFrontendOKCode int = 200

/*
ReplaceAllFilterFrontendOK All Filter lines replaced

swagger:response replaceAllFilterFrontendOK
*/
type ReplaceAllFilterFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.Filters `json:"body,omitempty"`
}

// NewReplaceAllFilterFrontendOK creates ReplaceAllFilterFrontendOK with default headers values
func NewReplaceAllFilterFrontendOK() *ReplaceAllFilterFrontendOK {

	return &ReplaceAllFilterFrontendOK{}
}

// WithPayload adds the payload to the replace all filter frontend o k response
func (o *ReplaceAllFilterFrontendOK) WithPayload(payload models.Filters) *ReplaceAllFilterFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter frontend o k response
func (o *ReplaceAllFilterFrontendOK) SetPayload(payload models.Filters) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Filters{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllFilterFrontendAcceptedCode is the HTTP code returned for type ReplaceAllFilterFrontendAccepted
const ReplaceAllFilterFrontendAcceptedCode int = 202

/*
ReplaceAllFilterFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllFilterFrontendAccepted
*/
type ReplaceAllFilterFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.Filters `json:"body,omitempty"`
}

// NewReplaceAllFilterFrontendAccepted creates ReplaceAllFilterFrontendAccepted with default headers values
func NewReplaceAllFilterFrontendAccepted() *ReplaceAllFilterFrontendAccepted {

	return &ReplaceAllFilterFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all filter frontend accepted response
func (o *ReplaceAllFilterFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllFilterFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all filter frontend accepted response
func (o *ReplaceAllFilterFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all filter frontend accepted response
func (o *ReplaceAllFilterFrontendAccepted) WithPayload(payload models.Filters) *ReplaceAllFilterFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter frontend accepted response
func (o *ReplaceAllFilterFrontendAccepted) SetPayload(payload models.Filters) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Filters{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllFilterFrontendBadRequestCode is the HTTP code returned for type ReplaceAllFilterFrontendBadRequest
const ReplaceAllFilterFrontendBadRequestCode int = 400

/*
ReplaceAllFilterFrontendBadRequest Bad request

swagger:response replaceAllFilterFrontendBadRequest
*/
type ReplaceAllFilterFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllFilterFrontendBadRequest creates ReplaceAllFilterFrontendBadRequest with default headers values
func NewReplaceAllFilterFrontendBadRequest() *ReplaceAllFilterFrontendBadRequest {

	return &ReplaceAllFilterFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all filter frontend bad request response
func (o *ReplaceAllFilterFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllFilterFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all filter frontend bad request response
func (o *ReplaceAllFilterFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all filter frontend bad request response
func (o *ReplaceAllFilterFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllFilterFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter frontend bad request response
func (o *ReplaceAllFilterFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllFilterFrontendDefault General Error

swagger:response replaceAllFilterFrontendDefault
*/
type ReplaceAllFilterFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllFilterFrontendDefault creates ReplaceAllFilterFrontendDefault with default headers values
func NewReplaceAllFilterFrontendDefault(code int) *ReplaceAllFilterFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllFilterFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) WithStatusCode(code int) *ReplaceAllFilterFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllFilterFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllFilterFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter frontend default response
func (o *ReplaceAllFilterFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
