By default the API calls are limited to 10MB. This should be sufficient for most cases, however if you want to support large imports, this might be limiting you. On the other hand you might want to limit the request size to something smaller than that to prevent API abuse and possible DOS attack, especially if running with limited resources.

To set the limit, you can use the `ROCKET_LIMITS` variable. Example here shows 10MB limit for posted json in the body (this is the default):

```sh
docker run -d --name vaultwarden \
  -e ROCKET_LIMITS={json=10485760} \
  -v /vw-data/:/data/ \
  -p 80:80 \
  vaultwarden/server:latest
```