function serializeUrlNameMap(paramConfigMap) {
  let urlNameMapParts;
  for (const paramName in paramConfigMap) {
    if (paramConfigMap[paramName].urlName) {
      const urlName = paramConfigMap[paramName].urlName;
      const part = `${urlName}\0${paramName}`;
      if (!urlNameMapParts)
        urlNameMapParts = [part];
      else
        urlNameMapParts.push(part);
    }
  }
  return urlNameMapParts ? urlNameMapParts.join("\n") : void 0;
}
function deserializeUrlNameMap(urlNameMapStr) {
  if (!urlNameMapStr)
    return void 0;
  return Object.fromEntries(
    urlNameMapStr.split("\n").map((part) => part.split("\0"))
  );
}
function applyUrlNames(encodedValues, paramConfigMap) {
  var _a;
  let newEncodedValues = {};
  for (const paramName in encodedValues) {
    if (((_a = paramConfigMap[paramName]) == null ? void 0 : _a.urlName) != null) {
      newEncodedValues[paramConfigMap[paramName].urlName] = encodedValues[paramName];
    } else {
      newEncodedValues[paramName] = encodedValues[paramName];
    }
  }
  return newEncodedValues;
}
export {
  applyUrlNames,
  deserializeUrlNameMap,
  serializeUrlNameMap
};
//# sourceMappingURL=urlName.js.map
