/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkRGBA;

public final class Color
extends Resource {
    public GdkRGBA handle;
    int alpha = 0;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue, 255);
        this.init();
    }

    public Color(Device device, int red, int green, int blue, int alpha) {
        super(device);
        this.init(red, green, blue, alpha);
        this.init();
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rgba) {
        super(device);
        if (rgba == null) {
            SWT.error(4);
        }
        this.init(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
        this.init();
    }

    public Color(Device device, RGB rgb, int alpha) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, alpha);
        this.init();
    }

    @Override
    void destroy() {
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        GdkRGBA gdkRGBA = color.handle;
        if (this.handle == gdkRGBA) {
            return true;
        }
        return this.device == color.device && Double.compare(this.handle.red, gdkRGBA.red) == 0 && Double.compare(this.handle.green, gdkRGBA.green) == 0 && Double.compare(this.handle.blue, gdkRGBA.blue) == 0 && Double.compare(this.handle.alpha, gdkRGBA.alpha) == 0;
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle.blue * 255.0) & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle.green * 255.0) & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle.red * 255.0) & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return Double.hashCode(this.handle.red) ^ Double.hashCode(this.handle.green) ^ Double.hashCode(this.handle.blue) ^ Double.hashCode(this.handle.alpha);
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = (int)(gdkRGBA.alpha * 255.0);
        return color;
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA, int alpha) {
        Color color = new Color(device);
        color.handle = gdkRGBA;
        color.alpha = alpha;
        return color;
    }

    void init(int red, int green, int blue, int alpha) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0 || alpha > 255 || alpha < 0) {
            SWT.error(5);
        }
        GdkRGBA rgba = new GdkRGBA();
        rgba.red = (double)red / 255.0;
        rgba.green = (double)green / 255.0;
        rgba.blue = (double)blue / 255.0;
        rgba.alpha = (double)alpha / 255.0;
        this.alpha = alpha;
        this.handle = rgba;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

