/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.protocol.archiveresource;

import com.apple.net.ArchiveResourceURLExploder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ArchiveResourceConnection
extends URLConnection {
    private URL _base;
    private String _member;
    private InputStream _cis;
    private boolean _ciok = true;

    protected ArchiveResourceConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        this._base = ArchiveResourceURLExploder.explodeArchive(uRL);
        this._member = ArchiveResourceURLExploder.explodeResource(uRL);
    }

    public synchronized void connect() throws IOException {
        block11: {
            ZipEntry zipEntry;
            block10: {
                InputStream inputStream;
                if (this.connected) {
                    return;
                }
                this._cis = null;
                if (!this._ciok || !this._base.getProtocol().equals("file")) break block10;
                String string = this._base.getFile();
                ZipFile zipFile = new ZipFile(string);
                ZipEntry zipEntry2 = zipFile.getEntry(this._member);
                if (zipEntry2 != null && (inputStream = zipFile.getInputStream(zipEntry2)) != null) {
                    int n = 0;
                    byte[] byArray = new byte[1024];
                    try {
                        int n2;
                        n = n2 = inputStream.read(byArray);
                        byte[] byArray2 = new byte[4096];
                        while ((n2 = inputStream.read(byArray2)) > 0) {
                            if (n + n2 > byArray.length) {
                                byte[] byArray3 = new byte[n + n2];
                                System.arraycopy(byArray, 0, byArray3, 0, n);
                                byArray = byArray3;
                            }
                            System.arraycopy(byArray2, 0, byArray, n, n2);
                            n += n2;
                        }
                    }
                    catch (IOException iOException) {
                        byArray = null;
                    }
                    if (byArray != null) {
                        if (n < byArray.length) {
                            byte[] byArray4 = new byte[n];
                            System.arraycopy(byArray, 0, byArray4, 0, n);
                            byArray = byArray4;
                        }
                        this._cis = new ByteArrayInputStream(byArray);
                    }
                }
                if (zipFile == null) break block11;
                zipFile.close();
                break block11;
            }
            InputStream inputStream = this._base.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(this._member)) continue;
                this._cis = zipInputStream;
                break;
            }
        }
        if (this._cis == null) {
            throw new IOException("No " + this._member + " resource found in " + this._base);
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this._cis;
    }

    public String getContentType() {
        String string = URLConnection.guessContentTypeFromName(this._member);
        if (string == null) {
            String string2 = this._member;
            int n = string2.lastIndexOf(".");
            if (n >= 0 && n < string2.length() - 1) {
                string2 = string2.substring(n + 1);
            }
            if ((string2 = string2.toLowerCase()).equals("gif")) {
                string = "image/gif";
            } else if (string2.equals("jpeg")) {
                string = "image/jpeg";
            } else if (string2.equals("jpg")) {
                string = "image/jpg";
            } else if (string2.equals("xbm")) {
                string = "image/x-bitmap";
            } else if (string2.equals("xpm")) {
                string = "image/x-pixmap";
            } else if (string2.equals("html") || string2.equals("htm") || string2.equals("asp")) {
                string = "text/html";
            } else if (string2.equals("au") || string2.equals("snd")) {
                string = "audio/basic";
            } else if (string2.equals("wav")) {
                string = "audio/x-wav";
            }
        }
        return string;
    }

    protected void finalize() throws Throwable {
        if (this._cis != null) {
            this._cis.close();
            this._cis = null;
        }
    }
}

