// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/filters.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import date "google.golang.org/genproto/googleapis/type/date"
import latlng "google.golang.org/genproto/googleapis/type/latlng"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Specify whether including telecommute jobs.
type LocationFilter_TelecommutePreference int32

const (
	// Default value if the telecommute preference isn't specified.
	LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED LocationFilter_TelecommutePreference = 0
	// Exclude telecommute jobs.
	LocationFilter_TELECOMMUTE_EXCLUDED LocationFilter_TelecommutePreference = 1
	// Allow telecommute jobs.
	LocationFilter_TELECOMMUTE_ALLOWED LocationFilter_TelecommutePreference = 2
)

var LocationFilter_TelecommutePreference_name = map[int32]string{
	0: "TELECOMMUTE_PREFERENCE_UNSPECIFIED",
	1: "TELECOMMUTE_EXCLUDED",
	2: "TELECOMMUTE_ALLOWED",
}
var LocationFilter_TelecommutePreference_value = map[string]int32{
	"TELECOMMUTE_PREFERENCE_UNSPECIFIED": 0,
	"TELECOMMUTE_EXCLUDED":               1,
	"TELECOMMUTE_ALLOWED":                2,
}

func (x LocationFilter_TelecommutePreference) String() string {
	return proto.EnumName(LocationFilter_TelecommutePreference_name, int32(x))
}
func (LocationFilter_TelecommutePreference) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{2, 0}
}

// Specify the type of filtering.
type CompensationFilter_FilterType int32

const (
	// Filter type unspecified. Position holder, INVALID, should never be used.
	CompensationFilter_FILTER_TYPE_UNSPECIFIED CompensationFilter_FilterType = 0
	// Filter by `base compensation entry's` unit. A job is a match if and
	// only if the job contains a base CompensationEntry and the base
	// CompensationEntry's unit matches provided
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units]. Populate
	// one or more
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	//
	// See
	// [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for definition of base compensation entry.
	CompensationFilter_UNIT_ONLY CompensationFilter_FilterType = 1
	// Filter by `base compensation entry's` unit and amount / range. A job
	// is a match if and only if the job contains a base CompensationEntry, and
	// the base entry's unit matches provided [compensation_units][] and amount
	// or range overlaps with provided [compensation_range][].
	//
	// See
	// [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for definition of base compensation entry.
	//
	// Set exactly one
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units] and
	// populate [range][google.cloud.talent.v4beta1.CompensationFilter.range].
	CompensationFilter_UNIT_AND_AMOUNT CompensationFilter_FilterType = 2
	// Filter by annualized base compensation amount and `base compensation
	// entry's` unit. Populate
	// [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or
	// more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_BASE_AMOUNT CompensationFilter_FilterType = 3
	// Filter by annualized total compensation amount and `base compensation
	// entry's` unit . Populate
	// [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or
	// more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_TOTAL_AMOUNT CompensationFilter_FilterType = 4
)

var CompensationFilter_FilterType_name = map[int32]string{
	0: "FILTER_TYPE_UNSPECIFIED",
	1: "UNIT_ONLY",
	2: "UNIT_AND_AMOUNT",
	3: "ANNUALIZED_BASE_AMOUNT",
	4: "ANNUALIZED_TOTAL_AMOUNT",
}
var CompensationFilter_FilterType_value = map[string]int32{
	"FILTER_TYPE_UNSPECIFIED": 0,
	"UNIT_ONLY":               1,
	"UNIT_AND_AMOUNT":         2,
	"ANNUALIZED_BASE_AMOUNT":  3,
	"ANNUALIZED_TOTAL_AMOUNT": 4,
}

func (x CompensationFilter_FilterType) String() string {
	return proto.EnumName(CompensationFilter_FilterType_name, int32(x))
}
func (CompensationFilter_FilterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{3, 0}
}

// The traffic density to use when calculating commute time.
type CommuteFilter_RoadTraffic int32

const (
	// Road traffic situation isn't specified.
	CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED CommuteFilter_RoadTraffic = 0
	// Optimal commute time without considering any traffic impact.
	CommuteFilter_TRAFFIC_FREE CommuteFilter_RoadTraffic = 1
	// Commute time calculation takes in account the peak traffic impact.
	CommuteFilter_BUSY_HOUR CommuteFilter_RoadTraffic = 2
)

var CommuteFilter_RoadTraffic_name = map[int32]string{
	0: "ROAD_TRAFFIC_UNSPECIFIED",
	1: "TRAFFIC_FREE",
	2: "BUSY_HOUR",
}
var CommuteFilter_RoadTraffic_value = map[string]int32{
	"ROAD_TRAFFIC_UNSPECIFIED": 0,
	"TRAFFIC_FREE":             1,
	"BUSY_HOUR":                2,
}

func (x CommuteFilter_RoadTraffic) String() string {
	return proto.EnumName(CommuteFilter_RoadTraffic_name, int32(x))
}
func (CommuteFilter_RoadTraffic) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{4, 0}
}

// Enum indicating which set of
// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records]
// to search against.
type EmployerFilter_EmployerFilterMode int32

const (
	// Default value.
	EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED EmployerFilter_EmployerFilterMode = 0
	// Apply to all employers in
	// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_ALL_EMPLOYMENT_RECORDS EmployerFilter_EmployerFilterMode = 1
	// Apply only to current employer in
	// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_CURRENT_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 2
	// Apply only to past (not current) employers in
	// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_PAST_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 3
)

var EmployerFilter_EmployerFilterMode_name = map[int32]string{
	0: "EMPLOYER_FILTER_MODE_UNSPECIFIED",
	1: "ALL_EMPLOYMENT_RECORDS",
	2: "CURRENT_EMPLOYMENT_RECORDS_ONLY",
	3: "PAST_EMPLOYMENT_RECORDS_ONLY",
}
var EmployerFilter_EmployerFilterMode_value = map[string]int32{
	"EMPLOYER_FILTER_MODE_UNSPECIFIED": 0,
	"ALL_EMPLOYMENT_RECORDS":           1,
	"CURRENT_EMPLOYMENT_RECORDS_ONLY":  2,
	"PAST_EMPLOYMENT_RECORDS_ONLY":     3,
}

func (x EmployerFilter_EmployerFilterMode) String() string {
	return proto.EnumName(EmployerFilter_EmployerFilterMode_name, int32(x))
}
func (EmployerFilter_EmployerFilterMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{7, 0}
}

// Time fields can be used in TimeFilter.
type TimeFilter_TimeField int32

const (
	// Default value.
	TimeFilter_TIME_FIELD_UNSPECIFIED TimeFilter_TimeField = 0
	// Earliest profile create time.
	TimeFilter_CREATE_TIME TimeFilter_TimeField = 1
	// Latest profile update time.
	TimeFilter_UPDATE_TIME TimeFilter_TimeField = 2
)

var TimeFilter_TimeField_name = map[int32]string{
	0: "TIME_FIELD_UNSPECIFIED",
	1: "CREATE_TIME",
	2: "UPDATE_TIME",
}
var TimeFilter_TimeField_value = map[string]int32{
	"TIME_FIELD_UNSPECIFIED": 0,
	"CREATE_TIME":            1,
	"UPDATE_TIME":            2,
}

func (x TimeFilter_TimeField) String() string {
	return proto.EnumName(TimeFilter_TimeField_name, int32(x))
}
func (TimeFilter_TimeField) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{15, 0}
}

// Input only.
//
// The query required to perform a search query.
type JobQuery struct {
	// Optional.
	//
	// The query string that matches against the job title, description, and
	// location fields.
	//
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Optional.
	//
	// This filter specifies the company entities to search against.
	//
	// If a value isn't specified, jobs are searched for against all
	// companies.
	//
	// If multiple values are specified, jobs are searched against the
	// companies specified.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
	// example, "projects/api-test-project/tenants/foo/companies/bar".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project/companies/bar".
	//
	// At most 20 company filters are allowed.
	Companies []string `protobuf:"bytes,2,rep,name=companies,proto3" json:"companies,omitempty"`
	// Optional.
	//
	// The location filter specifies geo-regions containing the jobs to
	// search against. See
	// [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] for more
	// information.
	//
	// If a location value isn't specified, jobs fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If multiple values are specified, jobs are retrieved from any of the
	// specified locations. If different values are specified for the
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles]
	// parameter, the maximum provided distance is used for all locations.
	//
	// At most 5 location filters are allowed.
	LocationFilters []*LocationFilter `protobuf:"bytes,3,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// Optional.
	//
	// The category filter specifies the categories of jobs to search against.
	// See [Category][] for more information.
	//
	// If a value isn't specified, jobs from any category are searched against.
	//
	// If multiple values are specified, jobs from any of the specified
	// categories are searched against.
	JobCategories []JobCategory `protobuf:"varint,4,rep,packed,name=job_categories,json=jobCategories,proto3,enum=google.cloud.talent.v4beta1.JobCategory" json:"job_categories,omitempty"`
	// Optional.
	//
	//  Allows filtering jobs by commute time with different travel methods (for
	//  example, driving or public transit). Note: This only works with [COMMUTE
	//  MODE][Mode#COMMUTE]. When specified, [JobQuery.location_filters] is
	//  ignored.
	//
	//  Currently we don't support sorting by commute time.
	CommuteFilter *CommuteFilter `protobuf:"bytes,5,opt,name=commute_filter,json=commuteFilter,proto3" json:"commute_filter,omitempty"`
	// Optional.
	//
	// This filter specifies the exact [company display
	// name][Company.display_name] of the jobs to search against.
	//
	// If a value isn't specified, jobs within the search results are
	// associated with any company.
	//
	// If multiple values are specified, jobs within the search results may be
	// associated with any of the specified companies.
	//
	// At most 20 company display name filters are allowed.
	CompanyDisplayNames []string `protobuf:"bytes,6,rep,name=company_display_names,json=companyDisplayNames,proto3" json:"company_display_names,omitempty"`
	// Optional.
	//
	// This search filter is applied only to
	// [Job.compensation_info][google.cloud.talent.v4beta1.Job.compensation_info].
	// For example, if the filter is specified as "Hourly job with per-hour
	// compensation > $15", only jobs meeting these criteria are searched. If a
	// filter isn't defined, all open jobs are searched.
	CompensationFilter *CompensationFilter `protobuf:"bytes,7,opt,name=compensation_filter,json=compensationFilter,proto3" json:"compensation_filter,omitempty"`
	// Optional.
	//
	// This filter specifies a structured syntax to match against the
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
	// marked as `filterable`.
	//
	// The syntax for this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the
	// left of the operator is a custom field key and the right of the operator
	// is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters.
	//
	// Supported functions are `LOWER([field_name])` to
	// perform a case insensitive match and `EMPTY([field_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression
	// must be < 3000 bytes in length.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	CustomAttributeFilter string `protobuf:"bytes,8,opt,name=custom_attribute_filter,json=customAttributeFilter,proto3" json:"custom_attribute_filter,omitempty"`
	// Optional.
	//
	// This flag controls the spell-check feature. If false, the
	// service attempts to correct a misspelled query,
	// for example, "enginee" is corrected to "engineer".
	//
	// Defaults to false: a spell check is performed.
	DisableSpellCheck bool `protobuf:"varint,9,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// Optional.
	//
	// The employment type filter specifies the employment type of jobs to
	// search against, such as
	// [EmploymentType.FULL_TIME][google.cloud.talent.v4beta1.EmploymentType.FULL_TIME].
	//
	// If a value isn't specified, jobs in the search results includes any
	// employment type.
	//
	// If multiple values are specified, jobs in the search results include
	// any of the specified employment types.
	EmploymentTypes []EmploymentType `protobuf:"varint,10,rep,packed,name=employment_types,json=employmentTypes,proto3,enum=google.cloud.talent.v4beta1.EmploymentType" json:"employment_types,omitempty"`
	// Optional.
	//
	// This filter specifies the locale of jobs to search against,
	// for example, "en-US".
	//
	// If a value isn't specified, the search results can contain jobs in any
	// locale.
	//
	//
	// Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	//
	// At most 10 language code filters are allowed.
	LanguageCodes []string `protobuf:"bytes,11,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Optional.
	//
	// Jobs published within a range specified by this filter are searched
	// against.
	PublishTimeRange *TimestampRange `protobuf:"bytes,12,opt,name=publish_time_range,json=publishTimeRange,proto3" json:"publish_time_range,omitempty"`
	// Optional.
	//
	// This filter specifies a list of job names to be excluded during search.
	//
	// At most 200 excluded job names are allowed.
	ExcludedJobs         []string `protobuf:"bytes,13,rep,name=excluded_jobs,json=excludedJobs,proto3" json:"excluded_jobs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobQuery) Reset()         { *m = JobQuery{} }
func (m *JobQuery) String() string { return proto.CompactTextString(m) }
func (*JobQuery) ProtoMessage()    {}
func (*JobQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{0}
}
func (m *JobQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobQuery.Unmarshal(m, b)
}
func (m *JobQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobQuery.Marshal(b, m, deterministic)
}
func (dst *JobQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobQuery.Merge(dst, src)
}
func (m *JobQuery) XXX_Size() int {
	return xxx_messageInfo_JobQuery.Size(m)
}
func (m *JobQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_JobQuery.DiscardUnknown(m)
}

var xxx_messageInfo_JobQuery proto.InternalMessageInfo

func (m *JobQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *JobQuery) GetCompanies() []string {
	if m != nil {
		return m.Companies
	}
	return nil
}

func (m *JobQuery) GetLocationFilters() []*LocationFilter {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *JobQuery) GetJobCategories() []JobCategory {
	if m != nil {
		return m.JobCategories
	}
	return nil
}

func (m *JobQuery) GetCommuteFilter() *CommuteFilter {
	if m != nil {
		return m.CommuteFilter
	}
	return nil
}

func (m *JobQuery) GetCompanyDisplayNames() []string {
	if m != nil {
		return m.CompanyDisplayNames
	}
	return nil
}

func (m *JobQuery) GetCompensationFilter() *CompensationFilter {
	if m != nil {
		return m.CompensationFilter
	}
	return nil
}

func (m *JobQuery) GetCustomAttributeFilter() string {
	if m != nil {
		return m.CustomAttributeFilter
	}
	return ""
}

func (m *JobQuery) GetDisableSpellCheck() bool {
	if m != nil {
		return m.DisableSpellCheck
	}
	return false
}

func (m *JobQuery) GetEmploymentTypes() []EmploymentType {
	if m != nil {
		return m.EmploymentTypes
	}
	return nil
}

func (m *JobQuery) GetLanguageCodes() []string {
	if m != nil {
		return m.LanguageCodes
	}
	return nil
}

func (m *JobQuery) GetPublishTimeRange() *TimestampRange {
	if m != nil {
		return m.PublishTimeRange
	}
	return nil
}

func (m *JobQuery) GetExcludedJobs() []string {
	if m != nil {
		return m.ExcludedJobs
	}
	return nil
}

// Filters to apply when performing the search query.
type ProfileQuery struct {
	// Optional.
	//
	// Keywords to match any text fields of profiles.
	//
	// For example, "software engineer in Palo Alto".
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Optional.
	//
	// The location filter specifies geo-regions containing the profiles to
	// search against.
	//
	// If a location filter isn't specified, profiles fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If
	// [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated]
	// is specified, the result doesn't contain profiles from that location.
	//
	// For example, search for profiles with addresses in "New York City".
	LocationFilters []*LocationFilter `protobuf:"bytes,2,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// Optional.
	//
	// Job title filter specifies job titles of profiles to match on.
	//
	// If a job title isn't specified, profiles with any titles are retrieved.
	//
	// If multiple values are specified, profiles are retrieved with any of the
	// specified job titles.
	//
	// If
	// [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated]
	// is specified, the result won't contain profiles with the job titles.
	//
	// For example, search for profiles with a job title "Product Manager".
	JobTitleFilters []*JobTitleFilter `protobuf:"bytes,3,rep,name=job_title_filters,json=jobTitleFilters,proto3" json:"job_title_filters,omitempty"`
	// Optional.
	//
	// Employer filter specifies employers of profiles to match on.
	//
	// If an employer filter isn't specified, profiles with any employers are
	// retrieved.
	//
	// If multiple employer filters are specified, profiles with any matching
	// employers are retrieved.
	//
	// If
	// [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated]
	// is specified, the result won't contain profiles that match the employers.
	//
	// For example, search for profiles that have working experience at "Google
	// LLC".
	EmployerFilters []*EmployerFilter `protobuf:"bytes,4,rep,name=employer_filters,json=employerFilters,proto3" json:"employer_filters,omitempty"`
	// Optional.
	//
	// Education filter specifies education of profiles to match on.
	//
	// If an education filter isn't specified, profiles with any education are
	// retrieved.
	//
	// If multiple education filters are specified, profiles that match any
	// education filters are retrieved.
	//
	// If
	// [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated]
	// is specified, the result won't contain profiles that match the educations.
	//
	// For example, search for profiles with a master degree.
	EducationFilters []*EducationFilter `protobuf:"bytes,5,rep,name=education_filters,json=educationFilters,proto3" json:"education_filters,omitempty"`
	// Optional.
	//
	// Skill filter specifies skill of profiles to match on.
	//
	// If a skill filter isn't specified, profiles with any skills are retrieved.
	//
	// If multiple skill filters are specified, profiles that match any skill
	// filters are retrieved.
	//
	// If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated]
	// is specified, the result won't contain profiles that match the skills.
	//
	// For example, search for profiles that have "Java" and "Python" in skill
	// list.
	SkillFilters []*SkillFilter `protobuf:"bytes,6,rep,name=skill_filters,json=skillFilters,proto3" json:"skill_filters,omitempty"`
	// Optional.
	//
	// Work experience filter specifies the total working experience of profiles
	// to match on.
	//
	// If a work experience filter isn't specified, profiles with any
	// professional experience are retrieved.
	//
	// If multiple work experience filters are specified, profiles that match any
	// work experience filters are retrieved.
	//
	// For example, search for profiles with 10 years of work experience.
	WorkExperienceFilter []*WorkExperienceFilter `protobuf:"bytes,7,rep,name=work_experience_filter,json=workExperienceFilter,proto3" json:"work_experience_filter,omitempty"`
	// Optional.
	//
	// Time filter specifies the create/update timestamp of the profiles to match
	// on.
	//
	// For example, search for profiles created since "2018-1-1".
	TimeFilters []*TimeFilter `protobuf:"bytes,8,rep,name=time_filters,json=timeFilters,proto3" json:"time_filters,omitempty"`
	// Optional.
	//
	// The hirable filter specifies the profile's hirable status to match on.
	HirableFilter *wrappers.BoolValue `protobuf:"bytes,9,opt,name=hirable_filter,json=hirableFilter,proto3" json:"hirable_filter,omitempty"`
	// Optional.
	//
	// The application date filters specify application date ranges to match on.
	ApplicationDateFilters []*ApplicationDateFilter `protobuf:"bytes,10,rep,name=application_date_filters,json=applicationDateFilters,proto3" json:"application_date_filters,omitempty"`
	// Optional.
	//
	// The application outcome notes filters specify the notes for the outcome of
	// the job application.
	ApplicationOutcomeNotesFilters []*ApplicationOutcomeNotesFilter `protobuf:"bytes,11,rep,name=application_outcome_notes_filters,json=applicationOutcomeNotesFilters,proto3" json:"application_outcome_notes_filters,omitempty"`
	// Optional.
	//
	// The application last stage filters specify the last stage of job
	// application.
	ApplicationLastStageFilters []*ApplicationLastStageFilter `protobuf:"bytes,12,rep,name=application_last_stage_filters,json=applicationLastStageFilters,proto3" json:"application_last_stage_filters,omitempty"`
	// Optional.
	//
	// The application job filters specify the job applied for in the application.
	ApplicationJobFilters []*ApplicationJobFilter `protobuf:"bytes,13,rep,name=application_job_filters,json=applicationJobFilters,proto3" json:"application_job_filters,omitempty"`
	// Optional.
	//
	// The application status filters specify the status of job application.
	ApplicationStatusFilters []*ApplicationStatusFilter `protobuf:"bytes,14,rep,name=application_status_filters,json=applicationStatusFilters,proto3" json:"application_status_filters,omitempty"`
	// Optional.
	//
	// This filter specifies a structured syntax to match against the
	// [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes]
	// that are marked as `filterable`.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// String custom attributes: supported operators are =, != where the left of
	// the operator is a custom field key and the right of the operator is a
	// string (surrounded by quotes) value.
	//
	// Numeric custom attributes: Supported operators are '>', '<' or '='
	// operators where the left of the operator is a custom field key and the
	// right of the operator is a numeric value.
	//
	// Supported functions are LOWER(<field_name>) to
	// perform case insensitive match and EMPTY(<field_name>) to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
	// a maximum of 50 comparisons/functions in the expression. The expression
	// must be < 2000 characters in length.
	//
	// Sample Query:
	// (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
	CustomFieldFilter    string   `protobuf:"bytes,15,opt,name=custom_field_filter,json=customFieldFilter,proto3" json:"custom_field_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProfileQuery) Reset()         { *m = ProfileQuery{} }
func (m *ProfileQuery) String() string { return proto.CompactTextString(m) }
func (*ProfileQuery) ProtoMessage()    {}
func (*ProfileQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{1}
}
func (m *ProfileQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProfileQuery.Unmarshal(m, b)
}
func (m *ProfileQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProfileQuery.Marshal(b, m, deterministic)
}
func (dst *ProfileQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileQuery.Merge(dst, src)
}
func (m *ProfileQuery) XXX_Size() int {
	return xxx_messageInfo_ProfileQuery.Size(m)
}
func (m *ProfileQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileQuery proto.InternalMessageInfo

func (m *ProfileQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *ProfileQuery) GetLocationFilters() []*LocationFilter {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *ProfileQuery) GetJobTitleFilters() []*JobTitleFilter {
	if m != nil {
		return m.JobTitleFilters
	}
	return nil
}

func (m *ProfileQuery) GetEmployerFilters() []*EmployerFilter {
	if m != nil {
		return m.EmployerFilters
	}
	return nil
}

func (m *ProfileQuery) GetEducationFilters() []*EducationFilter {
	if m != nil {
		return m.EducationFilters
	}
	return nil
}

func (m *ProfileQuery) GetSkillFilters() []*SkillFilter {
	if m != nil {
		return m.SkillFilters
	}
	return nil
}

func (m *ProfileQuery) GetWorkExperienceFilter() []*WorkExperienceFilter {
	if m != nil {
		return m.WorkExperienceFilter
	}
	return nil
}

func (m *ProfileQuery) GetTimeFilters() []*TimeFilter {
	if m != nil {
		return m.TimeFilters
	}
	return nil
}

func (m *ProfileQuery) GetHirableFilter() *wrappers.BoolValue {
	if m != nil {
		return m.HirableFilter
	}
	return nil
}

func (m *ProfileQuery) GetApplicationDateFilters() []*ApplicationDateFilter {
	if m != nil {
		return m.ApplicationDateFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationOutcomeNotesFilters() []*ApplicationOutcomeNotesFilter {
	if m != nil {
		return m.ApplicationOutcomeNotesFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationLastStageFilters() []*ApplicationLastStageFilter {
	if m != nil {
		return m.ApplicationLastStageFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationJobFilters() []*ApplicationJobFilter {
	if m != nil {
		return m.ApplicationJobFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationStatusFilters() []*ApplicationStatusFilter {
	if m != nil {
		return m.ApplicationStatusFilters
	}
	return nil
}

func (m *ProfileQuery) GetCustomFieldFilter() string {
	if m != nil {
		return m.CustomFieldFilter
	}
	return ""
}

// Input only.
//
// Geographic region of the search.
type LocationFilter struct {
	// Optional.
	//
	// The address name, such as "Mountain View" or "Bay Area".
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Optional.
	//
	// CLDR region code of the country/region of the address. This is used
	// to address ambiguity of the user-input location, for example, "Liverpool"
	// against "Liverpool, NY, US" or "Liverpool, UK".
	//
	// Set this field if all the jobs to search against are from a same region,
	// or jobs are world-wide, but the job seeker is from a specific region.
	//
	// See http://cldr.unicode.org/ and
	// http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional.
	//
	// The latitude and longitude of the geographic center from which to
	// search. This field's ignored if `address` is provided.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// Optional.
	//
	//
	// The distance_in_miles is applied when the location being searched for is
	// identified as a city or smaller. When the location being searched for is a
	// state or larger, this field is ignored.
	DistanceInMiles float64 `protobuf:"fixed64,4,opt,name=distance_in_miles,json=distanceInMiles,proto3" json:"distance_in_miles,omitempty"`
	// Optional.
	//
	// Allows the client to return jobs without a
	// set location, specifically, telecommuting jobs (telecomuting is considered
	// by the service as a special location.
	// [Job.posting_region][google.cloud.talent.v4beta1.Job.posting_region]
	// indicates if a job permits telecommuting. If this field is set to
	// [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
	// telecommuting jobs are searched, and
	// [address][google.cloud.talent.v4beta1.LocationFilter.address] and
	// [lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are ignored.
	// If not set or set to
	// [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
	// telecommute job are not searched.
	//
	// This filter can be used by itself to search exclusively for telecommuting
	// jobs, or it can be combined with another location
	// filter to search for a combination of job locations,
	// such as "Mountain View" or "telecommuting" jobs. However, when used in
	// combination with other location filters, telecommuting jobs can be
	// treated as less relevant than other jobs in the search response.
	TelecommutePreference LocationFilter_TelecommutePreference `protobuf:"varint,5,opt,name=telecommute_preference,json=telecommutePreference,proto3,enum=google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference" json:"telecommute_preference,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	//
	// Currently only supported in profile search.
	Negated              bool     `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocationFilter) Reset()         { *m = LocationFilter{} }
func (m *LocationFilter) String() string { return proto.CompactTextString(m) }
func (*LocationFilter) ProtoMessage()    {}
func (*LocationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{2}
}
func (m *LocationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationFilter.Unmarshal(m, b)
}
func (m *LocationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationFilter.Marshal(b, m, deterministic)
}
func (dst *LocationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationFilter.Merge(dst, src)
}
func (m *LocationFilter) XXX_Size() int {
	return xxx_messageInfo_LocationFilter.Size(m)
}
func (m *LocationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_LocationFilter proto.InternalMessageInfo

func (m *LocationFilter) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *LocationFilter) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

func (m *LocationFilter) GetLatLng() *latlng.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

func (m *LocationFilter) GetDistanceInMiles() float64 {
	if m != nil {
		return m.DistanceInMiles
	}
	return 0
}

func (m *LocationFilter) GetTelecommutePreference() LocationFilter_TelecommutePreference {
	if m != nil {
		return m.TelecommutePreference
	}
	return LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED
}

func (m *LocationFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on job compensation type and amount.
type CompensationFilter struct {
	// Required.
	//
	// Type of filter.
	Type CompensationFilter_FilterType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompensationFilter_FilterType" json:"type,omitempty"`
	// Required.
	//
	// Specify desired `base compensation entry's`
	// [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit].
	Units []CompensationInfo_CompensationUnit `protobuf:"varint,2,rep,packed,name=units,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit" json:"units,omitempty"`
	// Optional.
	//
	// Compensation range.
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// Optional.
	//
	// Whether to include jobs whose compensation range is unspecified.
	IncludeJobsWithUnspecifiedCompensationRange bool     `protobuf:"varint,4,opt,name=include_jobs_with_unspecified_compensation_range,json=includeJobsWithUnspecifiedCompensationRange,proto3" json:"include_jobs_with_unspecified_compensation_range,omitempty"`
	XXX_NoUnkeyedLiteral                        struct{} `json:"-"`
	XXX_unrecognized                            []byte   `json:"-"`
	XXX_sizecache                               int32    `json:"-"`
}

func (m *CompensationFilter) Reset()         { *m = CompensationFilter{} }
func (m *CompensationFilter) String() string { return proto.CompactTextString(m) }
func (*CompensationFilter) ProtoMessage()    {}
func (*CompensationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{3}
}
func (m *CompensationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompensationFilter.Unmarshal(m, b)
}
func (m *CompensationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompensationFilter.Marshal(b, m, deterministic)
}
func (dst *CompensationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompensationFilter.Merge(dst, src)
}
func (m *CompensationFilter) XXX_Size() int {
	return xxx_messageInfo_CompensationFilter.Size(m)
}
func (m *CompensationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CompensationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CompensationFilter proto.InternalMessageInfo

func (m *CompensationFilter) GetType() CompensationFilter_FilterType {
	if m != nil {
		return m.Type
	}
	return CompensationFilter_FILTER_TYPE_UNSPECIFIED
}

func (m *CompensationFilter) GetUnits() []CompensationInfo_CompensationUnit {
	if m != nil {
		return m.Units
	}
	return nil
}

func (m *CompensationFilter) GetRange() *CompensationInfo_CompensationRange {
	if m != nil {
		return m.Range
	}
	return nil
}

func (m *CompensationFilter) GetIncludeJobsWithUnspecifiedCompensationRange() bool {
	if m != nil {
		return m.IncludeJobsWithUnspecifiedCompensationRange
	}
	return false
}

// Input only.
//
// Parameters needed for commute search.
type CommuteFilter struct {
	// Required.
	//
	// The method of transportation for which to calculate the commute time.
	CommuteMethod CommuteMethod `protobuf:"varint,1,opt,name=commute_method,json=commuteMethod,proto3,enum=google.cloud.talent.v4beta1.CommuteMethod" json:"commute_method,omitempty"`
	// Required.
	//
	// The latitude and longitude of the location from which to calculate the
	// commute time.
	StartCoordinates *latlng.LatLng `protobuf:"bytes,2,opt,name=start_coordinates,json=startCoordinates,proto3" json:"start_coordinates,omitempty"`
	// Required.
	//
	// The maximum travel time in seconds. The maximum allowed value is `3600s`
	// (one hour). Format is `123s`.
	TravelDuration *duration.Duration `protobuf:"bytes,3,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// Optional.
	// If `true`, jobs without street level addresses may also be returned.
	// For city level addresses, the city center is used. For state and coarser
	// level addresses, text matching is used.
	// If this field is set to `false` or isn't specified, only jobs that include
	// street level addresses will be returned by commute search.
	AllowImpreciseAddresses bool `protobuf:"varint,4,opt,name=allow_imprecise_addresses,json=allowImpreciseAddresses,proto3" json:"allow_imprecise_addresses,omitempty"`
	// Optional.
	//
	// Traffic factor to take into account while searching by commute.
	//
	// Types that are valid to be assigned to TrafficOption:
	//	*CommuteFilter_RoadTraffic_
	//	*CommuteFilter_DepartureTime
	TrafficOption        isCommuteFilter_TrafficOption `protobuf_oneof:"traffic_option"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *CommuteFilter) Reset()         { *m = CommuteFilter{} }
func (m *CommuteFilter) String() string { return proto.CompactTextString(m) }
func (*CommuteFilter) ProtoMessage()    {}
func (*CommuteFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{4}
}
func (m *CommuteFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommuteFilter.Unmarshal(m, b)
}
func (m *CommuteFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommuteFilter.Marshal(b, m, deterministic)
}
func (dst *CommuteFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommuteFilter.Merge(dst, src)
}
func (m *CommuteFilter) XXX_Size() int {
	return xxx_messageInfo_CommuteFilter.Size(m)
}
func (m *CommuteFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CommuteFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CommuteFilter proto.InternalMessageInfo

func (m *CommuteFilter) GetCommuteMethod() CommuteMethod {
	if m != nil {
		return m.CommuteMethod
	}
	return CommuteMethod_COMMUTE_METHOD_UNSPECIFIED
}

func (m *CommuteFilter) GetStartCoordinates() *latlng.LatLng {
	if m != nil {
		return m.StartCoordinates
	}
	return nil
}

func (m *CommuteFilter) GetTravelDuration() *duration.Duration {
	if m != nil {
		return m.TravelDuration
	}
	return nil
}

func (m *CommuteFilter) GetAllowImpreciseAddresses() bool {
	if m != nil {
		return m.AllowImpreciseAddresses
	}
	return false
}

type isCommuteFilter_TrafficOption interface {
	isCommuteFilter_TrafficOption()
}

type CommuteFilter_RoadTraffic_ struct {
	RoadTraffic CommuteFilter_RoadTraffic `protobuf:"varint,5,opt,name=road_traffic,json=roadTraffic,proto3,enum=google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic,oneof"`
}

type CommuteFilter_DepartureTime struct {
	DepartureTime *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=departure_time,json=departureTime,proto3,oneof"`
}

func (*CommuteFilter_RoadTraffic_) isCommuteFilter_TrafficOption() {}

func (*CommuteFilter_DepartureTime) isCommuteFilter_TrafficOption() {}

func (m *CommuteFilter) GetTrafficOption() isCommuteFilter_TrafficOption {
	if m != nil {
		return m.TrafficOption
	}
	return nil
}

func (m *CommuteFilter) GetRoadTraffic() CommuteFilter_RoadTraffic {
	if x, ok := m.GetTrafficOption().(*CommuteFilter_RoadTraffic_); ok {
		return x.RoadTraffic
	}
	return CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED
}

func (m *CommuteFilter) GetDepartureTime() *timeofday.TimeOfDay {
	if x, ok := m.GetTrafficOption().(*CommuteFilter_DepartureTime); ok {
		return x.DepartureTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommuteFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommuteFilter_OneofMarshaler, _CommuteFilter_OneofUnmarshaler, _CommuteFilter_OneofSizer, []interface{}{
		(*CommuteFilter_RoadTraffic_)(nil),
		(*CommuteFilter_DepartureTime)(nil),
	}
}

func _CommuteFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommuteFilter)
	// traffic_option
	switch x := m.TrafficOption.(type) {
	case *CommuteFilter_RoadTraffic_:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RoadTraffic))
	case *CommuteFilter_DepartureTime:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DepartureTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommuteFilter.TrafficOption has unexpected type %T", x)
	}
	return nil
}

func _CommuteFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommuteFilter)
	switch tag {
	case 5: // traffic_option.road_traffic
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TrafficOption = &CommuteFilter_RoadTraffic_{CommuteFilter_RoadTraffic(x)}
		return true, err
	case 6: // traffic_option.departure_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(timeofday.TimeOfDay)
		err := b.DecodeMessage(msg)
		m.TrafficOption = &CommuteFilter_DepartureTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommuteFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommuteFilter)
	// traffic_option
	switch x := m.TrafficOption.(type) {
	case *CommuteFilter_RoadTraffic_:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.RoadTraffic))
	case *CommuteFilter_DepartureTime:
		s := proto.Size(x.DepartureTime)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Input only.
//
// Job title of the search.
type JobTitleFilter struct {
	// Required.
	//
	// The job title, for example, "Software engineer", or "Product manager".
	JobTitle string `protobuf:"bytes,1,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobTitleFilter) Reset()         { *m = JobTitleFilter{} }
func (m *JobTitleFilter) String() string { return proto.CompactTextString(m) }
func (*JobTitleFilter) ProtoMessage()    {}
func (*JobTitleFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{5}
}
func (m *JobTitleFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobTitleFilter.Unmarshal(m, b)
}
func (m *JobTitleFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobTitleFilter.Marshal(b, m, deterministic)
}
func (dst *JobTitleFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobTitleFilter.Merge(dst, src)
}
func (m *JobTitleFilter) XXX_Size() int {
	return xxx_messageInfo_JobTitleFilter.Size(m)
}
func (m *JobTitleFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_JobTitleFilter.DiscardUnknown(m)
}

var xxx_messageInfo_JobTitleFilter proto.InternalMessageInfo

func (m *JobTitleFilter) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *JobTitleFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Skill filter of the search.
type SkillFilter struct {
	// Required.
	//
	// The skill name. For example, "java", "j2ee", etc.
	Skill string `protobuf:"bytes,1,opt,name=skill,proto3" json:"skill,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SkillFilter) Reset()         { *m = SkillFilter{} }
func (m *SkillFilter) String() string { return proto.CompactTextString(m) }
func (*SkillFilter) ProtoMessage()    {}
func (*SkillFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{6}
}
func (m *SkillFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SkillFilter.Unmarshal(m, b)
}
func (m *SkillFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SkillFilter.Marshal(b, m, deterministic)
}
func (dst *SkillFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SkillFilter.Merge(dst, src)
}
func (m *SkillFilter) XXX_Size() int {
	return xxx_messageInfo_SkillFilter.Size(m)
}
func (m *SkillFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_SkillFilter.DiscardUnknown(m)
}

var xxx_messageInfo_SkillFilter proto.InternalMessageInfo

func (m *SkillFilter) GetSkill() string {
	if m != nil {
		return m.Skill
	}
	return ""
}

func (m *SkillFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Employer filter of the search.
type EmployerFilter struct {
	// Required.
	//
	// The name of the employer, for example "Google", "Alphabet".
	Employer string `protobuf:"bytes,1,opt,name=employer,proto3" json:"employer,omitempty"`
	// Optional.
	//
	// Define set of
	// [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord]s to search
	// against.
	//
	// Defaults to
	// [EmployerFilterMode.ALL_EMPLOYMENT_RECORDS][google.cloud.talent.v4beta1.EmployerFilter.EmployerFilterMode.ALL_EMPLOYMENT_RECORDS].
	Mode EmployerFilter_EmployerFilterMode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.cloud.talent.v4beta1.EmployerFilter_EmployerFilterMode" json:"mode,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated              bool     `protobuf:"varint,3,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmployerFilter) Reset()         { *m = EmployerFilter{} }
func (m *EmployerFilter) String() string { return proto.CompactTextString(m) }
func (*EmployerFilter) ProtoMessage()    {}
func (*EmployerFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{7}
}
func (m *EmployerFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmployerFilter.Unmarshal(m, b)
}
func (m *EmployerFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmployerFilter.Marshal(b, m, deterministic)
}
func (dst *EmployerFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmployerFilter.Merge(dst, src)
}
func (m *EmployerFilter) XXX_Size() int {
	return xxx_messageInfo_EmployerFilter.Size(m)
}
func (m *EmployerFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EmployerFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EmployerFilter proto.InternalMessageInfo

func (m *EmployerFilter) GetEmployer() string {
	if m != nil {
		return m.Employer
	}
	return ""
}

func (m *EmployerFilter) GetMode() EmployerFilter_EmployerFilterMode {
	if m != nil {
		return m.Mode
	}
	return EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED
}

func (m *EmployerFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Education filter of the search.
type EducationFilter struct {
	// Optional.
	//
	// The school name. For example "MIT", "University of California, Berkeley".
	School string `protobuf:"bytes,1,opt,name=school,proto3" json:"school,omitempty"`
	// Optional.
	//
	// The field of study. This is to search against value provided in
	// [Degree.fields_of_study][google.cloud.talent.v4beta1.Degree.fields_of_study].
	// For example "Computer Science", "Mathematics".
	FieldOfStudy string `protobuf:"bytes,2,opt,name=field_of_study,json=fieldOfStudy,proto3" json:"field_of_study,omitempty"`
	// Optional.
	//
	// Education degree in ISCED code. Each value in degree covers a specific
	// level of education, without any expansion to upper nor lower levels of
	// education degree.
	DegreeType DegreeType `protobuf:"varint,3,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated              bool     `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EducationFilter) Reset()         { *m = EducationFilter{} }
func (m *EducationFilter) String() string { return proto.CompactTextString(m) }
func (*EducationFilter) ProtoMessage()    {}
func (*EducationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{8}
}
func (m *EducationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EducationFilter.Unmarshal(m, b)
}
func (m *EducationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EducationFilter.Marshal(b, m, deterministic)
}
func (dst *EducationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EducationFilter.Merge(dst, src)
}
func (m *EducationFilter) XXX_Size() int {
	return xxx_messageInfo_EducationFilter.Size(m)
}
func (m *EducationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EducationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EducationFilter proto.InternalMessageInfo

func (m *EducationFilter) GetSchool() string {
	if m != nil {
		return m.School
	}
	return ""
}

func (m *EducationFilter) GetFieldOfStudy() string {
	if m != nil {
		return m.FieldOfStudy
	}
	return ""
}

func (m *EducationFilter) GetDegreeType() DegreeType {
	if m != nil {
		return m.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (m *EducationFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Work experience filter.
//
// This filter is used to search for profiles with working experience length
// between
// [min_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.min_experience]
// and
// [max_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.max_experience].
type WorkExperienceFilter struct {
	// Optional.
	//
	// The minimum duration of the work experience (inclusive).
	MinExperience *duration.Duration `protobuf:"bytes,1,opt,name=min_experience,json=minExperience,proto3" json:"min_experience,omitempty"`
	// Optional.
	//
	// The maximum duration of the work experience (exclusive).
	MaxExperience        *duration.Duration `protobuf:"bytes,2,opt,name=max_experience,json=maxExperience,proto3" json:"max_experience,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *WorkExperienceFilter) Reset()         { *m = WorkExperienceFilter{} }
func (m *WorkExperienceFilter) String() string { return proto.CompactTextString(m) }
func (*WorkExperienceFilter) ProtoMessage()    {}
func (*WorkExperienceFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{9}
}
func (m *WorkExperienceFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkExperienceFilter.Unmarshal(m, b)
}
func (m *WorkExperienceFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkExperienceFilter.Marshal(b, m, deterministic)
}
func (dst *WorkExperienceFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkExperienceFilter.Merge(dst, src)
}
func (m *WorkExperienceFilter) XXX_Size() int {
	return xxx_messageInfo_WorkExperienceFilter.Size(m)
}
func (m *WorkExperienceFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkExperienceFilter.DiscardUnknown(m)
}

var xxx_messageInfo_WorkExperienceFilter proto.InternalMessageInfo

func (m *WorkExperienceFilter) GetMinExperience() *duration.Duration {
	if m != nil {
		return m.MinExperience
	}
	return nil
}

func (m *WorkExperienceFilter) GetMaxExperience() *duration.Duration {
	if m != nil {
		return m.MaxExperience
	}
	return nil
}

// Input only.
//
// Application Date Range Filter.
//
// The API matches profiles with
// [Application.application_date][google.cloud.talent.v4beta1.Application.application_date]
// between start date and end date (both boundaries are inclusive). The filter
// is ignored if both
// [start_date][google.cloud.talent.v4beta1.ApplicationDateFilter.start_date]
// and [end_date][google.cloud.talent.v4beta1.ApplicationDateFilter.end_date]
// are missing.
type ApplicationDateFilter struct {
	// Optional.
	//
	// Start date. If it's missing, The API matches profiles with application date
	// not after the end date.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional.
	//
	// End date. If it's missing, The API matches profiles with application date
	// not before the start date.
	EndDate              *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ApplicationDateFilter) Reset()         { *m = ApplicationDateFilter{} }
func (m *ApplicationDateFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationDateFilter) ProtoMessage()    {}
func (*ApplicationDateFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{10}
}
func (m *ApplicationDateFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationDateFilter.Unmarshal(m, b)
}
func (m *ApplicationDateFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationDateFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationDateFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationDateFilter.Merge(dst, src)
}
func (m *ApplicationDateFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationDateFilter.Size(m)
}
func (m *ApplicationDateFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationDateFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationDateFilter proto.InternalMessageInfo

func (m *ApplicationDateFilter) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *ApplicationDateFilter) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

// Input only.
//
// Outcome Notes Filter.
type ApplicationOutcomeNotesFilter struct {
	// Required.
	//
	// User entered or selected outcome reason. The API does an exact match on the
	// [Application.outcome_notes][google.cloud.talent.v4beta1.Application.outcome_notes]
	// in profiles.
	OutcomeNotes string `protobuf:"bytes,1,opt,name=outcome_notes,json=outcomeNotes,proto3" json:"outcome_notes,omitempty"`
	// Optional.
	//
	// If true, The API excludes all candidates with any
	// [Application.outcome_notes][google.cloud.talent.v4beta1.Application.outcome_notes]
	// matching the outcome reason specified in the filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationOutcomeNotesFilter) Reset()         { *m = ApplicationOutcomeNotesFilter{} }
func (m *ApplicationOutcomeNotesFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationOutcomeNotesFilter) ProtoMessage()    {}
func (*ApplicationOutcomeNotesFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{11}
}
func (m *ApplicationOutcomeNotesFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationOutcomeNotesFilter.Unmarshal(m, b)
}
func (m *ApplicationOutcomeNotesFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationOutcomeNotesFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationOutcomeNotesFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationOutcomeNotesFilter.Merge(dst, src)
}
func (m *ApplicationOutcomeNotesFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationOutcomeNotesFilter.Size(m)
}
func (m *ApplicationOutcomeNotesFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationOutcomeNotesFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationOutcomeNotesFilter proto.InternalMessageInfo

func (m *ApplicationOutcomeNotesFilter) GetOutcomeNotes() string {
	if m != nil {
		return m.OutcomeNotes
	}
	return ""
}

func (m *ApplicationOutcomeNotesFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on Last Stage of Application.
type ApplicationLastStageFilter struct {
	// Required.
	//
	// User entered or selected last stage the candidate reached in the
	// application. The API does an exact match on the
	// [Application.last_stage][] in profiles.
	LastStage string `protobuf:"bytes,1,opt,name=last_stage,json=lastStage,proto3" json:"last_stage,omitempty"`
	// Optional.
	// If true, The API excludes all candidates with any
	// [Application.last_stage][] matching the last stage specified in the
	// filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationLastStageFilter) Reset()         { *m = ApplicationLastStageFilter{} }
func (m *ApplicationLastStageFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationLastStageFilter) ProtoMessage()    {}
func (*ApplicationLastStageFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{12}
}
func (m *ApplicationLastStageFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationLastStageFilter.Unmarshal(m, b)
}
func (m *ApplicationLastStageFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationLastStageFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationLastStageFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationLastStageFilter.Merge(dst, src)
}
func (m *ApplicationLastStageFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationLastStageFilter.Size(m)
}
func (m *ApplicationLastStageFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationLastStageFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationLastStageFilter proto.InternalMessageInfo

func (m *ApplicationLastStageFilter) GetLastStage() string {
	if m != nil {
		return m.LastStage
	}
	return ""
}

func (m *ApplicationLastStageFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on the job information of Application.
type ApplicationJobFilter struct {
	// Optional.
	//
	// The job resource name in the application. The API does an exact match on
	// the [Job.name][google.cloud.talent.v4beta1.Job.name] of
	// [Application.job][google.cloud.talent.v4beta1.Application.job] in profiles.
	Job string `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Optional.
	//
	// The job requisition id in the application. The API does an exact match on
	// the [Job.requisistion_id][] of
	// [Application.job][google.cloud.talent.v4beta1.Application.job] in profiles.
	JobRequisitionId string `protobuf:"bytes,2,opt,name=job_requisition_id,json=jobRequisitionId,proto3" json:"job_requisition_id,omitempty"`
	// Optional.
	//
	// The job title in the application. The API does an exact match on the
	// [Job.title][google.cloud.talent.v4beta1.Job.title] of
	// [Application.job][google.cloud.talent.v4beta1.Application.job] in profiles.
	JobTitle string `protobuf:"bytes,3,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional.
	//
	// If true, the API excludes all profiles with any
	// [Application.job][google.cloud.talent.v4beta1.Application.job] matching the
	// filters.
	Negated              bool     `protobuf:"varint,4,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationJobFilter) Reset()         { *m = ApplicationJobFilter{} }
func (m *ApplicationJobFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationJobFilter) ProtoMessage()    {}
func (*ApplicationJobFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{13}
}
func (m *ApplicationJobFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationJobFilter.Unmarshal(m, b)
}
func (m *ApplicationJobFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationJobFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationJobFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationJobFilter.Merge(dst, src)
}
func (m *ApplicationJobFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationJobFilter.Size(m)
}
func (m *ApplicationJobFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationJobFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationJobFilter proto.InternalMessageInfo

func (m *ApplicationJobFilter) GetJob() string {
	if m != nil {
		return m.Job
	}
	return ""
}

func (m *ApplicationJobFilter) GetJobRequisitionId() string {
	if m != nil {
		return m.JobRequisitionId
	}
	return ""
}

func (m *ApplicationJobFilter) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *ApplicationJobFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on state of Application.
type ApplicationStatusFilter struct {
	// Required.
	//
	// User entered or selected application state. The API does an exact match
	// between the application state specified in this filter and the
	// [Application.state][google.cloud.talent.v4beta1.Application.state] in
	// profiles.
	ApplicationState Application_ApplicationState `protobuf:"varint,1,opt,name=application_state,json=applicationState,proto3,enum=google.cloud.talent.v4beta1.Application_ApplicationState" json:"application_state,omitempty"`
	// Optional.
	//
	// If true, The API excludes all candidates with any
	// [Application.state][google.cloud.talent.v4beta1.Application.state] matching
	// the state specified in the filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationStatusFilter) Reset()         { *m = ApplicationStatusFilter{} }
func (m *ApplicationStatusFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationStatusFilter) ProtoMessage()    {}
func (*ApplicationStatusFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{14}
}
func (m *ApplicationStatusFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationStatusFilter.Unmarshal(m, b)
}
func (m *ApplicationStatusFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationStatusFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationStatusFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationStatusFilter.Merge(dst, src)
}
func (m *ApplicationStatusFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationStatusFilter.Size(m)
}
func (m *ApplicationStatusFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationStatusFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationStatusFilter proto.InternalMessageInfo

func (m *ApplicationStatusFilter) GetApplicationState() Application_ApplicationState {
	if m != nil {
		return m.ApplicationState
	}
	return Application_APPLICATION_STATE_UNSPECIFIED
}

func (m *ApplicationStatusFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on create timestamp or update timestamp of profiles.
type TimeFilter struct {
	// Optional.
	//
	// Start timestamp, matching profiles with the start time. If this field
	// missing, The API matches profiles with create / update timestamp before the
	// end timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional.
	//
	// End timestamp, matching profiles with the end time. If this field
	// missing, The API matches profiles with create / update timestamp after the
	// start timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional.
	//
	// Specifies which time field to filter profiles.
	//
	// Defaults to
	// [TimeField.CREATE_TIME][google.cloud.talent.v4beta1.TimeFilter.TimeField.CREATE_TIME].
	TimeField            TimeFilter_TimeField `protobuf:"varint,3,opt,name=time_field,json=timeField,proto3,enum=google.cloud.talent.v4beta1.TimeFilter_TimeField" json:"time_field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeFilter) Reset()         { *m = TimeFilter{} }
func (m *TimeFilter) String() string { return proto.CompactTextString(m) }
func (*TimeFilter) ProtoMessage()    {}
func (*TimeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_19ca36923ce0a2d6, []int{15}
}
func (m *TimeFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeFilter.Unmarshal(m, b)
}
func (m *TimeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeFilter.Marshal(b, m, deterministic)
}
func (dst *TimeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeFilter.Merge(dst, src)
}
func (m *TimeFilter) XXX_Size() int {
	return xxx_messageInfo_TimeFilter.Size(m)
}
func (m *TimeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_TimeFilter proto.InternalMessageInfo

func (m *TimeFilter) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeFilter) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TimeFilter) GetTimeField() TimeFilter_TimeField {
	if m != nil {
		return m.TimeField
	}
	return TimeFilter_TIME_FIELD_UNSPECIFIED
}

func init() {
	proto.RegisterType((*JobQuery)(nil), "google.cloud.talent.v4beta1.JobQuery")
	proto.RegisterType((*ProfileQuery)(nil), "google.cloud.talent.v4beta1.ProfileQuery")
	proto.RegisterType((*LocationFilter)(nil), "google.cloud.talent.v4beta1.LocationFilter")
	proto.RegisterType((*CompensationFilter)(nil), "google.cloud.talent.v4beta1.CompensationFilter")
	proto.RegisterType((*CommuteFilter)(nil), "google.cloud.talent.v4beta1.CommuteFilter")
	proto.RegisterType((*JobTitleFilter)(nil), "google.cloud.talent.v4beta1.JobTitleFilter")
	proto.RegisterType((*SkillFilter)(nil), "google.cloud.talent.v4beta1.SkillFilter")
	proto.RegisterType((*EmployerFilter)(nil), "google.cloud.talent.v4beta1.EmployerFilter")
	proto.RegisterType((*EducationFilter)(nil), "google.cloud.talent.v4beta1.EducationFilter")
	proto.RegisterType((*WorkExperienceFilter)(nil), "google.cloud.talent.v4beta1.WorkExperienceFilter")
	proto.RegisterType((*ApplicationDateFilter)(nil), "google.cloud.talent.v4beta1.ApplicationDateFilter")
	proto.RegisterType((*ApplicationOutcomeNotesFilter)(nil), "google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter")
	proto.RegisterType((*ApplicationLastStageFilter)(nil), "google.cloud.talent.v4beta1.ApplicationLastStageFilter")
	proto.RegisterType((*ApplicationJobFilter)(nil), "google.cloud.talent.v4beta1.ApplicationJobFilter")
	proto.RegisterType((*ApplicationStatusFilter)(nil), "google.cloud.talent.v4beta1.ApplicationStatusFilter")
	proto.RegisterType((*TimeFilter)(nil), "google.cloud.talent.v4beta1.TimeFilter")
	proto.RegisterEnum("google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference", LocationFilter_TelecommutePreference_name, LocationFilter_TelecommutePreference_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompensationFilter_FilterType", CompensationFilter_FilterType_name, CompensationFilter_FilterType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic", CommuteFilter_RoadTraffic_name, CommuteFilter_RoadTraffic_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.EmployerFilter_EmployerFilterMode", EmployerFilter_EmployerFilterMode_name, EmployerFilter_EmployerFilterMode_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.TimeFilter_TimeField", TimeFilter_TimeField_name, TimeFilter_TimeField_value)
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/filters.proto", fileDescriptor_filters_19ca36923ce0a2d6)
}

var fileDescriptor_filters_19ca36923ce0a2d6 = []byte{
	// 2127 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4f, 0x73, 0x23, 0x47,
	0x15, 0x8f, 0x24, 0xaf, 0xd7, 0x7a, 0xfa, 0x63, 0xb9, 0x77, 0x6d, 0x2b, 0xde, 0x4d, 0xd6, 0x28,
	0x09, 0x98, 0x64, 0x91, 0xb3, 0x26, 0x84, 0x4a, 0x28, 0x48, 0x64, 0x69, 0xcc, 0xca, 0xa5, 0x7f,
	0x19, 0x49, 0x59, 0x36, 0x54, 0xd1, 0xb4, 0x66, 0x5a, 0xf2, 0x78, 0x47, 0xd3, 0x93, 0xe9, 0x56,
	0xbc, 0xa6, 0xb8, 0x70, 0x80, 0x1b, 0x5f, 0x80, 0x14, 0x97, 0xdc, 0x39, 0x71, 0xa0, 0x8a, 0x8f,
	0xc1, 0x27, 0xa2, 0xba, 0xa7, 0x47, 0x1a, 0xc9, 0xf6, 0xd8, 0xa1, 0x38, 0x69, 0xde, 0xbf, 0x5f,
	0xbf, 0xe9, 0xee, 0xf7, 0xde, 0x6f, 0x04, 0x3f, 0x9e, 0x30, 0x36, 0x71, 0xe9, 0xa1, 0xe5, 0xb2,
	0x99, 0x7d, 0x28, 0x88, 0x4b, 0x3d, 0x71, 0xf8, 0xcd, 0x47, 0x23, 0x2a, 0xc8, 0xb3, 0xc3, 0xb1,
	0xe3, 0x0a, 0x1a, 0xf0, 0xaa, 0x1f, 0x30, 0xc1, 0xd0, 0xa3, 0xd0, 0xb5, 0xaa, 0x5c, 0xab, 0xa1,
	0x6b, 0x55, 0xbb, 0xee, 0x3d, 0xd6, 0x38, 0xc4, 0x77, 0x0e, 0x89, 0xe7, 0x31, 0x41, 0x84, 0xc3,
	0x3c, 0x1d, 0xba, 0xf7, 0x93, 0xa4, 0x55, 0x88, 0xef, 0xbb, 0x8e, 0xa5, 0xfc, 0xb5, 0xfb, 0x41,
	0x92, 0xbb, 0xc5, 0xa6, 0xd3, 0xb9, 0xe7, 0x7b, 0x49, 0x9e, 0xe7, 0x6c, 0xa4, 0xdd, 0x12, 0xdf,
	0xd2, 0x0f, 0xd8, 0xd8, 0x71, 0xa9, 0x76, 0x7d, 0x5b, 0xbb, 0x2a, 0x69, 0x34, 0x1b, 0x1f, 0xda,
	0xb3, 0x20, 0x9e, 0xdb, 0x93, 0x55, 0xbb, 0x70, 0xa6, 0x94, 0x0b, 0x32, 0xf5, 0x6f, 0x02, 0xb8,
	0x08, 0x88, 0xef, 0xcf, 0xb7, 0x71, 0x6f, 0x47, 0xdb, 0xc5, 0xa5, 0x4f, 0x0f, 0x6d, 0x22, 0xa2,
	0x85, 0xcb, 0x71, 0xbd, 0x4b, 0x84, 0xeb, 0x4d, 0xb4, 0xe5, 0x51, 0xdc, 0x22, 0x97, 0x63, 0x63,
	0x9b, 0x5c, 0x86, 0xc6, 0xca, 0xbf, 0xd6, 0x61, 0xe3, 0x94, 0x8d, 0xbe, 0x98, 0xd1, 0xe0, 0x12,
	0x3d, 0x84, 0x7b, 0x5f, 0xcb, 0x87, 0x72, 0x6a, 0x3f, 0x75, 0x90, 0x35, 0x43, 0x01, 0x3d, 0x86,
	0xac, 0xc5, 0xa6, 0x3e, 0xf1, 0x1c, 0xca, 0xcb, 0xe9, 0xfd, 0xcc, 0x41, 0xd6, 0x5c, 0x28, 0xd0,
	0x97, 0x50, 0x72, 0x59, 0xb8, 0xfd, 0x58, 0x1f, 0x78, 0x39, 0xb3, 0x9f, 0x39, 0xc8, 0x1d, 0x7d,
	0x50, 0x4d, 0x38, 0xf1, 0x6a, 0x4b, 0x07, 0x9d, 0xa8, 0x18, 0x73, 0xd3, 0x5d, 0x92, 0x39, 0xea,
	0x42, 0xf1, 0x9c, 0x8d, 0xb0, 0x45, 0x04, 0x9d, 0xb0, 0x40, 0x2e, 0xbd, 0xb6, 0x9f, 0x39, 0x28,
	0x1e, 0x1d, 0x24, 0xa2, 0x9e, 0xb2, 0x51, 0x3d, 0x8c, 0xb8, 0x34, 0x0b, 0xe7, 0x73, 0x41, 0x26,
	0xfa, 0x05, 0x14, 0xe5, 0xd9, 0xcf, 0x04, 0xd5, 0x79, 0x96, 0xef, 0xed, 0xa7, 0x0e, 0x72, 0x47,
	0xef, 0x27, 0x02, 0xd6, 0xc3, 0x10, 0x9d, 0x65, 0xc1, 0x8a, 0x8b, 0xe8, 0x08, 0xb6, 0xc3, 0x8d,
	0xb8, 0xc4, 0xb6, 0xc3, 0x7d, 0x97, 0x5c, 0x62, 0x8f, 0x4c, 0x29, 0x2f, 0xaf, 0xab, 0x5d, 0x7a,
	0xa0, 0x8d, 0x8d, 0xd0, 0xd6, 0x91, 0x26, 0xf4, 0x7b, 0x50, 0x6a, 0xea, 0xf1, 0xf8, 0x9e, 0x95,
	0xef, 0xab, 0x5c, 0x0e, 0x6f, 0xcb, 0x65, 0x1e, 0xa7, 0x13, 0x42, 0xd6, 0x15, 0x1d, 0xfa, 0x18,
	0x76, 0xad, 0x19, 0x17, 0x6c, 0x8a, 0x89, 0x10, 0x81, 0x33, 0x8a, 0xbd, 0xf1, 0x86, 0x3a, 0xd7,
	0xed, 0xd0, 0x5c, 0x8b, 0xac, 0x3a, 0xae, 0x0a, 0x0f, 0x6c, 0x87, 0x93, 0x91, 0x4b, 0x31, 0xf7,
	0xa9, 0xeb, 0x62, 0xeb, 0x8c, 0x5a, 0xaf, 0xca, 0xd9, 0xfd, 0xd4, 0xc1, 0x86, 0xb9, 0xa5, 0x4d,
	0x7d, 0x69, 0xa9, 0x4b, 0x83, 0x3c, 0x79, 0x3a, 0xf5, 0x5d, 0x76, 0x39, 0xa5, 0x9e, 0xc0, 0xf2,
	0x76, 0xf1, 0x32, 0xa8, 0x33, 0x4a, 0x3e, 0x79, 0x63, 0x1e, 0x34, 0xb8, 0xf4, 0xa9, 0xb9, 0x49,
	0x97, 0x64, 0x8e, 0xde, 0x83, 0xa2, 0x4b, 0xbc, 0xc9, 0x8c, 0x4c, 0x28, 0xb6, 0x98, 0x4d, 0x79,
	0x39, 0xa7, 0xb6, 0xb3, 0x10, 0x69, 0xeb, 0x52, 0x89, 0x5e, 0x02, 0xf2, 0x67, 0x23, 0xd7, 0xe1,
	0x67, 0x58, 0x5e, 0x6a, 0x1c, 0x10, 0x6f, 0x42, 0xcb, 0x79, 0xb5, 0x8f, 0xc9, 0x09, 0x0c, 0xa2,
	0x92, 0x33, 0x65, 0x88, 0x59, 0xd2, 0x30, 0x52, 0xad, 0x34, 0xe8, 0x1d, 0x28, 0xd0, 0xd7, 0x96,
	0x3b, 0xb3, 0xa9, 0x8d, 0xcf, 0xd9, 0x88, 0x97, 0x0b, 0x2a, 0x81, 0x7c, 0xa4, 0x3c, 0x65, 0x23,
	0x5e, 0xf9, 0x0f, 0x40, 0xbe, 0x17, 0xd6, 0x7e, 0x52, 0xf5, 0x5c, 0x57, 0x1f, 0xe9, 0xff, 0x43,
	0x7d, 0xbc, 0x80, 0x2d, 0x59, 0x1f, 0xc2, 0x11, 0x2e, 0xfd, 0x5e, 0x85, 0x77, 0xca, 0x46, 0x03,
	0x19, 0x14, 0x01, 0x9f, 0x2f, 0xc9, 0x7c, 0x71, 0xac, 0x34, 0x98, 0xe3, 0xae, 0xdd, 0x01, 0xd7,
	0xd0, 0x41, 0x11, 0x2e, 0x5d, 0x92, 0xe5, 0x79, 0x6d, 0x51, 0x7b, 0xb6, 0xb2, 0x13, 0xf7, 0x14,
	0xf0, 0xd3, 0x64, 0xe0, 0x28, 0x4a, 0x23, 0x97, 0xe8, 0xb2, 0x82, 0xa3, 0x36, 0x14, 0xf8, 0x2b,
	0xc7, 0x75, 0xe7, 0xb0, 0xeb, 0x0a, 0x36, 0xb9, 0x55, 0xf4, 0x65, 0x84, 0x86, 0xcc, 0xf3, 0x85,
	0xc0, 0xd1, 0x04, 0x76, 0x2e, 0x58, 0xf0, 0x0a, 0xd3, 0xd7, 0x3e, 0x0d, 0x1c, 0xea, 0x59, 0x74,
	0x51, 0xa5, 0x12, 0xf7, 0x59, 0x22, 0xee, 0x0b, 0x16, 0xbc, 0x32, 0xe6, 0x91, 0x7a, 0x81, 0x87,
	0x17, 0xd7, 0x68, 0xd1, 0x29, 0xe4, 0xd5, 0xd5, 0x8d, 0xd2, 0xde, 0x50, 0xf0, 0x3f, 0xba, 0xf5,
	0xf2, 0x6a, 0xd0, 0x9c, 0x98, 0x3f, 0x73, 0x54, 0x83, 0xe2, 0x99, 0x13, 0xa8, 0xea, 0xd5, 0xc9,
	0x66, 0x55, 0x29, 0xec, 0x45, 0x68, 0xd1, 0x40, 0xa9, 0x1e, 0x33, 0xe6, 0x7e, 0x49, 0xdc, 0x19,
	0x35, 0x0b, 0x3a, 0x42, 0xa7, 0xe3, 0x42, 0x39, 0x36, 0x4c, 0xb1, 0x1c, 0x2e, 0xf3, 0xd4, 0x40,
	0xa5, 0x76, 0x94, 0x98, 0x5a, 0x6d, 0x11, 0xdc, 0x20, 0xf3, 0x9e, 0xb9, 0x43, 0xae, 0x53, 0x73,
	0xf4, 0xe7, 0x14, 0xfc, 0x20, 0xbe, 0x1c, 0x9b, 0x09, 0x8b, 0x4d, 0x29, 0xf6, 0x98, 0xa0, 0x7c,
	0xbe, 0x6e, 0x4e, 0xad, 0xfb, 0xe9, 0x5d, 0xd7, 0xed, 0x86, 0x20, 0x1d, 0x89, 0xa1, 0xd7, 0x7f,
	0x9b, 0x24, 0x99, 0x39, 0xfa, 0x23, 0xc4, 0x3d, 0xb0, 0x4b, 0xb8, 0xc0, 0x5c, 0xc8, 0xe6, 0x13,
	0xe5, 0x90, 0x57, 0x39, 0xfc, 0xfc, 0xae, 0x39, 0xb4, 0x08, 0x17, 0x7d, 0x09, 0xa0, 0x13, 0x78,
	0x44, 0x6e, 0xb4, 0x71, 0xe4, 0xc0, 0x6e, 0x7c, 0x75, 0x59, 0xd2, 0xd1, 0xb2, 0x85, 0x3b, 0x5c,
	0xb6, 0xd8, 0xb2, 0xa7, 0x6c, 0xa4, 0x17, 0xdc, 0x26, 0xd7, 0x68, 0x39, 0x0a, 0x60, 0x2f, 0xbe,
	0x14, 0x17, 0x44, 0xcc, 0x16, 0x1b, 0x5d, 0x54, 0xab, 0x7d, 0x74, 0xd7, 0xd5, 0xfa, 0x2a, 0x5a,
	0x2f, 0x18, 0xbf, 0x36, 0x71, 0x03, 0x97, 0x33, 0x45, 0xcf, 0xa2, 0xb1, 0x43, 0x5d, 0x3b, 0xba,
	0x9a, 0x9b, 0xaa, 0x43, 0x6e, 0x85, 0xa6, 0x13, 0x69, 0x09, 0x03, 0x2a, 0xff, 0xc8, 0x40, 0x71,
	0xb9, 0xf3, 0xa1, 0x32, 0xdc, 0x27, 0xb6, 0x1d, 0x50, 0xce, 0x75, 0x63, 0x8d, 0x44, 0xf4, 0x04,
	0x72, 0x01, 0x9d, 0xc8, 0x77, 0x91, 0x63, 0xa2, 0x9c, 0x56, 0x56, 0x08, 0x55, 0x72, 0x46, 0xa0,
	0xa7, 0x70, 0xdf, 0x25, 0x02, 0xbb, 0xde, 0xa4, 0x9c, 0x51, 0xc5, 0xf0, 0x20, 0x7a, 0x3d, 0x39,
	0xad, 0xaa, 0x2d, 0x22, 0x5a, 0xde, 0xc4, 0x5c, 0x77, 0xd5, 0x2f, 0x7a, 0x1f, 0xe4, 0x90, 0x13,
	0x44, 0xd6, 0xbb, 0xe3, 0xe1, 0xa9, 0xe3, 0x2a, 0xd2, 0x91, 0x3a, 0x48, 0x99, 0x9b, 0x91, 0xa1,
	0xe9, 0xb5, 0xa5, 0x1a, 0xbd, 0x86, 0x1d, 0x41, 0x5d, 0x1a, 0x11, 0x0a, 0x3f, 0xa0, 0x63, 0x1a,
	0xc8, 0xca, 0x56, 0xa4, 0xa2, 0x78, 0x54, 0xfb, 0x1e, 0xbd, 0xbd, 0x3a, 0x58, 0x20, 0xf5, 0xe6,
	0x40, 0xe6, 0xb6, 0xb8, 0x4e, 0x2d, 0xb7, 0xc3, 0xa3, 0x13, 0x22, 0xa8, 0x5d, 0x5e, 0x57, 0x93,
	0x39, 0x12, 0x2b, 0x01, 0x6c, 0x5f, 0x8b, 0x84, 0x7e, 0x08, 0x95, 0x81, 0xd1, 0x32, 0xea, 0xdd,
	0x76, 0x7b, 0x38, 0x30, 0x70, 0xcf, 0x34, 0x4e, 0x0c, 0xd3, 0xe8, 0xd4, 0x0d, 0x3c, 0xec, 0xf4,
	0x7b, 0x46, 0xbd, 0x79, 0xd2, 0x34, 0x1a, 0xa5, 0x37, 0x50, 0x19, 0x1e, 0xc6, 0xfd, 0x8c, 0xdf,
	0xd4, 0x5b, 0xc3, 0x86, 0xd1, 0x28, 0xa5, 0xd0, 0x2e, 0x3c, 0x88, 0x5b, 0x6a, 0xad, 0x56, 0xf7,
	0x85, 0xd1, 0x28, 0xa5, 0x2b, 0x7f, 0x5a, 0x03, 0x74, 0x95, 0x96, 0xa0, 0x0e, 0xac, 0xc9, 0x1d,
	0x56, 0x07, 0x56, 0xbc, 0xa5, 0x7a, 0xaf, 0x86, 0x57, 0xc3, 0x1f, 0xc5, 0x0e, 0x14, 0x0e, 0x1a,
	0xc0, 0xbd, 0x99, 0xe7, 0x88, 0x70, 0x72, 0x16, 0x8f, 0x7e, 0x75, 0x67, 0xc0, 0xa6, 0x37, 0x66,
	0x4b, 0x8a, 0xa1, 0xe7, 0x08, 0x33, 0x04, 0x43, 0x43, 0xb8, 0x17, 0x92, 0x86, 0xf0, 0x72, 0x7c,
	0xf6, 0xbf, 0xa3, 0x86, 0x44, 0x22, 0x44, 0x43, 0x14, 0x3e, 0x74, 0x3c, 0x45, 0x14, 0x14, 0x79,
	0xc0, 0x17, 0x8e, 0x38, 0xc3, 0x33, 0x8f, 0xfb, 0xd4, 0x72, 0xc6, 0x0e, 0xb5, 0xf1, 0x12, 0xff,
	0x0b, 0x33, 0x58, 0x53, 0x47, 0xf9, 0x81, 0x8e, 0x93, 0xfc, 0xe2, 0x85, 0x23, 0xce, 0x86, 0x8b,
	0xa0, 0x2b, 0xab, 0x55, 0xfe, 0x92, 0x02, 0x58, 0x6c, 0x14, 0x7a, 0x04, 0xbb, 0x27, 0xcd, 0xd6,
	0xc0, 0x30, 0xf1, 0xe0, 0x65, 0x6f, 0xf5, 0x64, 0x0b, 0x90, 0x1d, 0x76, 0x9a, 0x03, 0xdc, 0xed,
	0xb4, 0x5e, 0x96, 0x52, 0xe8, 0x01, 0x6c, 0x2a, 0xb1, 0xd6, 0x69, 0xe0, 0x5a, 0xbb, 0x3b, 0xec,
	0x0c, 0x4a, 0x69, 0xb4, 0x07, 0x3b, 0xb5, 0x4e, 0x67, 0x58, 0x6b, 0x35, 0xbf, 0x32, 0x1a, 0xf8,
	0xb8, 0xd6, 0x37, 0x22, 0x5b, 0x46, 0x82, 0xc7, 0x6c, 0x83, 0xee, 0xa0, 0xd6, 0x8a, 0x8c, 0x6b,
	0x95, 0xef, 0xd6, 0xa0, 0xb0, 0x44, 0x93, 0xe3, 0x54, 0x7b, 0x4a, 0xc5, 0x19, 0xb3, 0xf5, 0x45,
	0xb8, 0x13, 0xd5, 0x6e, 0xab, 0x88, 0x39, 0xd5, 0x0e, 0x45, 0xf4, 0x39, 0x6c, 0x71, 0x41, 0x02,
	0x81, 0x2d, 0xc6, 0x02, 0xdb, 0xf1, 0x88, 0x50, 0x1f, 0x23, 0x37, 0x16, 0x75, 0x49, 0x79, 0xd7,
	0x17, 0xce, 0xe8, 0x18, 0x36, 0x45, 0x40, 0xbe, 0xa1, 0x2e, 0x8e, 0x3e, 0xc9, 0xf4, 0xb9, 0xbf,
	0x79, 0x65, 0x42, 0x36, 0xb4, 0x83, 0x59, 0x0c, 0x23, 0x22, 0x19, 0x7d, 0x0a, 0x6f, 0x12, 0xd7,
	0x65, 0x17, 0xd8, 0x99, 0xfa, 0x01, 0xb5, 0x1c, 0x4e, 0xb1, 0x6e, 0x46, 0xba, 0x55, 0x6c, 0x98,
	0xbb, 0xca, 0xa1, 0x19, 0xd9, 0x6b, 0x91, 0x19, 0xfd, 0x16, 0xf2, 0x01, 0x23, 0x36, 0x16, 0x01,
	0x19, 0x8f, 0x1d, 0x4b, 0x37, 0x8a, 0x8f, 0xef, 0xfe, 0xf5, 0x51, 0x35, 0x19, 0xb1, 0x07, 0x61,
	0xf4, 0xf3, 0x37, 0xcc, 0x5c, 0xb0, 0x10, 0xd1, 0x67, 0x50, 0xb4, 0xa9, 0x4f, 0x02, 0x31, 0x0b,
	0xa8, 0xa2, 0xc3, 0xaa, 0x39, 0xe4, 0x8e, 0x76, 0x96, 0xf6, 0x46, 0x72, 0x87, 0xee, 0xb8, 0x41,
	0x2e, 0x9f, 0xbf, 0x61, 0x16, 0xe6, 0xfe, 0x52, 0x5b, 0x69, 0x41, 0x2e, 0x06, 0x8f, 0x1e, 0x43,
	0xd9, 0xec, 0xd6, 0x1a, 0x78, 0x60, 0xd6, 0x4e, 0x4e, 0x9a, 0xf5, 0x95, 0xeb, 0x54, 0x82, 0x7c,
	0x64, 0x38, 0x31, 0x0d, 0xa3, 0x94, 0x92, 0x17, 0xec, 0x78, 0xd8, 0x7f, 0x89, 0x9f, 0x77, 0x87,
	0x66, 0x29, 0x7d, 0x5c, 0x82, 0xa2, 0x7e, 0x4d, 0xcc, 0x7c, 0xb9, 0x73, 0x95, 0x5f, 0x43, 0x71,
	0x99, 0x78, 0xa2, 0x47, 0x90, 0x9d, 0x13, 0x58, 0xdd, 0xd9, 0x37, 0x22, 0x2e, 0x1a, 0xef, 0x72,
	0xe9, 0xe5, 0x2e, 0xf7, 0x4b, 0xc8, 0xc5, 0x98, 0x9b, 0x24, 0xdd, 0x8a, 0xbb, 0x45, 0xa4, 0x5b,
	0x09, 0x09, 0xe1, 0xff, 0x4e, 0x43, 0x71, 0x99, 0xa9, 0xa2, 0x3d, 0xd8, 0x88, 0xb8, 0x6a, 0x94,
	0x47, 0x24, 0x23, 0x13, 0xd6, 0xa6, 0xd1, 0x6c, 0xb9, 0xad, 0xef, 0x2c, 0xc3, 0xae, 0x88, 0x6d,
	0x66, 0x53, 0x53, 0x61, 0xc5, 0x93, 0xcb, 0x2c, 0x27, 0xf7, 0xf7, 0x14, 0xa0, 0xab, 0x61, 0xe8,
	0x5d, 0xd8, 0x37, 0xda, 0xbd, 0x56, 0xf7, 0xa5, 0x61, 0x62, 0x5d, 0xe3, 0xed, 0x6e, 0x63, 0xb5,
	0xc6, 0x65, 0xfd, 0xb6, 0x5a, 0x38, 0xf4, 0x6c, 0x1b, 0x9d, 0x01, 0x36, 0x8d, 0x7a, 0xd7, 0x6c,
	0xf4, 0x4b, 0x29, 0xf4, 0x0e, 0x3c, 0xa9, 0x0f, 0x4d, 0x53, 0x2a, 0xaf, 0xda, 0xc3, 0xae, 0x90,
	0x46, 0xfb, 0xf0, 0xb8, 0x57, 0xeb, 0xdf, 0xec, 0x91, 0xa9, 0xfc, 0x33, 0x05, 0x9b, 0x2b, 0x6c,
	0x1c, 0xed, 0xc0, 0x3a, 0xb7, 0xce, 0x18, 0x8b, 0x4e, 0x40, 0x4b, 0xe8, 0x5d, 0x28, 0x86, 0x23,
	0x9f, 0x8d, 0x31, 0x17, 0x33, 0xfb, 0x52, 0xcf, 0xe7, 0xbc, 0xd2, 0x76, 0xc7, 0x7d, 0xa9, 0x43,
	0xcf, 0x21, 0x67, 0xd3, 0x49, 0x40, 0xa9, 0xfa, 0x7e, 0x54, 0xfb, 0x51, 0xbc, 0x85, 0x00, 0x37,
	0x94, 0xbf, 0x1a, 0x0e, 0x60, 0xcf, 0x9f, 0x13, 0xe6, 0xe2, 0xdf, 0x52, 0xf0, 0xf0, 0x3a, 0x52,
	0x8e, 0x3e, 0x87, 0xe2, 0xd4, 0xf1, 0x62, 0x34, 0x5f, 0xbd, 0x42, 0x62, 0x43, 0x28, 0x4c, 0x1d,
	0x6f, 0x81, 0xa3, 0x10, 0xc8, 0xeb, 0x38, 0x42, 0xfa, 0x76, 0x04, 0xf2, 0x7a, 0x81, 0x50, 0xb9,
	0x80, 0xed, 0x6b, 0x69, 0x33, 0xfa, 0x10, 0x20, 0x6c, 0x78, 0x92, 0x86, 0xeb, 0xc4, 0xb6, 0x96,
	0xaa, 0x59, 0x3a, 0x9b, 0x59, 0xe5, 0x24, 0x1f, 0xd1, 0x53, 0xd8, 0xa0, 0x9e, 0x1d, 0xfa, 0xa7,
	0x6f, 0xf2, 0xbf, 0x4f, 0x3d, 0x5b, 0x3e, 0x54, 0x7e, 0x07, 0x6f, 0x25, 0xf2, 0x66, 0xf9, 0x11,
	0xbc, 0x44, 0xc9, 0xf5, 0xf9, 0xe6, 0x59, 0xcc, 0x35, 0xa1, 0xd0, 0x86, 0xb0, 0x77, 0x33, 0x27,
	0x46, 0x6f, 0x01, 0x2c, 0x88, 0xb6, 0x46, 0xce, 0xba, 0x91, 0x53, 0x02, 0xec, 0x5f, 0x53, 0xf0,
	0xf0, 0x3a, 0xd2, 0x8b, 0x4a, 0x90, 0x39, 0x67, 0x23, 0x0d, 0x25, 0x1f, 0xd1, 0x53, 0x40, 0xb2,
	0xc1, 0x04, 0xf4, 0xeb, 0x99, 0xc3, 0x1d, 0x35, 0x6c, 0x1d, 0x5b, 0xdf, 0xc2, 0xd2, 0x39, 0x1b,
	0x99, 0x0b, 0x43, 0xd3, 0x5e, 0x6e, 0x47, 0x99, 0x9b, 0xdb, 0xd1, 0xda, 0x72, 0x3e, 0xdf, 0xa6,
	0x60, 0xf7, 0x06, 0x5a, 0x8c, 0xc6, 0xb0, 0xb5, 0x4a, 0xb8, 0x23, 0x4a, 0xf4, 0xc9, 0x5d, 0x79,
	0xf6, 0x2a, 0xe7, 0xa6, 0x66, 0x69, 0x85, 0x6c, 0x27, 0xed, 0xd6, 0xb7, 0x69, 0x80, 0xc5, 0x07,
	0x23, 0xfa, 0x24, 0xba, 0x53, 0x6a, 0x42, 0xa4, 0x6e, 0xf8, 0x3e, 0x5c, 0xfc, 0x3d, 0x12, 0x5e,
	0x2e, 0x29, 0xa3, 0x9f, 0x85, 0x97, 0x4b, 0x05, 0xa6, 0x6f, 0x0d, 0x94, 0xb7, 0x4c, 0x85, 0xf5,
	0x00, 0xf4, 0x17, 0x2e, 0x75, 0x6d, 0x5d, 0xde, 0xcf, 0xee, 0xf8, 0x7d, 0xab, 0x1f, 0xa9, 0x6b,
	0x9b, 0x59, 0x11, 0x3d, 0x56, 0x9a, 0x90, 0x9d, 0xeb, 0x65, 0xcf, 0x1b, 0x34, 0xdb, 0x06, 0x3e,
	0x69, 0x1a, 0xad, 0xc6, 0x4a, 0x3f, 0xdc, 0x84, 0x5c, 0xdd, 0x34, 0x6a, 0x03, 0x03, 0x4b, 0x97,
	0x52, 0x4a, 0x2a, 0x86, 0xbd, 0xc6, 0x5c, 0x91, 0x3e, 0xfe, 0x03, 0x3c, 0xb1, 0xd8, 0x34, 0x29,
	0x9b, 0xe3, 0xbc, 0xfe, 0x90, 0xe9, 0xc9, 0x77, 0xec, 0xa5, 0xbe, 0xaa, 0x69, 0xe7, 0x09, 0x73,
	0x89, 0x37, 0xa9, 0xb2, 0x60, 0x72, 0x38, 0xa1, 0x9e, 0xda, 0x81, 0xc3, 0xd0, 0x44, 0x7c, 0x87,
	0x5f, 0xfb, 0x47, 0xf1, 0x2f, 0x42, 0xf1, 0xbb, 0x74, 0xa6, 0x3e, 0xe8, 0x8f, 0xd6, 0x55, 0xcc,
	0x4f, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x52, 0x4c, 0x5d, 0x01, 0x41, 0x17, 0x00, 0x00,
}
