'use client';
import { jsxs, jsx } from 'react/jsx-runtime';
import dayjs from 'dayjs';
import { useRef, useState } from 'react';
import { factory, useProps, useStyles, useResolvedStylesApi, ActionIcon, CheckIcon } from '@mantine/core';
import { useMergedRef, useDisclosure, useDidUpdate } from '@mantine/hooks';
import { useUncontrolledDates } from '../../hooks/use-uncontrolled-dates/use-uncontrolled-dates.mjs';
import '../DatesProvider/DatesProvider.mjs';
import { useDatesContext } from '../DatesProvider/use-dates-context.mjs';
import { assignTime } from '../../utils/assign-time/assign-time.mjs';
import { shiftTimezone } from '../../utils/shift-timezone.mjs';
import '../Calendar/Calendar.mjs';
import { pickCalendarProps } from '../Calendar/pick-calendar-levels-props/pick-calendar-levels-props.mjs';
import { DatePicker } from '../DatePicker/DatePicker.mjs';
import { PickerInputBase } from '../PickerInputBase/PickerInputBase.mjs';
import { TimeInput } from '../TimeInput/TimeInput.mjs';
import classes from './DateTimePicker.module.css.mjs';

const defaultProps = {
  dropdownType: "popover"
};
const DateTimePicker = factory((_props, ref) => {
  const props = useProps("DateTimePicker", defaultProps, _props);
  const {
    value,
    defaultValue,
    onChange,
    valueFormat,
    locale,
    classNames,
    styles,
    unstyled,
    timeInputProps,
    submitButtonProps,
    withSeconds,
    level,
    defaultLevel,
    size,
    variant,
    dropdownType,
    vars,
    minDate,
    maxDate,
    ...rest
  } = props;
  const getStyles = useStyles({
    name: "DateTimePicker",
    classes,
    props,
    classNames,
    styles,
    unstyled,
    vars
  });
  const { resolvedClassNames, resolvedStyles } = useResolvedStylesApi({
    classNames,
    styles,
    props
  });
  const _valueFormat = valueFormat || (withSeconds ? "DD/MM/YYYY HH:mm:ss" : "DD/MM/YYYY HH:mm");
  const timeInputRef = useRef(null);
  const timeInputRefMerged = useMergedRef(timeInputRef, timeInputProps?.ref);
  const {
    calendarProps: { allowSingleDateInRange, ...calendarProps },
    others
  } = pickCalendarProps(rest);
  const ctx = useDatesContext();
  const [_value, setValue] = useUncontrolledDates({
    type: "default",
    value,
    defaultValue,
    onChange
  });
  const formatTime = (dateValue) => dateValue ? dayjs(dateValue).format(withSeconds ? "HH:mm:ss" : "HH:mm") : "";
  const [timeValue, setTimeValue] = useState(formatTime(_value));
  const [currentLevel, setCurrentLevel] = useState(level || defaultLevel || "month");
  const [dropdownOpened, dropdownHandlers] = useDisclosure(false);
  const formattedValue = _value ? dayjs(_value).locale(ctx.getLocale(locale)).tz(ctx.getTimezone()).format(_valueFormat) : "";
  const handleTimeChange = (event) => {
    timeInputProps?.onChange?.(event);
    const val = event.currentTarget.value;
    setTimeValue(val);
    if (val) {
      const [hours, minutes, seconds] = val.split(":").map(Number);
      const timeDate = shiftTimezone("add", /* @__PURE__ */ new Date(), ctx.getTimezone());
      timeDate.setHours(hours);
      timeDate.setMinutes(minutes);
      timeDate.setSeconds(seconds || 0);
      timeDate.setMilliseconds(0);
      setValue(assignTime(timeDate, _value || shiftTimezone("add", /* @__PURE__ */ new Date(), ctx.getTimezone())));
    }
  };
  const handleDateChange = (date) => {
    if (date) {
      setValue(assignTime(_value, date));
    }
    timeInputRef.current?.focus();
  };
  const handleTimeInputKeyDown = (event) => {
    timeInputProps?.onKeyDown?.(event);
    if (event.key === "Enter") {
      event.preventDefault();
      dropdownHandlers.close();
    }
  };
  useDidUpdate(() => {
    if (!dropdownOpened) {
      setTimeValue(formatTime(_value));
    }
  }, [_value, dropdownOpened]);
  useDidUpdate(() => {
    if (dropdownOpened) {
      setCurrentLevel("month");
    }
  }, [dropdownOpened]);
  const minTime = minDate ? dayjs(minDate).format("HH:mm:ss") : null;
  const maxTime = maxDate ? dayjs(maxDate).format("HH:mm:ss") : null;
  const __stopPropagation = dropdownType === "popover";
  return /* @__PURE__ */ jsxs(
    PickerInputBase,
    {
      formattedValue,
      dropdownOpened: !rest.disabled ? dropdownOpened : false,
      dropdownHandlers,
      classNames: resolvedClassNames,
      styles: resolvedStyles,
      unstyled,
      ref,
      onClear: () => setValue(null),
      shouldClear: !!_value,
      value: _value,
      size,
      variant,
      dropdownType,
      ...others,
      type: "default",
      __staticSelector: "DateTimePicker",
      children: [
        /* @__PURE__ */ jsx(
          DatePicker,
          {
            ...calendarProps,
            maxDate,
            minDate,
            size,
            variant,
            type: "default",
            value: _value,
            defaultDate: _value,
            onChange: handleDateChange,
            locale,
            classNames: resolvedClassNames,
            styles: resolvedStyles,
            unstyled,
            __staticSelector: "DateTimePicker",
            __stopPropagation,
            level,
            defaultLevel,
            onLevelChange: (_level) => {
              setCurrentLevel(_level);
              calendarProps.onLevelChange?.(_level);
            },
            __timezoneApplied: true
          }
        ),
        currentLevel === "month" && /* @__PURE__ */ jsxs("div", { ...getStyles("timeWrapper"), children: [
          /* @__PURE__ */ jsx(
            TimeInput,
            {
              value: timeValue,
              withSeconds,
              ref: timeInputRefMerged,
              unstyled,
              minTime: _value && minDate && _value.toDateString() === minDate.toDateString() ? minTime != null ? minTime : void 0 : void 0,
              maxTime: _value && maxDate && _value.toDateString() === maxDate.toDateString() ? maxTime != null ? maxTime : void 0 : void 0,
              ...timeInputProps,
              ...getStyles("timeInput", {
                className: timeInputProps?.className,
                style: timeInputProps?.style
              }),
              onChange: handleTimeChange,
              onKeyDown: handleTimeInputKeyDown,
              size,
              "data-mantine-stop-propagation": __stopPropagation || void 0
            }
          ),
          /* @__PURE__ */ jsx(
            ActionIcon,
            {
              variant: "default",
              size: `input-${size || "sm"}`,
              ...getStyles("submitButton", {
                className: submitButtonProps?.className,
                style: submitButtonProps?.style
              }),
              unstyled,
              "data-mantine-stop-propagation": __stopPropagation || void 0,
              children: /* @__PURE__ */ jsx(CheckIcon, { size: "30%" }),
              ...submitButtonProps,
              onClick: (event) => {
                submitButtonProps?.onClick?.(event);
                dropdownHandlers.close();
              }
            }
          )
        ] })
      ]
    }
  );
});
DateTimePicker.classes = { ...classes, ...PickerInputBase.classes, ...DatePicker.classes };
DateTimePicker.displayName = "@mantine/dates/DateTimePicker";

export { DateTimePicker };
//# sourceMappingURL=DateTimePicker.mjs.map
